/*
 * Copyright (c) 1996-2017 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.api.javax.activation.ActivationDataFlavor;

import java.io.*;
import java.awt.datatransfer.*;
import javax.activation.*;
import com.sun.javatest.*;
import com.sun.javatest.lib.MultiTest; 

/**
 * We first create an object of type ActivationDataFlavor, then call
 * setHumanPresentableName(string) api on that object, we then call
 * getHumanPresentableName() api, if it returns same string value
 * that was passed to setHumanPresentableName() then this testcase
 * passes otherwise it fails.
 */

public class setHumanPresentableName_Test extends MultiTest {

    // main
    public static void main(String[] args)
    { 
	Test t = new setHumanPresentableName_Test(); 
	Status s = t.run(args, new PrintWriter(System.err, true), new PrintWriter(System.out, true)); 
	s.exit(); 
    }


    // Tests for equals:
    public Status testSetHumanPresentableName()
    {
	String humanName = "TextPlain DataFlavor";
	String newHumanName = "Activation TextPlain DataFlavor";

	ActivationDataFlavor adf = new ActivationDataFlavor("text/plain",humanName);

	// make sure it was set right in the constructor:
	if(!(adf.getHumanPresentableName().equals(humanName)))
	    return Status.failed("test failed, original human readable name not set");

	// now try setting it:
	adf.setHumanPresentableName(newHumanName);	// API TEST

	if(adf.getHumanPresentableName().equals(newHumanName))
	    return Status.passed("setHumanPresentableName() test succeeded");
	else
	    return Status.failed("setHumanPresentableName() test failed: " +
                                 adf.getHumanPresentableName() + " != " + newHumanName);
    }
}
