/*
 * Copyright (c) 1996-2017 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.api.javax.activation.ActivationDataFlavor;

import java.io.*;
import java.awt.datatransfer.*;
import javax.activation.*;
import com.sun.javatest.*;
import com.sun.javatest.lib.MultiTest; 

/**
 * We test the isMimeTypeEqual(string) by passing it string objects,
 * if this api returns a boolean {true|false} value then it passes.
 * We test by using equal/not-equal parameter values.
 */

public class isMimeTypeEqual_Test extends MultiTest {

    // main
    public static void main(String[] args)
    {
	Test t = new isMimeTypeEqual_Test(); 
	Status s = t.run(args, new PrintWriter(System.err, true), new PrintWriter(System.out, true)); 
	s.exit(); 
    }

    // Tests for equals:
    public Status testForEquals()
    {
	return callADFEquals("text/plain", "text/plain", true);
    }

    // Tests for not equals:
    public Status testForNotEquals()
    {
	return callADFEquals("text/plain", "image/gif", false);
    }

    // Test for equals with params
    public Status testForEqualsParams()
    {
        return callADFEquals("text/plain; charset=us-ascii; x-java-view=Viewer",
		"text/plain; x-java-view=Viewer; charset=us-ascii", true);
    }

    // Test for not equals with params
    public Status testForNotEqualsParams()
    {
        return callADFEquals("text/plain; charset=us-ascii; x-java-view=Viewer",
		"text/plain; x-java-view=Viewer", true);
    }

    // private implementation methods
    private Status callADFEquals(String adfMimeType,String dfMimeType,
				 boolean expectedResult)
    {
	ActivationDataFlavor adf = new ActivationDataFlavor(adfMimeType,adfMimeType);

	boolean result;
	result = adf.isMimeTypeEqual(dfMimeType);	// API TEST

	if(result == expectedResult)
	    return Status.passed("isMimeTypeEqual() test succeeded");
	else
	    return Status.failed("isMimeTypeEqual() test failed");
    }
}
