/*
 * Decompiled with CFR 0.152.
 */
package javasoft.sqe.javatest.lib.apitest;

import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javasoft.sqe.javatest.Status;
import javasoft.sqe.javatest.lib.apitest.AssertionTest;
import javasoft.sqe.javatest.lib.apitest.Factory;
import javasoft.sqe.javatest.lib.apitest.Reporter;

public class PrintReporter
implements Reporter {
    private PrintWriter ref;
    private PrintWriter log;
    private int pass = 0;
    private int fail = 0;
    private Factory[] dataFactories;
    private Object objectUnderTest;
    private Object[] exeParameters;
    private Object result;
    private boolean verbose = false;
    private int[] exeSignature;
    private boolean printData;
    private boolean firstTime = true;
    private boolean shouldShowPoint = false;

    public void init(String[] args, PrintWriter log, PrintWriter ref) throws AssertionTest.Fault {
        this.log = log;
        this.ref = ref;
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-verbose")) {
                    this.verbose = true;
                } else if (args[i].equals("-showpoint")) {
                    this.shouldShowPoint = true;
                }
                if (!args[i].equals("-generator")) continue;
                throw new AssertionTest.Fault("There was no -end at the end of Argument list for the Reporter");
            }
        }
    }

    public void reportTestStart(Method methodName, Factory[] f) {
        this.dataFactories = f;
        this.ref.println("----------------------------------------------------------------");
        this.ref.println("               AssertionTest Report                             ");
        this.ref.println("----------------------------------------------------------------");
        this.ref.println(" Method Name     : " + methodName.toString());
        this.ref.println(" Class  Name     : " + methodName.getDeclaringClass().toString());
        this.ref.println("----------------------------------------------------------------");
        this.ref.flush();
    }

    public void reportTestStart(Constructor constructorName, Factory[] f) {
        this.dataFactories = f;
        this.ref.println("----------------------------------------------------------------");
        this.ref.println("               AssertionTest Report                             ");
        this.ref.println("----------------------------------------------------------------");
        this.ref.println(" Method Name     : " + constructorName.toString());
        this.ref.println(" Class  Name     : " + constructorName.getDeclaringClass().toString());
        this.ref.println("----------------------------------------------------------------");
        this.ref.flush();
    }

    public void reportAssertion(String s, boolean b) {
        if (!b) {
            if (this.firstTime) {
                this.firstTime = false;
                this.printTestData();
                this.ref.println(" List of Assertion Failures:");
            }
            this.ref.println("  - " + s);
        }
    }

    public void reportTestResult(Object res, Status s) {
        this.result = res;
        if (s.getType() == 0) {
            ++this.pass;
        } else {
            this.printTestData();
            ++this.fail;
            if (this.verbose) {
                this.ref.println(" Test Returned             : " + this.result);
            }
            this.ref.println(" Test Status               : " + s.getReason());
            this.ref.println("--------------------------------------------------------------");
        }
        this.ref.flush();
    }

    public void reportException(Throwable t) {
        if (this.firstTime) {
            this.firstTime = false;
            this.printTestData();
        }
        this.ref.println("Exception Raised during Testing : ");
        t.printStackTrace(this.ref);
        this.ref.flush();
    }

    public void reportTestData(Object objectUnderTest, Object[] exeParameters, int[] exeSignature) {
        this.printData = true;
        this.firstTime = true;
        this.objectUnderTest = objectUnderTest;
        this.exeParameters = exeParameters;
        this.exeSignature = exeSignature;
        if (this.shouldShowPoint) {
            this.log.print("Execution Signature at this point: ");
            for (int i = 0; i < exeSignature.length; ++i) {
                this.log.print(exeSignature[i]);
            }
            this.log.println("");
        }
    }

    public void reportTestDone(Status overallStatus) {
        String status = new String();
        status = overallStatus.getType() == 0 ? "Passed" : "Failed";
        this.ref.println("--------------------------------------------------------------------");
        this.ref.println("               Overall AssertionTest Result Summary                 ");
        this.ref.println("--------------------------------------------------------------------");
        this.ref.println(" Overall Test Status        : " + status);
        this.ref.println(" Total Number of Tests      : " + (this.pass + this.fail));
        this.ref.println(" Total Tests Passed         : " + this.pass);
        this.ref.println(" Total Tests Failed         : " + this.fail);
        this.ref.println("--------------------------------------------------------------------");
        this.ref.flush();
    }

    private void printTestData() {
        if (this.printData) {
            int i;
            this.printData = false;
            this.ref.println("--------------------------------------------------------------");
            if (this.verbose) {
                this.ref.print(" Parameter Passed          : ");
                for (i = 0; i < this.exeParameters.length; ++i) {
                    this.ref.print(this.exeParameters[i] + " ");
                }
                this.ref.println("");
                this.ref.println(" Object Under Test         : " + this.objectUnderTest);
            }
            this.ref.print(" Index of factory objects  : ");
            for (i = 0; i < this.exeSignature.length; ++i) {
                if (i == this.exeSignature.length - 1) {
                    this.ref.print(this.exeSignature[i]);
                    continue;
                }
                this.ref.print(this.exeSignature[i] + ":");
            }
            this.ref.println("");
        }
    }
}

