/*
 * Decompiled with CFR 0.152.
 */
package javasoft.sqe.javatest.lib;

import java.io.PrintWriter;
import javasoft.sqe.javatest.Status;

public class MultiStatus {
    private int iTestCases = 0;
    private int iPassed = 0;
    private int iFail = 0;
    private int iBad = 0;
    private String firstTest = "";
    private PrintWriter out = null;

    public MultiStatus() {
    }

    public MultiStatus(PrintWriter out) {
        this.out = out;
    }

    public int getTestCount() {
        return this.iTestCases;
    }

    public void add(String testID, Status status) {
        if (this.out != null) {
            this.out.println(testID + ": " + status);
        }
        ++this.iTestCases;
        if (status != null) {
            switch (status.getType()) {
                case 0: {
                    ++this.iPassed;
                    return;
                }
                case 1: {
                    if (this.iFail == 0 && this.iBad == 0) {
                        this.firstTest = testID;
                    }
                    ++this.iFail;
                    return;
                }
            }
        }
        if (this.iBad == 0) {
            this.firstTest = testID;
        }
        ++this.iBad;
    }

    public Status getStatus() {
        String summary;
        if (this.out != null) {
            this.out.flush();
        }
        if (this.iTestCases == 0) {
            summary = "No tests cases found (or all test cases excluded.)";
        } else {
            summary = "test cases: " + this.iTestCases;
            if (this.iPassed > 0) {
                summary = this.iPassed == this.iTestCases ? summary + "; all passed" : summary + "; passed: " + this.iPassed;
            }
            if (this.iFail > 0) {
                summary = this.iFail == this.iTestCases ? summary + "; all failed" : summary + "; failed: " + this.iFail;
            }
            if (this.iBad > 0) {
                summary = this.iBad == this.iTestCases ? summary + "; all have bad status" : summary + "; bad status: " + this.iBad;
            }
        }
        if (this.iBad > 0) {
            return Status.failed(summary + "; first bad test case found: " + this.firstTest);
        }
        if (this.iFail > 0) {
            return Status.failed(summary + "; first test case failure: " + this.firstTest);
        }
        return Status.passed(summary);
    }

    public static Status overallStatus(String[] testIDs, Status[] status, PrintWriter out) {
        if (testIDs.length != status.length) {
            return Status.failed("mismatched array sizes; test cases: " + testIDs.length + " statuses: " + status.length);
        }
        MultiStatus ms = new MultiStatus(out);
        for (int i = 0; i < status.length; ++i) {
            ms.add(testIDs[i], status[i]);
        }
        return ms.getStatus();
    }

    public static Status overallStatus(String[] testIDs, Status[] status) {
        return MultiStatus.overallStatus(testIDs, status, null);
    }
}

