/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.services;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestSuite;
import com.sun.javatest.services.TestPath;
import com.sun.jck.services.AbstractService;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestMapping
extends TestPath {
    Set<String> keywords;

    public TestMapping(TestSuite testSuite, String string, String string2) {
        super(testSuite, string, string2);
        this.keywords = this.getKeywords(string);
    }

    public Set<String> getKeywords(String string) {
        if (this.keywords != null) {
            return this.keywords;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        this.keywords = new HashSet<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.keywords.add(string2.trim());
        }
        return this.keywords;
    }

    @Override
    public boolean matches(TestDescription testDescription) {
        String[] stringArray;
        if (this.keywords.isEmpty()) {
            return true;
        }
        for (String string : stringArray = testDescription.getKeywords()) {
            if (!this.keywords.contains(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getServices() {
        Set<String> set = super.getServices();
        HashSet<String> hashSet = null;
        for (String string : set) {
            try {
                AbstractService abstractService = (AbstractService)this.mgr.getAllServices().get(string);
                if (abstractService.enabled()) continue;
                if (hashSet == null) {
                    hashSet = new HashSet<String>(set);
                }
                hashSet.remove(string);
            }
            catch (ClassCastException classCastException) {
                Logger.getLogger(TestMapping.class.getName()).log(Level.WARNING, null, classCastException);
            }
        }
        return hashSet == null ? set : hashSet;
    }
}

