/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.services;

import com.sun.javatest.TestEnvironment;
import com.sun.javatest.services.ProcessParams;
import com.sun.javatest.services.ServiceProperties;
import com.sun.jck.interview.Utils;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommandBuilder {
    private ServiceProperties props;
    private String command;

    public CommandBuilder(ServiceProperties serviceProperties) {
        this.props = serviceProperties;
    }

    public void setProperty(String string, String string2) {
        Properties properties = this.getProps().getExternalProperties();
        String string3 = properties.getProperty(string);
        this.setValue(string3, string2);
    }

    public void setValue(String string, String string2) {
        if (string == null) {
            return;
        }
        this.command = this.command == null ? string : this.command.replace(string2, Utils.adjust(string));
    }

    public String getCommand() throws CommandBuilderException {
        return this.command;
    }

    protected List<String> constructCommand() throws CommandBuilderException {
        try {
            TestEnvironment testEnvironment = new TestEnvironment("", new HashMap(), "");
            List<String> list = Arrays.asList(testEnvironment.resolve(this.getCommand()));
            return list;
        }
        catch (TestEnvironment.Fault fault) {
            throw new CommandBuilderException((Throwable)fault);
        }
    }

    protected ServiceProperties getProps() {
        return this.props;
    }

    protected <T extends ProcessParams> T setWorkDir(T t) {
        Properties properties = this.getProps().getExternalProperties();
        File file = new File(properties.getProperty("testsuite.root"));
        t.setWorkDirectory(file);
        return t;
    }

    public class CommandBuilderException
    extends Exception {
        public CommandBuilderException(String string) {
            super(string);
        }

        public CommandBuilderException(Throwable throwable) {
            super(throwable);
        }
    }
}

