/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib.multijvm.group.util;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static volatile ScheduledExecutorService timer;

    public static <T> T[] join(T[] ... TArray) {
        if (TArray == null || TArray.length == 0) {
            throw new IllegalArgumentException("Cannot join null or an empty array");
        }
        int n = 0;
        for (T[] TArray2 : TArray) {
            if (TArray2 == null) continue;
            n += TArray2.length;
        }
        if (n == 0) {
            throw new IllegalArgumentException("All arrays to join are null");
        }
        Class<?> clazz = TArray.getClass().getComponentType().getComponentType();
        Object[] objectArray = (Object[])Array.newInstance(clazz, n);
        int n2 = 0;
        for (T t : TArray) {
            if (t == null) continue;
            for (T t2 : t) {
                objectArray[n2++] = t2;
            }
        }
        return objectArray;
    }

    public static int getFreePort() throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        int n = -1;
        ServerSocket serverSocket = null;
        if (securityManager != null) {
            securityManager.checkListen(0);
        }
        serverSocket = new ServerSocket(0);
        n = serverSocket.getLocalPort();
        serverSocket.close();
        return n;
    }

    public static Map<String, String> parseVariables(List<String> list) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (String string : list) {
            int n = string.indexOf(61);
            if (n == -1) {
                throw new IllegalArgumentException("'=' is not found in " + string);
            }
            linkedHashMap.put(string.substring(0, n), string.substring(n + 1, string.length()));
        }
        return linkedHashMap;
    }

    public static <T> List<T> listOf(T ... TArray) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t : TArray) {
            if (t == null) continue;
            arrayList.add(t);
        }
        return arrayList;
    }

    public static void decodeAllArgs(List<String> list, ArgHandler argHandler) {
        int n;
        for (int i = 0; i < list.size(); i += n) {
            n = argHandler.decodeArg(list, i);
            if (n != 0) continue;
            throw new IllegalArgumentException("Unknown: " + list.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScheduledFuture scheduleClose(final Closeable closeable, long l) {
        Class<Util> clazz = Util.class;
        synchronized (Util.class) {
            if (timer == null) {
                timer = Executors.newSingleThreadScheduledExecutor();
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return timer.schedule(new Runnable(){

                public void run() {
                    if (!Thread.interrupted()) {
                        try {
                            closeable.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }, l, TimeUnit.MILLISECONDS);
        }
    }

    public static void cancelClose(ScheduledFuture scheduledFuture) {
        if (scheduledFuture != null && !scheduledFuture.isDone()) {
            if (scheduledFuture.getDelay(TimeUnit.MILLISECONDS) > 0L) {
                scheduledFuture.cancel(true);
            } else {
                try {
                    scheduledFuture.get();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
        }
    }

    public static void printLog(Object object, String string) {
        System.err.print(object.toString() + ": ");
        System.err.println(string);
        System.err.flush();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ArgHandler {
        public int decodeArg(List<String> var1, int var2);
    }
}

