/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib.multijvm.group.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class StreamsCopier {
    private Copier outCopier;
    private Copier errCopier;
    private Future outFuture;
    private Future errFuture;
    private String prefix;

    public StreamsCopier() {
        this.outCopier = new Copier(null);
        this.errCopier = new Copier(null);
    }

    public StreamsCopier(PrintWriter printWriter, PrintWriter printWriter2) {
        this.outCopier = new Copier(printWriter);
        this.errCopier = new Copier(printWriter2);
    }

    public StreamsCopier(PrintWriter printWriter, PrintWriter printWriter2, String string) {
        this.outCopier = new Copier(printWriter);
        this.errCopier = new Copier(printWriter2);
        this.prefix = string;
    }

    public void start(ExecutorService executorService, Process process) {
        this.outCopier.setIn(process.getInputStream());
        this.errCopier.setIn(process.getErrorStream());
        this.outFuture = executorService.submit(this.outCopier);
        this.errFuture = executorService.submit(this.errCopier);
    }

    public void connectTo(PrintWriter printWriter, PrintWriter printWriter2) {
        this.outCopier.setOut(printWriter);
        this.errCopier.setOut(printWriter2);
    }

    public void disconnect() {
        this.outCopier.setOut(null);
        this.errCopier.setOut(null);
    }

    public void waitLineOut() throws InterruptedException {
        this.outCopier.firstLine.await();
    }

    public void waitLineErr() throws InterruptedException {
        this.errCopier.firstLine.await();
    }

    private void waitUnitDoneInternal(Future future) {
        try {
            if (future != null && !future.isCancelled()) {
                future.get();
            }
        }
        catch (ExecutionException executionException) {
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public void waitUntilDone() {
        this.disconnect();
        this.waitUnitDoneInternal(this.outFuture);
        this.waitUnitDoneInternal(this.errFuture);
    }

    public PrintWriter getOut() {
        return this.outCopier.out;
    }

    public PrintWriter getErr() {
        return this.errCopier.out;
    }

    class Copier
    implements Runnable {
        BufferedReader in;
        PrintWriter out;
        CountDownLatch firstLine = new CountDownLatch(1);

        Copier(PrintWriter printWriter) {
            this.out = printWriter;
        }

        synchronized void setIn(InputStream inputStream) {
            if (this.in != null) {
                throw new IllegalArgumentException("in has already been set");
            }
            this.in = new BufferedReader(new InputStreamReader(inputStream));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String string;
                while ((string = this.in.readLine()) != null) {
                    this.print(string);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.flush();
                if (this.firstLine.getCount() != 0L) {
                    this.firstLine.countDown();
                }
            }
        }

        synchronized void setOut(PrintWriter printWriter) {
            if (this.out != printWriter) {
                this.flush();
                this.out = printWriter;
            }
        }

        synchronized void flush() {
            if (this.out != null) {
                this.out.flush();
            }
        }

        synchronized void print(String string) {
            if (this.firstLine.getCount() != 0L) {
                this.firstLine.countDown();
            }
            if (this.out != null) {
                if (StreamsCopier.this.prefix != null) {
                    this.out.write(StreamsCopier.this.prefix);
                }
                this.out.println(string);
            }
        }
    }
}

