/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib.jck4jdk;

import com.sun.javatest.Harness;
import com.sun.javatest.JavaTestSecurityManager;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.jck.lib.jck4jdk.BadArgs;
import com.sun.jck.lib.jck4jdk.HarnessObserver;
import com.sun.jck.lib.jck4jdk.Help;
import com.sun.jck.lib.jck4jdk.Option;
import com.sun.jck.lib.jck4jdk.OptionDecoder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Main {
    public static final String PACKAGE = "com.sun.jck.lib.jck4jdk";
    private static final String SEP = File.separator;
    private static String[] FREE_PORT_ENVVARS = new String[]{"remote.agent.port", "rmid.port", "orb.port", "jdwp.port", "passive.agent.port"};
    private static String[] KNOWN_64_ARCH = new String[]{"amd64", "x64", "sparcv9"};
    public static final String BASIC = "basic";
    public static final String ADVANCED = "adv";
    public static final String SELECT = "select";
    public static final String JDK = "jdk";
    public static final String DOC = "doc";
    public static final String JTI_TEMPALTE = "%s-%s-%s-RI.jti";
    Option[] options = new Option[]{new Option(Option.ArgType.OPT, "basic", "verbose", new String[]{"v", "verbose"}){

        @Override
        public String[] getChoices() {
            return new String[]{"jtr", "non-pass"};
        }

        @Override
        public void process(String opt, String arg) throws BadArgs {
            Main.this.verboseFlag = true;
            Main.export("verbose", "");
            if (arg == null) {
                return;
            }
            for (String v : arg.trim().split(",")) {
                if (Arrays.binarySearch(this.getChoices(), v) < 0) {
                    throw new BadArgs(i18n, "opt.arg.unknown", v);
                }
                Main.export("verbose." + v, true);
            }
        }
    }, new Option(Option.ArgType.NONE, "adv", "GUI", new String[]{"c", "check"}){

        @Override
        public void process(String opt, String arg) {
            Main.this.checkFlag = true;
        }
    }, new Option(Option.ArgType.OLD, "basic", null, new String[]{"w", "workDir"}){

        @Override
        public void process(String opt, String arg) {
            Main.this.workDir = new File(arg);
        }
    }, new Option(Option.ArgType.OLD, null, null, new String[]{"extra", "extraDir"}){

        @Override
        public void process(String opt, String arg) {
            Main.this.extraDir = new File(arg);
        }
    }, new Option(Option.ArgType.OLD, "adv", null, new String[]{"r", "reportDir"}){

        @Override
        public void process(String opt, String arg) {
            Main.this.reportDir = new File(arg);
        }
    }, new Option(Option.ArgType.OLD, "adv", null, new String[]{"timeout"}){

        @Override
        public void process(String opt, String arg) throws BadArgs {
            try {
                Main.this.timeout = Float.valueOf(arg);
            }
            catch (NumberFormatException e) {
                throw new BadArgs(i18n, "main.badTimeout", arg);
            }
        }
    }, new Option(Option.ArgType.OLD, "adv", null, new String[]{"concurrency"}){

        @Override
        public void process(String opt, String arg) throws BadArgs {
            try {
                Main.this.concurrency = Integer.valueOf(arg);
            }
            catch (NumberFormatException e) {
                throw new BadArgs(i18n, "main.badConcurrency", arg);
            }
        }
    }, new Option(Option.ArgType.OLD, "adv", null, new String[]{"groupSize"}){

        @Override
        public void process(String opt, String arg) throws BadArgs {
            try {
                Main.this.groupSize = Integer.valueOf(arg);
            }
            catch (NumberFormatException e) {
                throw new BadArgs(i18n, "main.badGroupSize", arg);
            }
        }
    }, new Option(Option.ArgType.OLD, "adv", "DISPLAY", new String[]{"display"}){

        @Override
        public void process(String opt, String arg) {
            Main.this.display = arg;
        }
    }, new Option(Option.ArgType.NONE, "adv", "DISPLAY", new String[]{"headless"}){

        @Override
        public void process(String opt, String arg) {
            Main.this.headlessFlag = true;
        }
    }, new Option(Option.ArgType.OLD, "adv", "REMOTE", new String[]{"remote"}){

        @Override
        public void process(String opt, String arg) throws BadArgs {
            int pos = arg.indexOf(58);
            if (pos != -1) {
                Main.this.remoteHost = arg.substring(0, pos);
                try {
                    Main.this.remotePort = Integer.valueOf(arg.substring(pos + 1));
                }
                catch (NumberFormatException e) {
                    throw new BadArgs(i18n, "main.badRemotePort", arg);
                }
            } else {
                Main.this.remoteHost = arg;
                Main.this.remotePort = 1908;
            }
        }
    }, new Option(Option.ArgType.OLD, "select", "", new String[]{"status"}){

        @Override
        public String[] getChoices() {
            return new String[]{"passed", "failed", "not_run", "error"};
        }

        @Override
        public void process(String opt, String arg) {
            Main.access$1402(Main.this, arg.toLowerCase().split(","));
        }
    }, new Option(Option.ArgType.OLD, "adv", "", new String[]{"mode"}){

        @Override
        public String[] getChoices() {
            return new String[]{"multi", "single", "group"};
        }

        @Override
        public void process(String opt, String arg) throws BadArgs {
            try {
                Main.this.mode = Mode.valueOf(arg.toUpperCase());
            }
            catch (IllegalArgumentException ie) {
                throw new BadArgs(i18n, "opt.arg.unknown", arg);
            }
        }
    }, new Option(Option.ArgType.OLD, "select", "JTX", new String[]{"exclude", "exclude/a"}){

        @Override
        public void process(String opt, String arg) throws BadArgs {
            Main.this.excludeAppend = Main.this.endsWithA(opt, arg);
            for (String a : arg.split(",")) {
                File f = new File(a);
                if (!f.isFile()) {
                    throw new BadArgs(i18n, "main.cantFindFile", f);
                }
                try {
                    Main.this.exclude.add(f.getCanonicalPath());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new BadArgs(i18n, "main.error", e.getMessage());
                }
            }
        }
    }, new Option(Option.ArgType.NONE, "select", "JTX", new String[]{"nojtx"}){

        @Override
        public void process(String opt, String arg) {
            Main.this.noJtxFlag = true;
        }
    }, new Option(Option.ArgType.NONE, "adv", "GUI", new String[]{"g", "gui"}){

        @Override
        public void process(String opt, String arg) {
            Main.this.guiFlag = true;
        }
    }, new Option(Option.ArgType.NONE, "adv", null, new String[]{"nosound"}){

        @Override
        public void process(String opt, String arg) {
            Main.this.noSoundFlag = true;
        }
    }, new Option(Option.ArgType.NONE, "adv", null, new String[]{"Xcompile"}){

        @Override
        public void process(String opt, String arg) {
            Main.this.precompileFlag = true;
        }
    }, new Option(Option.ArgType.NONE, "adv", null, new String[]{"d64"}){

        @Override
        public void process(String opt, String arg) {
            Main.this.bits = "64bit";
        }
    }, new Option(Option.ArgType.NONE, "basic", null, new String[]{"version"}){

        @Override
        public void process(String opt, String arg) {
            Main.this.versionFlag = true;
        }
    }, new Option(Option.ArgType.OLD, "adv", null, new String[]{"jtoptions"}){

        @Override
        public void process(String opt, String arg) {
            Main.parseJavaTestArgs(arg, Main.this.jtArgs);
        }
    }, new Option(Option.ArgType.OLD, "adv", null, new String[]{"jtoptions/a"}){

        @Override
        public void process(String opt, String arg) {
            Main.parseJavaTestArgs(arg, Main.this.jtArgsAppend);
        }
    }, new Option(Option.ArgType.OLD, "select", null, new String[]{"k", "keywords", "keywords/a"}){

        @Override
        public void process(String opt, String arg) {
            Main.this.keywordsAppend = Main.this.endsWithA(opt, arg);
            Main.this.keywords = arg;
        }
    }, new Option(Option.ArgType.OLD, "basic", "", new String[]{"jdk", "testjdk"}){

        @Override
        public void process(String opt, String arg) {
            Main.this.jdk = new File(arg);
        }
    }, new Option(Option.ArgType.OLD, null, "", new String[]{"refjdk"}){

        @Override
        public void process(String opt, String arg) {
            Main.this.refJdk = new File(arg);
        }
    }, new Option(Option.ArgType.OLD, "jdk", "", new String[]{"cp", "classpath", "classpath/a"}){

        @Override
        public void process(String opt, String arg) {
            Main.this.excludeAppend = Main.this.endsWithA(opt, arg);
            arg = arg.trim();
            if (arg.length() == 0) {
                return;
            }
            for (String f : arg.split(File.pathSeparator)) {
                if (f.length() == 0) continue;
                Main.this.classPath.add(new File(f));
            }
        }
    }, new Option(Option.ArgType.OLD, null, "", new String[]{"libpath"}){

        @Override
        public void process(String opt, String arg) throws BadArgs {
            Main.this.libPath = arg;
        }
    }, new Option(Option.ArgType.OLD, null, "", new String[]{"jmxpath"}){

        @Override
        public void process(String opt, String arg) throws BadArgs {
            Main.this.jmxResPath = arg;
        }
    }, new Option(Option.ArgType.OLD, "basic", "", new String[]{"vmoptions", "vmoptions/a"}){

        @Override
        public void process(String opt, String arg) {
            Main.this.vmOptsAppend = Main.this.endsWithA(opt, arg);
            Main.this.vmOpts = arg;
        }
    }, new Option(Option.ArgType.OLD, "basic", "", new String[]{"env", "env/a"}){

        @Override
        public void process(String opt, String arg) {
            Main.this.envVarsAppend = Main.this.endsWithA(opt, arg);
            Main.this.envVars = arg;
        }
    }, new Option(Option.ArgType.OLD, null, "", new String[]{"refenv", "refenv/a"}){

        @Override
        public void process(String opt, String arg) {
            Main.this.refEnvVarsAppend = Main.this.endsWithA(opt, arg);
            Main.this.refEnvVars = arg;
        }
    }, new Option(Option.ArgType.OLD, "adv", "", new String[]{"refvmoptions", "refvmoptions/a"}){

        @Override
        public void process(String opt, String arg) {
            Main.this.refVmOptsAppend = Main.this.endsWithA(opt, arg);
            Main.this.refVmOpts = arg;
        }
    }, new Option(Option.ArgType.OLD, "basic", "", new String[]{"javacoptions", "javacoptions/a"}){

        @Override
        public void process(String opt, String arg) {
            Main.this.javacOptsAppend = Main.this.endsWithA(opt, arg);
            Main.this.javacOpts = arg;
        }
    }, new Option(Option.ArgType.OLD, "adv", "", new String[]{"cfg", "config"}){

        @Override
        public void process(String opt, String arg) throws BadArgs {
            try {
                Main.this.cmdlineProps = new Properties();
                Main.this.cmdlineProps.load(new FileReader(arg));
            }
            catch (IOException ioe) {
                throw new BadArgs(i18n, "main.cantFindFile", arg);
            }
        }
    }, new Option(Option.ArgType.NONE, "basic", "help", new String[]{"h", "help", "usage"}){

        @Override
        public void process(String opt, String arg) {
            if (Main.this.help == null) {
                Main.this.help = new Help(Main.this.options);
            }
            Main.this.help.setCommandLineHelpQuery("all");
        }
    }, new Option(Option.ArgType.FILE, "basic", null, new String[0]){

        @Override
        public void process(String opt, String arg) {
            Main.this.tests.add(arg);
        }
    }};
    public static final int EXIT_OK = 0;
    public static final int EXIT_TEST_FAILED = 1;
    public static final int EXIT_TEST_ERROR = 2;
    public static final int EXIT_BAD_ARGS = 3;
    public static final int EXIT_FAULT = 4;
    public static final int EXIT_EXCEPTION = 5;
    private PrintWriter out;
    private PrintWriter err;
    private String os;
    private String osShort;
    private String arch;
    private File jdk;
    private File refJdk;
    private File jck;
    private File extraDir;
    private File extraBinDir;
    private String libPath;
    private String jmxResPath;
    private File jtiFile;
    private String jckVer;
    private String jckMilestone;
    private String jckBuild;
    private String jckJdkVer;
    private String jckJdkMilestone;
    private String jckJdkBuild;
    private String jckSuite;
    private String templateName;
    private TestSuite testSuite;
    private String display;
    private List<String> exclude = new ArrayList<String>();
    private List<String> extraExclude = new ArrayList<String>();
    private String keywords;
    private Integer concurrency;
    private Float timeout;
    private String[] priorStatus;
    private Properties props = new Properties();
    private File workDir;
    private File reportDir;
    private List<String> tests = new ArrayList<String>();
    private boolean guiFlag;
    private boolean headlessFlag;
    private boolean noSoundFlag;
    private boolean noJtxFlag;
    private boolean checkFlag;
    private boolean versionFlag;
    private boolean precompileFlag;
    private boolean keywordsAppend;
    private boolean classPathAppend;
    private boolean excludeAppend;
    private boolean vmOptsAppend;
    private boolean refVmOptsAppend;
    private boolean javacOptsAppend;
    private boolean envVarsAppend;
    private boolean refEnvVarsAppend;
    private String vmOpts;
    private String refVmOpts;
    private String javacOpts;
    private String envVars;
    private String refEnvVars;
    private String bits;
    private String precompileRes = "res/precompile.jtc";
    private Mode mode = Mode.GROUP;
    private String remoteHost;
    private int remotePort;
    private List<String> jtArgs = new ArrayList<String>();
    private List<String> jtArgsAppend = new ArrayList<String>();
    private Properties cmdlineProps;
    private Properties templateProps = new Properties();
    private boolean verboseFlag;
    private List<File> classPath = new ArrayList<File>();
    private TestEnvironment env;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Main.class);
    private Integer groupSize;
    private Help help;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Main.export("start", System.currentTimeMillis());
        Main.export("args", Arrays.toString(args));
        PrintWriter out = new PrintWriter(System.out, true);
        PrintWriter err = new PrintWriter(System.err, true);
        Main m = new Main(out, err);
        try {
            int rc;
            try {
                rc = m.run(args);
            }
            finally {
                out.flush();
                err.flush();
            }
            if (!m.guiFlag || rc != 0) {
                Main.exit(rc);
            }
        }
        catch (Harness.Fault e) {
            err.println(i18n.getString("main.error", e.getMessage()));
            Main.exit(4);
        }
        catch (Fault e) {
            err.println(i18n.getString("main.error", e.getMessage()));
            Main.exit(4);
        }
        catch (BadArgs e) {
            err.println(i18n.getString("main.badArgs", e.getMessage()));
            Main.exit(3);
        }
        catch (Exception e) {
            err.println(i18n.getString("main.unexpectedException"));
            e.printStackTrace();
            Main.exit(5);
        }
    }

    public Main() {
        this(new PrintWriter(System.out, true), new PrintWriter(System.err, true));
    }

    public Main(PrintWriter out, PrintWriter err) {
        this.out = out;
        this.err = err;
    }

    public final int run(String[] args) throws Exception {
        new OptionDecoder(this.options).decodeArgs(Main.expandAtFiles(args));
        if (this.help != null) {
            this.help.showCommandLineHelp(this.out);
            this.out.flush();
            return 0;
        }
        this.initEnvironment();
        this.initJDKPath();
        this.initOsArch();
        this.initJCK();
        this.initExtraDir();
        this.initWorkDir();
        this.initJDKProp();
        this.initKeywords();
        this.initExcludeList();
        this.initOther();
        this.initMode();
        this.initServices();
        if (this.precompileFlag) {
            this.initCompile();
        }
        this.initTests();
        this.initConfig();
        this.initJavaTestArgs();
        if (this.versionFlag) {
            this.out.println(i18n.getString("main.version.text", new String[]{this.testSuite.getID(), this.jckMilestone, this.jckBuild, this.jckJdkVer, this.jckJdkMilestone, this.jckJdkBuild}));
        } else if (this.checkFlag) {
            this.out.println(i18n.getString("main.chk", this.jtiFile));
        } else {
            com.sun.javatest.tool.Main.main(this.jtArgs.toArray(new String[0]));
        }
        return 0;
    }

    private void initCompile() throws IOException, TestEnvironment.Fault, Fault {
        if (!"runtime".equals(this.jckSuite)) {
            throw new Fault("main.compileNoSupported", this.jckSuite);
        }
        this.jtArgs.add("-EsysProps");
        File precompileDir = new File(this.workDir, "precompile");
        this.jtArgs.add("-EprecompileClassDir=" + precompileDir + SEP + "classes");
        this.jtArgs.add("-startServices");
        this.jtArgs.add("manually");
        Properties precompileProps = new Properties();
        precompileProps.load(this.getClass().getResourceAsStream(this.precompileRes));
        this.env.put("precompileClassDir", "$precompileClassDir");
        this.env.put("testSource", "$testSource");
        this.env.put("testWorkDir", "$testWorkDir");
        if (this.groupSize != null) {
            this.env.put("qa.xcompile.groupsize", this.groupSize.toString());
        } else {
            this.env.put("qa.xcompile.groupsize", "500");
        }
        if (this.vmOpts != null) {
            this.env.put("qa.xcompile.vmopts", this.vmOpts);
        }
        for (String key : precompileProps.stringPropertyNames()) {
            precompileProps.put(key, this.resolve(this.resolve(precompileProps.getProperty(key))));
        }
        File precompileFile = new File(precompileDir, "precompile.jtc");
        precompileDir.mkdirs();
        precompileProps.store(new FileWriter(precompileFile), null);
        this.props.put("jck.env.runtime.refCompileFile", precompileFile.toString());
        this.props.put("jck.keywords.needKeywords", "Yes");
        this.props.put("jck.keywords.keywords.mode", "Expr");
        this.appendProp("jck.keywords.keywords.value", "!java_to_schema&!serial", true, "&");
        if (this.tests.size() == 0) {
            this.tests.add("api");
        }
    }

    private void initServices() throws IOException {
        if (this.remoteHost != null) {
            this.props.put("jck.env.runtime.remoteAgent.passiveHost", this.remoteHost);
            this.props.put("jck.env.runtime.remoteAgent.passivePort", String.valueOf(this.remotePort));
            InetAddress hostAddr = InetAddress.getByName(this.remoteHost);
            if (hostAddr.isLoopbackAddress()) {
                return;
            }
            InetAddress local = InetAddress.getLocalHost();
            if (local.equals(hostAddr)) {
                return;
            }
            if ("windows".equals(this.os)) {
                String KEY = "jck.env.runtime.remoteAgent.serviceCommand";
                String cmd = this.props.getProperty("jck.env.runtime.remoteAgent.serviceCommand");
                String jdkMks = this.jdk.getCanonicalPath().replace('\\', '/');
                String jckMks = this.jck.getCanonicalPath().replace('\\', '/');
                cmd = cmd.replace('\\', '/').replaceAll(";", "\\\\;").replace("@{java.home}", jdkMks).replace("@{testsuite}", jckMks);
                this.props.put("jck.env.runtime.remoteAgent.serviceCommand", cmd);
            }
        }
    }

    private void setOsShell(String shell) throws Fault {
        if (!new File(shell).isFile() && (shell = System.getenv("SHELL")) == null) {
            throw new Fault("unknownShell", new Object[0]);
        }
        this.env.put("os.shell", shell);
    }

    private void initConfig() throws IOException, TestEnvironment.Fault {
        this.templateProps.putAll((Map<?, ?>)this.props);
        if (this.cmdlineProps != null) {
            this.templateProps.putAll((Map<?, ?>)this.cmdlineProps);
        }
        for (String key : this.templateProps.stringPropertyNames()) {
            this.templateProps.put(key, this.resolve(this.templateProps.getProperty(key)));
        }
        this.jtiFile = new File(this.workDir, "config.jti").getCanonicalFile();
        this.templateProps.store(new FileWriter(this.jtiFile), "JCK configuration");
    }

    private void initEnvironment() throws TestEnvironment.Fault, IOException {
        HashMap<String, String> map = new HashMap<String, String>(){
            {
                this.put("qa.local.host.name", Main.this.getLocalHostName());
                this.put("qa.local.host.ip", Main.this.getLocalHostIP());
                for (String s : FREE_PORT_ENVVARS) {
                    this.put("qa." + s, Main.this.getFreePort());
                }
            }
        };
        this.env = new TestEnvironment("", map, "");
        this.env.put("testSuiteRootDir", "$testSuiteRootDir");
        this.env.put("pound.sign", "#");
        this.env.put("quote.sign", "\"");
    }

    private void initExcludeList() {
        if (this.noJtxFlag) {
            this.props.put("jck.excludeList.needExcludeList", "No");
            return;
        }
        if (this.excludeAppend || this.exclude.size() == 0) {
            this.exclude.addAll(this.extraExclude);
        }
        this.props.put("jck.excludeList.customFiles", Main.join(this.exclude, "\n", true));
        this.props.put("jck.excludeList.excludeListType", "custom");
    }

    private void initJavaTestArgs() {
        this.jtArgs.add(0, "-config");
        this.jtArgs.add(1, this.jtiFile.getPath());
        if (!this.guiFlag) {
            this.jtArgs.add("-observer");
            this.jtArgs.add(HarnessObserver.class.getName());
            this.jtArgs.add("-end");
            if (this.groupSize != null) {
                this.jtArgs.add("-Ejck.env.runtime.testExecute.groupMode.groupSize=" + this.groupSize);
                this.jtArgs.add("-Ejck.env.compiler.testCompile.groupMode.groupSize=" + this.groupSize);
                this.jtArgs.add("-Ejck.env.compiler.compRefExecute.groupMode.groupSize=" + this.groupSize);
                this.jtArgs.add("-Ejck.env.devtools.testExecute.groupMode.groupSize=" + this.groupSize);
                this.jtArgs.add("-Ejck.env.devtools.refExecute.groupMode.groupSize=" + this.groupSize);
            }
            this.jtArgs.add("-runTests");
            if (this.reportDir != null) {
                this.jtArgs.add("-writeReport");
                this.jtArgs.add(this.reportDir.toString());
            }
        }
        this.jtArgs.addAll(this.jtArgsAppend);
        Main.export("jtargs", this.jtArgs);
    }

    private void initKeywords() {
        if (this.keywords != null && this.keywords.length() > 0) {
            this.props.put("jck.keywords.needKeywords", "Yes");
            this.props.put("jck.keywords.keywords.mode", "Expr");
            this.appendProp("jck.keywords.keywords.value", this.keywords, this.keywordsAppend, "&");
        }
    }

    private void initTests() throws Fault {
        if (this.tests.size() > 0) {
            for (String t : this.tests) {
                try {
                    new URL(this.jck.toURI().toURL(), "tests/" + t).openStream().close();
                }
                catch (IOException ioe) {
                    throw new Fault("main.badTestURL", new Object[]{ioe});
                }
            }
            this.props.put("jck.tests.needTests", "Yes");
            this.props.put("jck.tests.treeOrFile", "tree");
            this.props.put("jck.tests.tests", Main.join(this.tests, " ", false));
        }
    }

    private void initOsArch() throws IOException, Fault {
        String jdkPropName;
        block11: {
            jdkPropName = this.mode.getJdkPropBaseName();
            this.os = System.getProperty("os.name").toLowerCase();
            if ("sunos".equals(this.os)) {
                this.osShort = this.os = "solaris";
                this.setOsShell("/usr/bin/ksh");
            } else if (this.os.contains("windows")) {
                this.os = "windows";
                this.osShort = "win32";
                jdkPropName = jdkPropName + "_win";
                this.precompileRes = "res/precompile_win.jtc";
            } else if (this.os.contains("linux")) {
                this.osShort = this.os = "linux";
                this.setOsShell("/bin/bash");
            } else {
                throw new Fault("main.unknownOS", this.os);
            }
            this.env.put("os.short", this.osShort);
            String osLong = this.os.substring(0, 1).toUpperCase() + this.os.substring(1);
            this.templateName = String.format(JTI_TEMPALTE, this.mode.modeName, this.mode.getAgentStr(), osLong);
            this.arch = System.getProperty("os.arch").toLowerCase();
            if (this.bits.startsWith("64")) {
                if (Arrays.binarySearch(KNOWN_64_ARCH, this.arch) < 0) {
                    for (String a : KNOWN_64_ARCH) {
                        if (!new File(this.jdk, "jre" + SEP + "lib" + SEP + a).isDirectory()) continue;
                        this.arch = a;
                        break block11;
                    }
                    throw new Fault("main.unknownArch64", this.arch);
                }
            } else if (this.arch.contains("86")) {
                this.arch = "i586";
            }
        }
        this.props.load(this.getClass().getResourceAsStream(jdkPropName + ".properties"));
    }

    private void initJDKPath() throws Fault, IOException {
        if (this.jdk == null) {
            String jre = System.getProperty("java.home");
            this.jdk = new File(jre, ".." + SEP).getCanonicalFile();
        }
        if (!new File(this.jdk, "bin").isDirectory()) {
            throw new Fault("main.badJdkDir", this.jdk);
        }
        this.env.put("qa.ti.home", this.jdk.getCanonicalPath());
        if (this.refJdk == null) {
            this.refJdk = this.jdk;
        }
        this.env.put("qa.refti.home", this.refJdk.getCanonicalPath());
        if (this.bits == null) {
            this.bits = this.vmOpts != null && this.vmOpts.contains("-d64") ? "64bit" : System.getProperty("sun.arch.data.model") + "bit";
        }
    }

    private void initJDKProp() {
        if (this.bits.startsWith("64") && (this.vmOpts == null || !this.vmOpts.contains("-d64"))) {
            this.appendProp("jck.env.runtime.testExecute.otherOpts", "-d64", true, " ");
            this.appendProp("jck.env.compiler.testCompile.testCompileAPImultiJVM.otherOpts", "-d64", true, " ");
        }
        if (this.vmOpts != null) {
            this.appendProp("jck.env.runtime.testExecute.otherOpts", this.vmOpts, this.vmOptsAppend, " ");
            this.appendProp("jck.env.compiler.testCompile.testCompileAPImultiJVM.otherOpts", this.vmOpts, this.vmOptsAppend, " ");
            this.appendProp("jck.env.devtools.testExecute.otherOpts", this.vmOpts, this.vmOptsAppend, " ");
        }
        if (this.refVmOpts != null) {
            this.appendProp("jck.env.compiler.compRefExecute.otherOpts", this.refVmOpts, this.refVmOptsAppend, " ");
            this.appendProp("jck.env.devtools.refExecute.otherOpts", this.refVmOpts, this.refVmOptsAppend, " ");
        }
        if (this.javacOpts != null) {
            this.appendProp("jck.env.compiler.testCompile.otherOpts", this.javacOpts, this.javacOptsAppend, " ");
        }
        if (this.envVars != null) {
            this.appendProp("jck.env.runtime.testExecute.otherEnvVars", this.envVars, this.envVarsAppend, " ");
            this.appendProp("jck.env.compiler.testCompile.testCompileAPImultiJVM.otherEnvVars", this.envVars, this.envVarsAppend, " ");
            this.appendProp("jck.env.devtools.testExecute.otherEnvVars", this.envVars, this.envVarsAppend, " ");
        }
        if (this.refEnvVars != null) {
            this.appendProp("jck.env.compiler.compRefExecute.otherEnvVars", this.refEnvVars, this.refEnvVarsAppend, " ");
            this.appendProp("jck.env.devtools.refExecute.otherEnvVars", this.envVars, this.envVarsAppend, " ");
        }
    }

    private void initExtraDir() throws IOException, Fault {
        if (this.extraDir == null) {
            this.extraDir = new File(this.jck, SEP + ".." + SEP + "JCK-extra-" + this.jckVer).getCanonicalFile();
            if (!this.extraDir.isDirectory()) {
                this.extraDir = new File(this.jck, SEP + ".." + SEP + "extra").getCanonicalFile();
            }
            if (!this.extraDir.isDirectory()) {
                this.extraDir = new File(this.jck, SEP + ".." + SEP + ".." + SEP + "extra").getCanonicalFile();
            }
            if (!this.extraDir.isDirectory()) {
                String buidlDate = this.jck.getParentFile().getName();
                this.extraDir = new File(this.jck, SEP + ".." + SEP + ".." + SEP + ".." + SEP + "extra" + SEP + buidlDate).getCanonicalFile();
            }
            if (!this.extraDir.isDirectory()) {
                if ("runtime".equals(this.jckSuite)) {
                    throw new Fault("main.badExtraDir", new Object[0]);
                }
                if (this.verboseFlag) {
                    this.out.println(i18n.getString("verbose.noExtraDir"));
                }
                return;
            }
        }
        Main.export("extradir", this.extraDir);
        String platform = this.os + "-" + this.arch;
        this.extraBinDir = new File(this.extraDir, "binaries" + SEP + platform);
        if (!this.extraBinDir.isDirectory()) {
            throw new Fault("main.platformNotSupported", platform, this.extraBinDir);
        }
        File cfg = new File(this.extraBinDir, "config" + SEP + this.jckSuite);
        Properties extraProps = new Properties();
        extraProps.load(new FileReader(cfg + SEP + "etc" + SEP + this.templateName));
        this.templateProps.putAll((Map<?, ?>)extraProps);
        this.findExcludeFiles(new File(this.extraDir, "kfl"), "kfl");
        this.findExcludeFiles(new File(this.extraDir, "jtx"), "unsupported.lst");
    }

    private void initOther() throws Fault {
        if (this.concurrency == null) {
            if (this.mode == Mode.SINGLE) {
                this.concurrency = 1;
            } else {
                this.concurrency = Runtime.getRuntime().availableProcessors();
                if (this.concurrency > 20) {
                    this.concurrency = 20;
                }
            }
        }
        if (this.concurrency < 1 || this.concurrency > 50) {
            throw new Fault("main.badConcurrency", this.concurrency);
        }
        this.props.put("jck.concurrency.concurrency", String.valueOf(this.concurrency));
        if (this.timeout != null) {
            if ((double)this.timeout.floatValue() < 0.1 || this.timeout.floatValue() > 100.0f) {
                throw new Fault("main.badTimeout", this.timeout);
            }
            this.props.put("jck.timeout.timeout", String.valueOf(this.timeout));
        }
        if (this.display == null) {
            this.display = System.getenv("DISPLAY");
        }
        if (this.headlessFlag || !"windows".equals(this.os) && (this.display == null || this.display.isEmpty())) {
            this.props.put("jck.env.testPlatform.headless", "Yes");
            this.appendProp("jck.env.runtime.testExecute.otherOpts", "-Djava.awt.headless=true", true, " ");
        } else if (!"windows".equals(this.os)) {
            this.props.put("jck.env.runtime.testExecute.display", this.display);
        }
        if (this.libPath == null && this.extraBinDir != null) {
            this.libPath = new File(this.extraBinDir, "lib" + SEP + this.bits).toString();
        }
        if (this.libPath != null) {
            if (!new File(this.libPath).isDirectory()) {
                throw new Fault("main.badLibPath", this.libPath);
            }
            this.env.put("qa.lib.path", this.libPath);
        }
        if (this.jmxResPath != null) {
            this.props.put("jck.env.runtime.testExecute.jmxResourcePathFileValue", this.jmxResPath.toString());
        }
        if (this.noSoundFlag) {
            this.props.put("jck.env.runtime.audio.canPlaySound", "No");
            this.props.put("jck.env.runtime.audio.canRecordSound", "No");
            this.props.put("jck.env.runtime.audio.canPlayMidi", "No");
        }
        if (this.priorStatus != null) {
            this.props.put("jck.priorStatus.needStatus", "Yes");
            this.props.put("jck.priorStatus.status", Main.join(this.priorStatus, " ", false));
        }
        if (this.classPath.size() > 0) {
            String cp = Main.join(this.classPath, "\n", true);
            this.appendProp("jck.env.runtime.testExecute.additionalClasspath", cp, this.classPathAppend, "\n");
            this.props.put("jck.env.devtools.jaxb.classes.jaxbClasses", "Yes");
            this.appendProp("jck.env.devtools.jaxb.classes.jaxbClasses", cp, this.classPathAppend, "\n");
        }
        if ("windows".equals(this.os)) {
            String winSysRoot = System.getenv("SystemRoot");
            this.env.put("qa.win.systemroot", winSysRoot);
        }
        for (String key : System.getenv().keySet()) {
            if (!"LD_LIBRARY_PATH".equals(key) && (!"PATH".equalsIgnoreCase(key) || !"windows".equals(this.os))) continue;
            this.env.put("qa.process.env", key + "=" + this.libPath);
        }
    }

    private void initMode() {
        if (this.mode == Mode.SINGLE) {
            if ("runtime".equals(this.jckSuite)) {
                this.props.put("jck.keywords.needKeywords", "Yes");
                this.props.put("jck.keywords.keywords.mode", "Expr");
                this.appendProp("jck.keywords.keywords.value", "!only_once&!jvmti&!jvmtilivephase&!jniinvocationapi&!needsharedclassloader&!jdwp", true, "&");
            }
            this.exportSerivceProp("qa.agent.runtime.vmopts", "jck.env.runtime.testExecute.otherOpts");
            this.exportSerivceProp("qa.agent.compiler.vmopts", "jck.env.compiler.testCompile.testCompileAPImultiJVM.otherOpts");
            this.exportSerivceProp("qa.agent.devtools.vmopts", "jck.env.devtools.testExecute.otherOpts");
        }
    }

    private void exportSerivceProp(String keyName, String jtiPropName) {
        String s = this.props.getProperty(jtiPropName);
        if (s != null) {
            s = s.replace("$testSuiteRootDir", "@{testsuite}");
            s = s.replace("${qa.ti.home}", "@{java.home}");
            this.env.put(keyName, s);
        }
    }

    private void initJCK() throws Fault, IOException, TestEnvironment.Fault {
        if (this.jck == null) {
            URL thisClassURL = Main.class.getResource(Main.class.getSimpleName() + ".class");
            try {
                String uri = thisClassURL.toURI().toString();
                int len = uri.indexOf("lib/jtjck.jar!");
                if (len == -1) {
                    throw new Fault("main.badJckDir", uri, "");
                }
                this.jck = new File(new URI(uri.substring(4, len)));
            }
            catch (URISyntaxException e) {
                throw new Fault("main.error", new Object[]{e});
            }
        }
        Properties buildTXT = new Properties();
        try {
            this.env.put("qa.jck.home", this.jck.toString());
            this.env.put("qa.jck.homeurl", this.jck.toURI().toString());
            this.props.put("TESTSUITE", this.jck.toString());
            buildTXT.load(new FileReader(new File(this.jck, "build.txt")));
            this.templateProps.load(new FileReader(this.jck + SEP + this.osShort + SEP + this.templateName));
        }
        catch (IOException ioe) {
            throw new Fault("main.badJckDir", this.jck, ioe);
        }
        this.jckVer = buildTXT.getProperty("JCK_VERSION");
        this.jckMilestone = buildTXT.getProperty("JCK_MILESTONE");
        this.jckBuild = buildTXT.getProperty("JCK_BUILD_ID");
        this.jckJdkVer = buildTXT.getProperty("JDK_VERSION_INT");
        this.jckJdkMilestone = buildTXT.getProperty("JDK_MILESTONE");
        this.jckJdkBuild = buildTXT.getProperty("JDK_BUILD_ID");
        if (this.precompileFlag) {
            System.setProperty("JCKTestSuite.defaultArgs", "-precompile");
            System.setProperty("precompile", "");
        }
        try {
            this.testSuite = TestSuite.open(this.jck);
            this.jckSuite = this.templateProps.getProperty("jck.env.product");
        }
        catch (IOException ex) {
            throw new Fault("main.badJckDir", this.jck, ex.getMessage());
        }
        catch (TestSuite.Fault ex) {
            throw new Fault("main.badJckDir", this.jck, ex.getMessage());
        }
        this.findExcludeFiles(new File(this.jck, "lib"), "jtx");
        Main.export("jck", this.jck);
    }

    private void initWorkDir() throws Fault {
        if (this.workDir == null) {
            this.workDir = new File(this.jck.getName() + "_" + this.jckBuild + "-work");
        }
        try {
            if (this.workDir.exists()) {
                if (WorkDirectory.isWorkDirectory(this.workDir)) {
                    WorkDirectory.open(this.workDir, this.testSuite);
                } else {
                    WorkDirectory.convert(this.workDir, this.testSuite);
                }
            } else {
                WorkDirectory.create(this.workDir, this.testSuite);
            }
            this.props.put("WORKDIR", this.workDir.toString());
            Main.export("workdir", this.workDir);
            String wd = this.workDir.getAbsolutePath();
            if (wd.indexOf(32) != -1) {
                wd = "\"" + wd + "\"";
            }
            this.env.put("javatestWorkDir", wd);
        }
        catch (FileNotFoundException ex) {
            throw new Fault("main.cantFindFile", this.workDir);
        }
        catch (WorkDirectory.Fault ex) {
            throw new Fault("main.badWorkDir", this.workDir, ex.getMessage());
        }
    }

    private static final void exit(int exitCode) {
        SecurityManager sc = System.getSecurityManager();
        if (sc instanceof JavaTestSecurityManager) {
            ((JavaTestSecurityManager)sc).setAllowExit(true);
        }
        System.exit(exitCode);
    }

    private void appendProp(String key, String value, boolean append, String sep) {
        if (append) {
            String old = this.props.getProperty(key);
            if (old == null) {
                old = this.templateProps.getProperty(key);
            }
            if (old != null && old.length() > 0) {
                value = value + sep + old;
            }
        }
        this.props.put(key, value);
    }

    private static String[] expandAtFiles(String[] args) throws Fault {
        ArrayList<String> newArgs = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.length() > 1 && arg.charAt(0) == '@') {
                if ((arg = arg.substring(1)).charAt(0) == '@') {
                    newArgs.add(arg);
                    continue;
                }
                Main.loadCmdFile(arg, newArgs);
                continue;
            }
            newArgs.add(arg);
        }
        return newArgs.toArray(new String[newArgs.size()]);
    }

    private static void loadCmdFile(String name, List<String> args) throws Fault {
        BufferedReader r;
        try {
            r = new BufferedReader(new FileReader(name));
        }
        catch (FileNotFoundException e) {
            throw new Fault("main.cantFindFile", name);
        }
        catch (IOException e) {
            throw new Fault("main.cantOpenFile", name, e);
        }
        try {
            StreamTokenizer st = new StreamTokenizer(r);
            st.resetSyntax();
            st.wordChars(32, 255);
            st.whitespaceChars(0, 32);
            st.commentChar(35);
            st.quoteChar(34);
            st.quoteChar(39);
            while (st.nextToken() != -1) {
                args.add(st.sval);
            }
        }
        catch (IOException e) {
            throw new Fault("main.cantRead", name, e);
        }
        finally {
            try {
                ((Reader)r).close();
            }
            catch (IOException e) {}
        }
    }

    private String getLocalHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    private String getLocalHostIP() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostAddress();
    }

    private String getFreePort() throws IOException {
        ServerSocket s = new ServerSocket(0);
        int port = s.getLocalPort();
        s.close();
        return String.valueOf(port);
    }

    private static <T> String join(T[] array, String sep, boolean appendSep) {
        return Main.join(Arrays.asList(array), sep, appendSep);
    }

    private static <T> String join(List<T> list, String sep, boolean appendSep) {
        StringBuilder sb = new StringBuilder();
        for (T o : list) {
            if (sb.length() > 0) {
                sb.append(sep);
            }
            sb.append(o);
        }
        if (sb.length() > 0 && appendSep) {
            sb.append(sep);
        }
        return sb.toString();
    }

    private String resolve(String property) throws TestEnvironment.Fault {
        String[] v = this.env.resolve(property = property.replace("#", "${pound.sign}").replace("\"", "${quote.sign}"));
        if (v.length == 0) {
            return property;
        }
        return Main.join(v, " ", false);
    }

    private boolean endsWithA(String opt, String arg) {
        int pos = opt.lastIndexOf(arg);
        if (pos != -1) {
            return opt.substring(0, pos).endsWith("a:");
        }
        return opt.endsWith("a");
    }

    private void findExcludeFiles(File dir, String ext) throws IOException {
        if (!dir.isDirectory()) {
            return;
        }
        for (String f : dir.getCanonicalFile().list()) {
            if (!f.endsWith(ext)) continue;
            this.extraExclude.add(dir + SEP + f);
        }
    }

    private static void export(String key, Object value) {
        if (value != null) {
            System.setProperty("com.sun.jck.lib.jck4jdk." + key, value.toString());
        }
    }

    public static void parseJavaTestArgs(String cmd, List<String> args) {
        int i = 0;
        StringBuilder bldr = new StringBuilder();
        block4: while (i < cmd.length()) {
            char ch = cmd.charAt(i++);
            switch (ch) {
                case ' ': {
                    args.add(bldr.toString());
                    bldr.setLength(0);
                    continue block4;
                }
                case '\\': {
                    if (i >= cmd.length()) continue block4;
                    bldr.append(cmd.charAt(i++));
                    continue block4;
                }
            }
            bldr.append(ch);
        }
        if (bldr.length() != 0) {
            args.add(bldr.toString());
        }
    }

    static /* synthetic */ String[] access$1402(Main x0, String[] x1) {
        x0.priorStatus = x1;
        return x1;
    }

    static enum Mode {
        GROUP("multiJVMgroup"),
        MULTI("multiJVM"),
        SINGLE("singleJVM");

        private final String modeName;

        private Mode(String modeName) {
            this.modeName = modeName;
        }

        String getJdkPropBaseName() {
            return "jdk_" + this.toString().toLowerCase() + "_" + this.getAgentStr();
        }

        String getAgentStr() {
            return this == SINGLE ? "agent" : "noagent";
        }
    }

    public static class Fault
    extends Exception {
        static final long serialVersionUID = -6780999176737139046L;

        Fault(String s, Object ... args) {
            super(i18n.getString(s, args));
        }
    }
}

