/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib.jck4jdk;

import com.sun.javatest.Harness;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestResult;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class HarnessObserver
implements Harness.Observer {
    public static final String PACKAGE = "com.sun.jck.lib.jck4jdk";
    private PrintWriter out;
    private PrintWriter err;
    private Map<String, PrintWriter> outMap = new HashMap<String, PrintWriter>();
    private int passed;
    private int failed;
    private int error;
    private File workDir;
    private File repDir;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(HarnessObserver.class);

    public HarnessObserver(String[] args) {
        this.out = new PrintWriter(System.out, true);
        this.err = new PrintWriter(System.err, true);
        try {
            this.workDir = new File(this.getProp("workdir"));
            this.repDir = new File(this.workDir, "jtReport");
            this.repDir.mkdirs();
        }
        catch (Exception e) {
            e.printStackTrace(this.err);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    HarnessObserver.this.writeResultsReport();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    private PrintWriter openTestReport(String status) {
        String file = this.getStringFor(status, "file", new Object[0]);
        try {
            final PrintWriter o = new PrintWriter(new File(this.repDir, file));
            String prlg = this.getResource("html/list_prolog.html");
            o.write(MessageFormat.format(prlg, this.getStringFor(status, "title", new Object[0])));
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    String epilog = HarnessObserver.this.getResource("html/list_epilog.html");
                    o.write(MessageFormat.format(epilog, new Date()));
                    o.close();
                }
            });
            this.outMap.put(status, o);
            return o;
        }
        catch (IOException ioe) {
            ioe.printStackTrace(this.err);
            throw new RuntimeException(ioe);
        }
    }

    private void logTestResult(String status, TestResult tr) {
        String testURL = tr.getTestName();
        PrintWriter o = this.outMap.get(status);
        if (o == null) {
            o = this.openTestReport(status);
        }
        o.println(this.getString("line", tr.getWorkRelativePath(), testURL, tr.getStatus()));
        o.flush();
        if (Boolean.valueOf(this.getProp("verbose.non-pass")).booleanValue() && "pass".equals(status) || this.getProp("verbose") == null) {
            return;
        }
        if (Boolean.valueOf(this.getProp("verbose.jtr")).booleanValue()) {
            this.writeOutputFromTest(this.out, tr);
        } else {
            this.out.println(this.getStringFor(status, "status", testURL));
        }
        this.out.flush();
    }

    @Override
    public void startingTestRun(Parameters params) {
    }

    @Override
    public void stoppingTestRun() {
    }

    @Override
    public void finishedTesting() {
    }

    @Override
    public void finishedTestRun(boolean allOK) {
    }

    @Override
    public synchronized void startingTest(TestResult tr) {
    }

    @Override
    public synchronized void finishedTest(TestResult tr) {
        switch (tr.getStatus().getType()) {
            case 0: {
                ++this.passed;
                this.logTestResult("pass", tr);
                break;
            }
            case 1: {
                ++this.failed;
                this.logTestResult("fail", tr);
                break;
            }
            case 2: {
                ++this.error;
                this.logTestResult("error", tr);
                break;
            }
        }
    }

    private void writeOutputFromTest(PrintWriter out, TestResult tr) {
        char[] line = new char[80];
        Arrays.fill(line, '-');
        out.println(String.valueOf(line));
        out.println("test: " + tr.getTestName());
        for (int i = 0; i < tr.getSectionCount(); ++i) {
            try {
                TestResult.Section s = tr.getSection(i);
                out.println("section: " + s.getTitle());
                for (String outName : s.getOutputNames()) {
                    out.println(s.getOutput(outName));
                }
                out.println("result: " + tr.getStatus());
                continue;
            }
            catch (TestResult.ReloadFault ex) {
                ex.printStackTrace(this.err);
            }
        }
        out.println(String.valueOf(line));
    }

    private void writeResultsReport() throws IOException {
        PrintWriter o = new PrintWriter(new File(this.workDir, "results.html"));
        String prolog = this.getResource("html/results_prolog.html");
        Date start = new Date(Long.parseLong(this.getProp("start")));
        long s = (System.currentTimeMillis() - start.getTime()) / 1000L;
        String dur = String.format("%d:%02d:%02d", s / 3600L, s % 3600L / 60L, s % 60L);
        o.print(MessageFormat.format(prolog, InetAddress.getLocalHost().getCanonicalHostName(), this.getProp("args"), start, dur, this.getProp("jck"), this.getProp("extradir"), this.getProp("jtargs")));
        this.writeResultLine(o, "pass", this.passed);
        this.writeResultLine(o, "fail", this.failed);
        this.writeResultLine(o, "error", this.error);
        String epilog = this.getResource("html/results_epilog.html");
        o.print(MessageFormat.format(epilog, this.passed + this.failed + this.error, new Date()));
        o.close();
    }

    private void writeResultLine(PrintWriter o, String status, int count) {
        if (count != 0) {
            o.print(this.getString("summary.line", this.getStringFor(status, "title", new Object[0]), this.getStringFor(status, "file", new Object[0]), count));
        }
    }

    @Override
    public void error(String msg) {
        this.err.println("ERROR : " + msg);
    }

    private String getProp(String key) {
        String s = System.getProperty("com.sun.jck.lib.jck4jdk." + key);
        return s;
    }

    private String getResource(String name) {
        InputStream is = this.getClass().getResourceAsStream(name);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int len;
            while ((len = is.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
            is.close();
            return os.toString("UTF-8");
        }
        catch (IOException ex) {
            ex.printStackTrace(this.err);
            throw new RuntimeException(ex);
        }
    }

    private String getString(String key, Object ... o) {
        return i18n.getString("report." + key, o);
    }

    private String getStringFor(String key, String what, Object ... o) {
        return i18n.getString("report." + key + "." + what, o);
    }
}

