/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFilter;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.jck.lib.Expr;

public class JCKTestFilter
extends TestFilter {
    public static final String AP_CLASS_SRC = "javasoft.sqe.jck.jsr269.modelapi.processor.GMCmpProcessor";
    public static final String LANG_SIG_TEST_EXEC_CLASS = "javasoft.sqe.jck.tdk.compilersigtest.ClassCheckWrapper";
    private TestEnvironment env;
    private int product;
    private int mode;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(JCKTestFilter.class);

    public JCKTestFilter(TestEnvironment testEnvironment, int n, int n2) {
        this.env = testEnvironment;
        this.product = n;
        this.mode = n2;
    }

    public String getName() {
        return i18n.getString("jckFilter.name");
    }

    public String getDescription() {
        return i18n.getString("jckFilter.description");
    }

    public String getReason() {
        return i18n.getString("jckFilter.reason");
    }

    public boolean accepts(TestDescription testDescription) throws TestFilter.Fault {
        Object object;
        String string;
        if (this.product != 3) {
            string = testDescription.getParameter("keywords");
            Object object2 = object = this.product == 2 ? "runtime" : "compiler";
            if (!this.containsKeyword(string, (String)object)) {
                return false;
            }
        }
        switch (this.mode) {
            case 2: {
                if (this.product == 3) {
                    return true;
                }
                if (this.product == 1) {
                    return this.acceptCompilerPrecompile(testDescription);
                }
                return true;
            }
            case 1: 
            case 3: {
                try {
                    string = testDescription.getParameter("selectIf");
                    if (!(string != null && string.length() != 0 || (string = testDescription.getParameter("executeIf")) != null && string.length() != 0)) {
                        return true;
                    }
                    object = Expr.parse(string);
                    return ((Expr)object).evalBoolean(this.env);
                }
                catch (Expr.Fault fault) {
                    return true;
                }
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof JCKTestFilter)) {
            return false;
        }
        JCKTestFilter jCKTestFilter = (JCKTestFilter)object;
        return this.env == this.env && this.product == jCKTestFilter.product && this.mode == jCKTestFilter.mode;
    }

    private boolean containsKeyword(String string, String string2) {
        int n = string2.length();
        int n2 = string == null ? 0 : string.length();
        for (int i = 0; i <= n2 - n; ++i) {
            if (!string.regionMatches(true, i, string2, 0, n) || i != 0 && !JCKTestFilter.isBoundaryCh(string.charAt(i - 1)) || i + n != string.length() && !JCKTestFilter.isBoundaryCh(string.charAt(i + n))) continue;
            return true;
        }
        return false;
    }

    private static boolean isBoundaryCh(char c) {
        return !Character.isUnicodeIdentifierStart(c) && !Character.isUnicodeIdentifierPart(c);
    }

    private boolean acceptCompilerPrecompile(TestDescription testDescription) {
        return testDescription.getParameter("apSource") != null || testDescription.getParameter("apClassSource") != null || JCKTestFilter.isCompilerAnnoProcModelTest(testDescription) || JCKTestFilter.isCompilerLangSigTest(testDescription);
    }

    public static boolean isCompilerAnnoProcModelTest(TestDescription testDescription) {
        String string = testDescription.getParameter("apClass");
        return string != null && AP_CLASS_SRC.equals(string);
    }

    public static boolean isCompilerLangSigTest(TestDescription testDescription) {
        String string = testDescription.getParameter("executeClass");
        return string != null && LANG_SIG_TEST_EXEC_CLASS.equals(string);
    }
}

