/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib;

import com.sun.javatest.ResourceTable;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestResult;
import com.sun.javatest.util.StringArray;
import com.sun.jck.lib.Expr;
import com.sun.jck.lib.IntermediateScript;
import com.sun.jck.lib.JCKTestFilter;
import com.sun.jck.lib.JPLISLivePhaseTemplateResolver;
import com.sun.jck.lib.JPLISTemplateResolver;
import com.sun.jck.lib.MessageClient;
import com.sun.jck.lib.MessageSwitch;
import com.sun.jck.lib.RemoteManager;
import com.sun.jck.lib.ResolveFault;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;

public class JCKScript
extends IntermediateScript {
    private static ResourceTable srcTable = new ResourceTable();
    public static final int COMPILER = 1;
    public static final int RUNTIME = 2;
    public static final int CERTIFY = 1;
    public static final int PRECOMPILE = 2;
    public static final int DEVELOPER = 3;
    private int mode;
    private String precompileClassDir;
    private boolean compilerKey;
    private boolean coreAPIKey;
    private boolean extensionAPIKey;
    private boolean idlInheritKey;
    private boolean idlTieKey;
    private boolean interactiveKey;
    private boolean javaCompilerKey;
    private boolean negativeKey;
    private boolean optionalAPIKey;
    private boolean positiveKey;
    private boolean rmicKey;
    private boolean rmiIIOPKey;
    private boolean rmiV11Key;
    private boolean runtimeKey;
    private boolean serialKey;
    private boolean vmKey;
    private boolean jplisKey;
    private boolean jdwpKey;
    private boolean jvmtiKey;
    private boolean sharedClassLoaderKey;
    private boolean jaxbKey;
    private boolean jplisLivePhaseKey;
    private boolean jvmtiLivePhaseKey;
    private boolean jniInvocationApiKey;
    private boolean onlyOnceKey;
    private boolean robotKey;
    private boolean useJvmArgSplash = false;
    private String contextArgs;
    private String[] contextArgsArray = nullArgs;
    private static final String REF_COMPILE = "refCompile";
    private static final String REF_COMPILE_ANNOPROC_CLS = "refCompileAnnoProcCls";
    private static final String REF_EXECUTE = "refExecute";
    private static final String REF_RMIC = "refRMIC";
    private static final String TEST_COMPILE = "testCompile";
    private static final String TEST_EXECUTE = "testExecute";
    private static final String TEST_EXECUTE_NATIVE = "testExecuteNative";
    private static final String TEST_EXECUTE_SHARED = "testExecuteShared";
    private static final String TEST_EXECUTE_JAR = "testExecuteJar";
    private static final String TEST_RMIC = "testRMIC";
    private static final String TEST_ANNOPROC_SRC = "testAnnoProcSrc";
    private static final String TEST_ANNOPROC_CLS = "testAnnoProcCls";
    private static final String GROUP = ".group";
    private static final String GEN_ANNOPROC_MODEL = "genAnnoProcModel";
    private static final String GEN_LANG_SIGFILE = "genLangSigFile";
    private static final Status error_badModeFlags = Status.error("At most one of -certify, -developer and -precompile can be specified");
    private static final Status error_bothCompilerRuntimeFlag = Status.error("Only one of -compiler or -runtime can be specified");
    private static final Status error_noCompilerRuntimeFlag = Status.error("One of -compiler or -runtime must be specified");
    private static final Status error_notACompilerTest = Status.error("This is not a compiler test, according to the test's keywords");
    private static final Status error_notARuntimeTest = Status.error("This is not a runtime test, according to the test's keywords");
    private static final Status error_notJavaSource = Status.error("Not a java file");
    private static final Status error_precompileCompilerTest = Status.error("Cannot precompile compiler tests");
    private static final Status error_unrecognizedArg = Status.error("Unrecognized argument for script");
    private static final String[] nullArgs = new String[0];
    private static final PrintWriter DEFAULT_OUTPUT = new PrintWriter(System.err);

    public void initTestDescription(TestDescription testDescription) {
        super.initTestDescription(testDescription);
        Set set = testDescription.getKeywordTable();
        this.compilerKey = set.contains("compiler");
        this.coreAPIKey = set.contains("coreapi");
        this.extensionAPIKey = set.contains("extensionapi");
        this.idlInheritKey = set.contains("idl_inherit");
        this.idlTieKey = set.contains("idl_tie");
        this.interactiveKey = set.contains("interactive");
        this.javaCompilerKey = set.contains("javacompiler");
        this.negativeKey = set.contains("negative");
        this.optionalAPIKey = set.contains("optionalapi");
        this.positiveKey = set.contains("positive");
        this.rmicKey = set.contains("rmic");
        this.rmiIIOPKey = set.contains("rmi_iiop");
        this.rmiV11Key = set.contains("rmi_v11");
        this.runtimeKey = set.contains("runtime");
        this.serialKey = set.contains("serial");
        this.vmKey = set.contains("virtualmachine");
        this.jplisKey = set.contains("jplis");
        this.jplisLivePhaseKey = set.contains("jplislivephase");
        this.jdwpKey = set.contains("jdwp");
        this.jvmtiKey = set.contains("jvmti");
        this.jvmtiLivePhaseKey = set.contains("jvmtilivephase");
        this.sharedClassLoaderKey = set.contains("needsharedclassloader");
        this.jaxbKey = set.contains("jaxb");
        this.onlyOnceKey = set.contains("only_once");
        this.jniInvocationApiKey = set.contains("jniinvocationapi");
        this.robotKey = set.contains("robot");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status run(String[] stringArray, TestDescription testDescription, TestEnvironment testEnvironment) {
        Object object;
        if (stringArray != null && (object = this.init(stringArray)) != null) {
            return object;
        }
        try {
            Object object2;
            this.start(stringArray, testDescription, testEnvironment);
            if (this.isPrecompilation()) {
                object = this.precompileTest();
                if (!object.isPassed()) {
                    Status status = error_compFailUnexp.augment((Status)object);
                    return status;
                }
                if (this.mode != 3) {
                    Status status = pass_compSuccExp;
                    return status;
                }
            }
            if ((object = StringArray.split(testDescription.getParameter("context"))) != null && this.isTestRun()) {
                object2 = new Vector();
                for (int i = 0; i < ((String[])object).length; ++i) {
                    String[] stringArray2;
                    block26: {
                        try {
                            stringArray2 = testEnvironment.lookup(object[i]);
                            if (stringArray2 != null && stringArray2.length != 0) break block26;
                            Status status = Status.error("context undefined for " + object[i]);
                            return status;
                        }
                        catch (TestEnvironment.Fault fault) {
                            Status status = Status.error("bad context defined for " + object[i] + "(" + fault.getMessage() + ")");
                            return status;
                        }
                    }
                    if (stringArray2.length != 1) {
                        Status status = Status.error("bad context defined for " + object[i] + "(Too many words: " + StringArray.join(stringArray2) + ")");
                        return status;
                    }
                    ((Vector)object2).add("-" + object[i]);
                    ((Vector)object2).add(stringArray2[0]);
                    if (((Vector)object2).size() <= 0) continue;
                    this.contextArgsArray = new String[((Vector)object2).size()];
                    ((Vector)object2).copyInto(this.contextArgsArray);
                }
            }
            switch (this.product) {
                case 1: {
                    object2 = this.runCompilerTest();
                    return object2;
                }
                case 2: {
                    object2 = this.runRuntimeTest();
                    return object2;
                }
            }
            try {
                throw new IllegalStateException("invalid product");
            }
            catch (IntermediateScript.SkipTestException skipTestException) {
                object2 = skipTestException.getStatus();
                return object2;
            }
        }
        finally {
            this.finish(stringArray, testDescription, testEnvironment);
        }
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public void setPrecompileClassDir(String string) {
        this.precompileClassDir = string;
    }

    public int getTestTimeout() {
        float f;
        if (this.interactiveKey) {
            return 0;
        }
        String string = this.td.getParameter("timeout");
        try {
            f = string == null ? 600.0f : Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 600;
        }
        return (int)(f * this.getTimeoutFactor());
    }

    public float getTimeoutFactor() {
        float f = 1.0f;
        try {
            String[] stringArray = this.env.lookup("javatestTimeoutFactor");
            if (stringArray != null && stringArray.length > 0) {
                f = stringArray.length > 1 ? Float.parseFloat(stringArray[1]) : Float.parseFloat(stringArray[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    private Status init(String[] stringArray) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-compiler")) {
                this.product = 1;
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-runtime")) {
                this.product = 2;
                bl2 = true;
                continue;
            }
            if (stringArray[i].equals("-certify")) {
                this.setMode(1);
                bl3 = true;
                continue;
            }
            if (stringArray[i].equals("-developer")) {
                this.setMode(3);
                bl5 = true;
                continue;
            }
            if (stringArray[i].equals("-precompile")) {
                this.setMode(2);
                bl4 = true;
                continue;
            }
            if (stringArray[i].equals("-noJTRIfPass")) {
                this.setJTRIfPassed(false);
                continue;
            }
            if (stringArray[i].equals("-precompileClassDir") && i + 1 < stringArray.length) {
                this.precompileClassDir = stringArray[++i];
                continue;
            }
            return error_unrecognizedArg.augment(stringArray[i]);
        }
        if (!bl && !bl2) {
            return error_noCompilerRuntimeFlag;
        }
        if (bl && bl2) {
            return error_bothCompilerRuntimeFlag;
        }
        if (bl3 && bl5 || bl5 && bl4 || bl4 && bl3) {
            return error_badModeFlags;
        }
        if (!(bl3 || bl5 || bl4)) {
            bl3 = true;
            this.setMode(1);
        }
        if (bl4 && bl) {
            return error_precompileCompilerTest;
        }
        return null;
    }

    private String readApClassSourceFromFile(String string) {
        File file = new File(this.td.getDir(), string);
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            string = bufferedReader.readLine();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return string;
    }

    private Status runCompilerTest() {
        String[] stringArray;
        Object object;
        Object object2;
        boolean bl;
        PrintWriter printWriter = this.getTestResult().getTestCommentWriter();
        boolean bl2 = bl = this.compilerKey || this.javaCompilerKey || this.rmicKey;
        if (!bl) {
            return error_notACompilerTest;
        }
        char c = this.getFileSeparator();
        printWriter.println("Testing Java compiler...");
        File[] fileArray = this.td.getSourceFiles();
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>(Arrays.asList(fileArray));
        File[] fileArray2 = JCKScript.getSourceFiles(this.td, "apSource");
        LinkedHashSet<File> linkedHashSet2 = new LinkedHashSet<File>(Arrays.asList(fileArray2));
        linkedHashSet.removeAll(linkedHashSet2);
        fileArray = linkedHashSet.toArray(new File[0]);
        String[] stringArray2 = new String[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            stringArray2[i] = fileArray[i].getPath().replace(File.separatorChar, c);
            if (stringArray2[i].endsWith(".java")) continue;
            return error_notJavaSource.augment(stringArray2[i]);
        }
        String string = this.td.getParameter("apClass");
        String string2 = this.adjustForGroupMode(TEST_COMPILE);
        if (string != null) {
            this.env.put("apClass", string);
            object2 = this.td.getParameter("apArgs");
            try {
                this.env.put("apArgs", this.processApArgs((String)object2));
            }
            catch (TestEnvironment.Fault fault) {
                return Status.error("Error resolving apArgs");
            }
            object = this.td.getParameter("apClassSource");
            if (object == null) {
                string2 = this.adjustForGroupMode(TEST_ANNOPROC_SRC);
            } else {
                string2 = this.adjustForGroupMode(TEST_ANNOPROC_CLS);
                if (object.startsWith("@")) {
                    stringArray = object.substring(1).toString();
                    object = this.readApClassSourceFromFile((String)stringArray);
                }
                this.env.put("testClassSource", object.split(" "));
            }
            printWriter.println("Running with annotation processor...");
        }
        Object object3 = this.serialKey ? this.compileIndividually(string2, stringArray2) : this.compileTogether(string2, stringArray2);
        if (string != null) {
            object2 = this.readTestStatusFromFile(this.td.getName());
            if (this.negativeKey) {
                if (!((Status)object2).isPassed()) {
                    return object2;
                }
            } else {
                object3 = ((Status)object3).isPassed() ? object2 : object3;
                object = this.td.getParameter("executeClass");
                if (object == null || object.length() == 0) {
                    return object3;
                }
            }
        }
        if ((object2 = this.td.getParameter("rmicClasses")) == null) {
            object2 = this.td.getParameter("rmicClass");
        }
        if (object2 != null) {
            if (!((Status)object3).isPassed() && !this.isScriptGenMode()) {
                return error_compFailUnexp.augment((Status)object3);
            }
            printWriter.println("Testing RMI compiler...");
            object = TEST_RMIC;
            if (this.rmiIIOPKey) {
                object = (String)object + ".iiop";
            } else if (this.rmiV11Key) {
                object = (String)object + ".v11";
            }
            object3 = this.rmiCompile((String)object, StringArray.split((String)object2));
        }
        if (this.negativeKey) {
            printWriter.println("Negative test: checking compilation failed...");
            switch (((Status)object3).getType()) {
                case 0: {
                    return fail_compSuccUnexp;
                }
                case 1: {
                    return pass_compFailExp;
                }
            }
            return object3;
        }
        if (((Status)object3).isPassed()) {
            object = null;
            stringArray = null;
            String[] stringArray3 = null;
            String[] stringArray4 = null;
            try {
                object = this.env.lookup("testClassDir");
                stringArray = this.env.lookup("testSuiteRootDir");
                stringArray3 = this.env.lookup("javatestClassDir");
                stringArray4 = this.env.lookup("command.refExecute.securityPolicy");
            }
            catch (TestEnvironment.Fault fault) {
                // empty catch block
            }
            String[] stringArray5 = null;
            try {
                stringArray5 = this.env.lookup("refFileSeparator");
            }
            catch (TestEnvironment.Fault fault) {
                // empty catch block
            }
            char c2 = stringArray5 != null && stringArray5.length == 1 && stringArray5[0].length() >= 1 ? stringArray5[0].charAt(0) : File.separatorChar;
            c = this.getFileSeparator();
            if (stringArray != null && stringArray.length == 1 && stringArray[0].length() >= 1) {
                String string3;
                stringArray[0] = string3 = stringArray[0].replace(c, c2);
                this.env.put("testSuiteRootDir", stringArray);
            }
            if (stringArray3 != null && stringArray3.length == 1 && stringArray3[0].length() >= 1) {
                String string4;
                stringArray3[0] = string4 = stringArray3[0].replace(c, c2);
                this.env.put("javatestClassDir", stringArray3);
            }
            if (stringArray4 != null && stringArray4.length == 1 && stringArray4[0].length() >= 1) {
                String string5;
                stringArray4[0] = string5 = stringArray4[0].replace(c, c2);
                this.env.put("command.refExecute.securityPolicy", stringArray4);
            }
            printWriter.println("Positive test: executing compiled class files...");
            String string6 = this.td.getParameter("executeClass");
            String[] stringArray6 = this.getExecuteArgsArray(this.td);
            if (string6 == null || string6.length() == 0) {
                return error_noExecuteClass;
            }
            string2 = this.adjustForGroupMode(REF_EXECUTE);
            return this.execute(string2, string6, stringArray6);
        }
        return fail_compFailUnexp.augment((Status)object3);
    }

    protected String adjustForGroupMode(String string) {
        try {
            if (this.interactiveKey || this.jdwpKey || this.jplisKey || this.jvmtiKey || this.jplisLivePhaseKey || this.jvmtiLivePhaseKey || this.onlyOnceKey || this.jniInvocationApiKey || this.sharedClassLoaderKey || this.robotKey || this.useJvmArgSplash) {
                return string;
            }
            String[] stringArray = this.env.lookup(string + ".isGroupMode");
            if (stringArray != null && stringArray.length > 0 && "true".equalsIgnoreCase(stringArray[0])) {
                this.env.put("testTimeout", String.valueOf(this.getTestTimeout()));
                string = string + GROUP;
                return string;
            }
        }
        catch (TestEnvironment.Fault fault) {
            this.trOut.println(string + ".isGroupMode is not set: " + fault);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Status runRuntimeTest() {
        var1_1 = this.getTestResult().getTestCommentWriter();
        v0 = var2_2 = this.runtimeKey != false || this.javaCompilerKey != false && this.positiveKey != false || this.vmKey != false || this.coreAPIKey != false || this.optionalAPIKey != false || this.extensionAPIKey != false;
        if (!var2_2) {
            return JCKScript.error_notARuntimeTest;
        }
        var3_3 = null;
        try {
            var3_3 = this.td.getParameter("selectIf");
            if (var3_3 != null && var3_3.length() != 0) {
                var4_4 = Expr.parse(var3_3);
                var5_6 = var4_4.evalBoolean(this.env);
            }
        }
        catch (Expr.Fault var4_5) {
            return Status.error("Configuration setting missing. ('" + var3_3 + "' not in test env.)");
        }
        var5_7 = this.getExecuteArgs(this.td);
        this.env.put("testTimeout", "" + this.getTestTimeout());
        this.env.put("javatestTimeoutFactor", "" + this.getTimeoutFactor());
        if (this.jplisKey && !(var7_8 = this.processJPLIS(this.env, this.td)).isPassed()) {
            return var7_8;
        }
        if (this.jplisLivePhaseKey && !(var7_8 = this.processJPLISLivePhase(this.env, this.td)).isPassed()) {
            return var7_8;
        }
        if (this.jdwpKey && !(var7_8 = this.processJDWP(this.env)).isPassed()) {
            return var7_8;
        }
        var7_8 = this.td.getParameter("jvmArgSplash");
        if (var7_8 != null) {
            this.useJvmArgSplash = true;
            var8_9 = this.processJvmArgSplash(this.env, (String)var7_8);
            if (!var8_9.isPassed()) {
                return var8_9;
            }
        }
        var8_10 = false;
        var9_11 = this.td.getParameter("jvmArgJar");
        if (var9_11 != null) {
            var8_10 = true;
            var10_12 = this.processJvmArgJar(this.env, var9_11);
            if (!var10_12.isPassed()) {
                return var10_12;
            }
        }
        if ((var10_12 = this.td.getParameter("executeClass")) != null) {
            var11_13 = this.td.getParameter("remote");
            if (var11_13 == null) {
                var1_1.println("Executing test class...");
                if (this.jvmtiKey) {
                    if (!this.jvmtiLivePhaseKey) {
                        this.env.put("jvmtiTestName", this.td.getName());
                        try {
                            var12_15 = this.env.lookup("jvmtiAgentOptionsTempl");
                            if (var12_15 == null || var12_15.length <= 0) ** GOTO lbl59
                            this.env.put("jvmtiAgentOptions", this.env.resolve(var12_15[0]));
                        }
                        catch (TestEnvironment.Fault var12_16) {
                            return Status.error("$jvmtiAgentOptionsTempl is not defined");
                        }
                    } else {
                        var12_15 = this.td.getName().substring(0, this.td.getName().length() - 1);
                        this.env.put("jvmtiTestName", (String)var12_15);
                        try {
                            var13_22 /* !! */  = this.env.lookup("nativeAgentLibOptsTempl");
                            if (var13_22 /* !! */  != null && var13_22 /* !! */ .length > 0) {
                                this.env.put("nativeAgentLibOpts", this.env.resolve(var13_22 /* !! */ [0]));
                            }
                        }
                        catch (TestEnvironment.Fault var13_23) {
                            return Status.error("$nativeAgentLibOptsTempl is not defined.");
                        }
                    }
                }
lbl59:
                // 5 sources

                var6_26 = this.getExecuteArgsArray(this.td);
                var12_17 = false;
                if (this.sharedClassLoaderKey) {
                    var13_22 /* !! */  = null;
                    try {
                        var13_22 /* !! */  = this.env.lookup("command.testExecuteShared");
                    }
                    catch (TestEnvironment.Fault var14_28) {
                        // empty catch block
                    }
                    if (var13_22 /* !! */  != null && var13_22 /* !! */ .length > 0 && var13_22 /* !! */ [0].length() >= 1) {
                        var12_17 = true;
                    }
                }
                var13_22 /* !! */  = null;
                var13_22 /* !! */  = var12_17 != false ? "testExecuteShared" : (var8_10 != false ? "testExecuteJar" : this.adjustForGroupMode("testExecute"));
                var4_4 = this.execute((String)var13_22 /* !! */ , (String)var10_12, var6_26);
            } else {
                try {
                    var1_1.println("Starting remote classes...");
                    var12_18 = null;
                    try {
                        var12_18 = this.getTestResult().getSection(0).createOutput("debugOutput");
                    }
                    catch (TestResult.ReloadFault var13_24) {
                        // empty catch block
                    }
                    if (var12_18 == null) {
                        var12_18 = JCKScript.DEFAULT_OUTPUT;
                    }
                    var13_25 = new MessageSwitch();
                    var13_25.setTraceOutput(var12_18);
                    this.env.put("testMsgSwitch", var13_25.getHostAndPort());
                    var6_27 = this.getExecuteArgsArray(this.td);
                    var14_29 = new RemoteManager(var11_13, this.env, this.getTestResult());
                    try {
                        var15_30 = var14_29.getTasksNumber();
                        var12_18.println("RemoteManager's tasks number: " + var15_30);
                        if (this.jdwpKey && var14_29.getTasksNumber() > 0) {
                            var12_18.println("jdwp: starting MessageClient ...");
                            var16_31 = new JdwpMC(var15_30, var13_25.getHostAndPort(), var12_18);
                            try {
                                var16_31.waitForJDWPDebuggers(super.getTestTimeout());
                            }
                            finally {
                                var16_31.close();
                            }
                        }
                        var1_1.println("Waiting for remote clients...");
                        var13_25.waitForRemoteClients(var15_30, super.getTestTimeout());
                        var1_1.println("Executing test class...");
                        var4_4 = this.execute(this.adjustForGroupMode("testExecute"), (String)var10_12, var6_27);
                        var13_25.close();
                        var14_29.waitUntilDone(15);
                        var16_31 = var14_29.getStatus();
                        var4_4 = RemoteManager.mergeStatus((Status)var4_4, (Status)var16_31);
                    }
                    finally {
                        var14_29.dispose();
                    }
                }
                catch (InterruptedException var12_19) {
                    var4_4 = Status.error("timeout waiting for remote classes to exit");
                }
                catch (IOException var12_20) {
                    var4_4 = Status.error("cannot create message switch: " + var12_20);
                }
                catch (RemoteManager.Fault var12_21) {
                    var4_4 = Status.error(var12_21.getMessage());
                }
            }
        } else {
            var11_14 = this.td.getParameter("executeNative");
            if (var11_14 != null) {
                var4_4 = this.executeNative(var11_14, var5_7);
            } else {
                return JCKScript.error_noExecuteClass;
            }
        }
        if (this.negativeKey) {
            switch (var4_4.getType()) {
                case 0: {
                    return JCKScript.fail_execSuccUnexp;
                }
                case 1: {
                    return JCKScript.pass_execFailExp.augment((Status)var4_4);
                }
            }
            return var4_4;
        }
        return var4_4;
    }

    private char getFileSeparator() {
        String[] stringArray = null;
        try {
            stringArray = this.env.lookup("platform.fileSeparator");
        }
        catch (TestEnvironment.Fault fault) {
            // empty catch block
        }
        if (stringArray != null && stringArray.length == 1 && stringArray[0].length() >= 1) {
            return stringArray[0].charAt(0);
        }
        return File.separatorChar;
    }

    protected Status compileOne(String string, String string2) {
        if (string2.endsWith(".idl") && (this.idlTieKey || this.idlInheritKey)) {
            Status status;
            if (!(!this.idlInheritKey || (status = super.compileOne(string + ".inherit", string2)).isPassed() && this.idlTieKey)) {
                return status;
            }
            return super.compileOne(string + ".tie", string2);
        }
        return super.compileOne(string, string2);
    }

    private String getExecuteArgs(TestDescription testDescription) {
        String string = testDescription.getParameter("executeArgs");
        if (this.contextArgs == null) {
            return string;
        }
        if (string == null) {
            return this.contextArgs;
        }
        return this.contextArgs + ' ' + string;
    }

    private String[] getExecuteArgsArray(TestDescription testDescription) {
        String string = testDescription.getParameter("executeArgs");
        String[] stringArray = nullArgs;
        try {
            String[] stringArray2 = stringArray = string == null ? nullArgs : this.env.resolve(string);
            if (this.excludedTestCases != null) {
                stringArray = this.exclude(stringArray, this.excludedTestCases);
            }
        }
        catch (TestEnvironment.Fault fault) {
            this.trOut.println("Trying to evaluate executeArgs: " + string);
            this.trOut.println(fault.toString());
            return nullArgs;
        }
        if (this.contextArgsArray == nullArgs) {
            return stringArray;
        }
        if (stringArray == nullArgs) {
            return this.contextArgsArray;
        }
        String[] stringArray3 = new String[stringArray.length + this.contextArgsArray.length];
        System.arraycopy(this.contextArgsArray, 0, stringArray3, 0, this.contextArgsArray.length);
        System.arraycopy(stringArray, 0, stringArray3, this.contextArgsArray.length, stringArray.length);
        return stringArray3;
    }

    private Status executeNative(String string, String string2) {
        try {
            String[] stringArray;
            String[] stringArray2 = stringArray = string2 == null ? nullArgs : this.env.resolve(string2);
            if (this.excludedTestCases != null) {
                stringArray = this.exclude(stringArray, this.excludedTestCases);
            }
            this.env.put(TEST_EXECUTE_NATIVE, string);
            this.env.put("testExecuteArgs", stringArray);
            return this.invokeCommand(TEST_EXECUTE_NATIVE);
        }
        catch (TestEnvironment.Fault fault) {
            this.trOut.println("Trying to evaluate executeArgs: " + string2);
            this.trOut.println(fault.toString());
            return error_badExecuteArgs;
        }
    }

    public static String[] splitIntoLines(String string) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf("\n", n)) != -1) {
            vector.addElement(string.substring(n, n2));
            n = n2 + 1;
        }
        vector.addElement(string.substring(n));
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    Status processJDWP(TestEnvironment testEnvironment) {
        try {
            String[] stringArray = testEnvironment.lookup("platform.jdwpSupported");
            if (stringArray != null && stringArray.length > 0 && "yes".equals(stringArray[0])) {
                String[] stringArray2;
                String[] stringArray3 = testEnvironment.lookup("jdwpTransportClassDir");
                if (stringArray3 != null && stringArray3.length > 0 && !"".equals(stringArray3[0])) {
                    testEnvironment.put("jdwpTransportClasspathElem", stringArray3);
                }
                if ((stringArray2 = testEnvironment.lookup("jdwpOpts")) != null && stringArray2.length > 0 && !"".equals(stringArray2[0])) {
                    testEnvironment.put("jdwpAgentOptions", stringArray2);
                }
            }
        }
        catch (TestEnvironment.Fault fault) {
            return Status.error(fault.getMessage());
        }
        return Status.passed("");
    }

    Status processJPLIS(TestEnvironment testEnvironment, TestDescription testDescription) {
        String string = testDescription.getParameter("jplisAgent");
        if (string != null) {
            JPLISTemplateResolver jPLISTemplateResolver = new JPLISTemplateResolver();
            String[] stringArray = null;
            String string2 = "";
            try {
                stringArray = jPLISTemplateResolver.createCmdStrs(string, testEnvironment, testDescription);
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = i == 0 ? "" : "" + (i + 1);
                    String string4 = "JPLISAgent" + string3 + "Opts";
                    testEnvironment.put(string4, stringArray[i]);
                }
            }
            catch (ResolveFault resolveFault) {
                return Status.error(resolveFault.getMessage());
            }
        }
        return Status.passed("");
    }

    Status processJPLISLivePhase(TestEnvironment testEnvironment, TestDescription testDescription) {
        block7: {
            try {
                String string;
                String[] stringArray = testEnvironment.lookup("platform.jplisLivePhaseSupported");
                if (stringArray == null || stringArray.length <= 0 || !"yes".equalsIgnoreCase(stringArray[0]) || (string = testDescription.getParameter("jplisAgent")) == null) break block7;
                JPLISLivePhaseTemplateResolver jPLISLivePhaseTemplateResolver = new JPLISLivePhaseTemplateResolver();
                String string2 = "";
                String[] stringArray2 = null;
                try {
                    stringArray2 = jPLISLivePhaseTemplateResolver.createCmdStrs(string, testEnvironment, testDescription);
                    for (int i = 0; i < stringArray2.length; ++i) {
                        String string3 = i == 0 ? "" : "" + (i + 1);
                        String string4 = "JPLISLivePhaseAgent" + string3;
                        String string5 = "JPLISLivePhaseAgent" + string3 + "opts";
                        String[] stringArray3 = stringArray2[i].split("\u0085");
                        if (stringArray3 == null) {
                            throw new ResolveFault("processJPLISLivePhase: param is unexpectedly null");
                        }
                        if (stringArray3.length != 2) {
                            throw new ResolveFault("processJPLISLivePhase: param.length is unexpectedly " + stringArray3.length);
                        }
                        testEnvironment.put(string4, stringArray3[0]);
                        testEnvironment.put(string5, stringArray3[1]);
                    }
                }
                catch (ResolveFault resolveFault) {
                    return Status.error(resolveFault.getMessage());
                }
            }
            catch (TestEnvironment.Fault fault) {
                return Status.error(fault.getMessage());
            }
        }
        return Status.passed("");
    }

    private Status processJvmArgSplash(TestEnvironment testEnvironment, String string) {
        String string2 = this.td.getDir().getAbsolutePath() + this.getFileSeparator() + string;
        testEnvironment.put("jvmArgSplashValue", string2);
        try {
            testEnvironment.put("jvmArgSplashOpt", testEnvironment.lookup("platform.splashScreenOption"));
        }
        catch (TestEnvironment.Fault fault) {
            return Status.error("$platform.splashScreenOption is not defined!");
        }
        return Status.passed("");
    }

    private Status processJvmArgJar(TestEnvironment testEnvironment, String string) {
        String string2 = this.td.getDir().getAbsolutePath() + this.getFileSeparator() + string;
        testEnvironment.put("jvmArgJarValue", string2);
        try {
            testEnvironment.put("jvmArgJarOpt", testEnvironment.lookup("platform.jarExecutionOption"));
        }
        catch (TestEnvironment.Fault fault) {
            return Status.error("$platform.jarExecutionOption is not defined!");
        }
        return Status.passed("");
    }

    public static File[] getSourceFiles(TestDescription testDescription, String string) {
        String string2 = testDescription.getParameter(string);
        if (string2 == null) {
            return new File[0];
        }
        String string3 = testDescription.getFile().getParent();
        String[] stringArray = StringArray.split(string2);
        File[] fileArray = new File[stringArray.length];
        String string4 = System.getProperty("user.dir") + File.separator;
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(string3, stringArray[i].replace('/', File.separatorChar));
            String string5 = file.getPath();
            if (string5.startsWith(string4)) {
                string5 = string5.substring(string4.length());
                fileArray[i] = new File(string5);
                continue;
            }
            fileArray[i] = file;
        }
        return fileArray;
    }

    private Status precompileTest() {
        Object object;
        Object object2;
        Object object3;
        File[] fileArray = this.td.getSourceFiles();
        String string = REF_COMPILE;
        if (this.product == 1) {
            File[] fileArray2 = JCKScript.getSourceFiles(this.td, "apSource");
            if (JCKTestFilter.isCompilerAnnoProcModelTest(this.td)) {
                try {
                    object3 = this.env.resolve(this.td.getParameter("apArgs"));
                    this.env.put("apArgs", (String[])object3);
                }
                catch (TestEnvironment.Fault fault) {
                    throw new RuntimeException(fault);
                }
                string = GEN_ANNOPROC_MODEL;
            } else if (JCKTestFilter.isCompilerLangSigTest(this.td)) {
                this.env.put("executeArgs", this.getExecuteArgsArray(this.td));
                string = GEN_LANG_SIGFILE;
            } else if (this.td.getParameter("apClassSource") == null) {
                this.trOut.println("Precompiling annotation processor source files...");
                fileArray = fileArray2;
            } else {
                string = REF_COMPILE_ANNOPROC_CLS;
                this.trOut.println("Precompiling lang test source files...");
                object3 = new File[fileArray.length + fileArray2.length];
                System.arraycopy(fileArray, 0, object3, 0, fileArray.length);
                System.arraycopy(fileArray2, 0, object3, fileArray.length, fileArray2.length);
                object2 = this.td.getParameter("apClassSource");
                if (((String)object2).startsWith("@")) {
                    this.env.put("apClassSourceOutFile", new File(this.td.getDir(), ((String)object2).substring(1)).toString());
                }
            }
        } else {
            this.trOut.println("Precompiling source files...");
        }
        boolean bl = true;
        object3 = null;
        object2 = null;
        if (this.jaxbKey) {
            bl = true;
        } else if (this.jplisKey || this.jplisLivePhaseKey) {
            bl = true;
            object3 = new ArrayList();
            object2 = new ArrayList<Object>();
            for (File file : fileArray) {
                if (file.getPath().endsWith(".c")) {
                    ((ArrayList)object3).add(file);
                    continue;
                }
                ((ArrayList)object2).add(file);
            }
            fileArray = ((ArrayList)object2).toArray(new File[0]);
        } else {
            for (int i = 0; i < fileArray.length && bl; ++i) {
                String string2 = fileArray[i].getPath();
                bl = string2.endsWith(".java");
            }
        }
        if (fileArray != null && fileArray.length != 0) {
            if (this.serialKey || !bl) {
                object = this.compileIndividually(string, fileArray);
            } else if (this.precompileClassDir != null) {
                object = this.compileIfNecessary(string, fileArray, this.precompileClassDir);
            } else if (this.jplisKey || this.jplisLivePhaseKey) {
                object = this.compileTogether(string, fileArray);
                if (object3 != null && ((ArrayList)object3).size() > 0) {
                    File[] fileArray3 = ((ArrayList)object3).toArray(new File[0]);
                    object = this.compileIndividually(string, fileArray3);
                }
            } else {
                object = this.compileTogether(string, fileArray);
            }
        } else {
            object = Status.passed("SKIPPED: No sources specified in test description.");
        }
        String string3 = this.td.getParameter("rmicClasses");
        if (string3 == null) {
            string3 = this.td.getParameter("rmicClass");
        }
        if (string3 != null) {
            if (!((Status)object).isPassed()) {
                return error_compFailUnexp.augment((Status)object);
            }
            this.trOut.println("Precompiling RMI classes...");
            String string4 = REF_RMIC;
            if (this.rmiIIOPKey) {
                string4 = string4 + ".iiop";
            } else if (this.rmiV11Key) {
                string4 = string4 + ".v11";
            }
            object = this.rmiCompile(string4, StringArray.split(string3));
        }
        return object;
    }

    private boolean isPrecompilation() {
        return this.mode == 3 || this.mode == 2;
    }

    private boolean isTestRun() {
        return this.mode == 3 || this.mode == 1;
    }

    private Status readTestStatusFromFile(String string) {
        if (this.isScriptGenMode()) {
            return Status.passed("YES");
        }
        File file = this.getStatusFile(string);
        if (file == null) {
            return Status.failed("Processor did not write a status");
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            Status status = Status.parse(bufferedReader.readLine());
            bufferedReader.close();
            file.delete();
            return status;
        }
        catch (IOException iOException) {
            return Status.error("Error reading status: " + iOException);
        }
    }

    private File getStatusFile(String string) {
        String string2;
        String string3 = string + ".sta";
        try {
            string2 = this.env.resolve("$testWorkDir")[0];
        }
        catch (TestEnvironment.Fault fault) {
            throw new RuntimeException("Unexpected exception " + fault);
        }
        if (string2 == null || string2.length() == 0) {
            throw new RuntimeException("JCKSCript cannot read the status from the file: testWorkDir is empty");
        }
        File file = new File(string2, string3);
        return file.exists() ? file : null;
    }

    private String processApArgs(String string) throws TestEnvironment.Fault {
        String[] stringArray = nullArgs;
        if (string != null) {
            stringArray = this.env.resolve(string);
        }
        if (this.excludedTestCases != null) {
            stringArray = this.exclude(stringArray, this.excludedTestCases);
        }
        String string2 = "-testName " + this.td.getName();
        if (stringArray.length > 0) {
            string2 = string2 + " " + StringArray.join(stringArray, " ");
        }
        return JCKScript.encode(string2);
    }

    public static String encode(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        block4: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '%': 
                case '+': {
                    stringBuilder.append("%" + Integer.toHexString(0xFF & c));
                    continue block4;
                }
                case ' ': {
                    stringBuilder.append('+');
                    continue block4;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    protected Status rmiCompile(String string, String[] stringArray) {
        String[] stringArray2 = JCKScript.removeDuplicates(stringArray);
        try {
            boolean bl = srcTable.acquire(stringArray2, 600000);
            if (!bl) {
                throw new RuntimeException("Rmic timeout.");
            }
            Status status = super.rmiCompile(string, stringArray);
            return status;
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Rmic class lock interuppted.", interruptedException);
        }
        finally {
            srcTable.release(stringArray2);
        }
    }

    protected Status compileIndividually(String string, String[] stringArray) {
        String[] stringArray2 = JCKScript.removeDuplicates(stringArray);
        try {
            boolean bl = srcTable.acquire(stringArray2, 600000);
            if (!bl) {
                throw new RuntimeException("Source lock timeout.");
            }
            Status status = super.compileIndividually(string, stringArray);
            return status;
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Source class lock interuppted.", interruptedException);
        }
        finally {
            srcTable.release(stringArray2);
        }
    }

    private class JdwpMC
    extends MessageClient {
        private static final String ACK_RECEIVER_NAME = "RemoteManager";
        private static final String DEBUGGER_STARTED_ACK_MSG = "debugger_started";
        private int count;
        private ArrayList exceptions;
        private Object finished;
        private PrintWriter debugTrace;

        public JdwpMC(int n, String string, PrintWriter printWriter) throws IOException {
            super(ACK_RECEIVER_NAME, string);
            this.exceptions = new ArrayList();
            this.finished = new Object();
            this.debugTrace = DEFAULT_OUTPUT;
            this.debugTrace = printWriter;
            this.count = n;
            if (this.count <= 0) {
                throw new Error("internal error: illegal JCKScript.JdwpMC.JdwpMC() tasksNumber parameter");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForJDWPDebuggers(long l) throws InterruptedException, RemoteManager.Fault {
            Object object = this.finished;
            synchronized (object) {
                this.start();
                this.debugTrace.println("jdwp: wait for debugger ...");
                this.finished.wait(l);
            }
            this.debugTrace.println("jdwp: exceptions count is " + this.exceptions.size());
            if (this.exceptions.size() > 0) {
                throw new RemoteManager.Fault("jdwp synchronizer: problems with message client: " + this.exceptions.toString());
            }
        }

        public void handleMessage(String string, String[] stringArray) {
            if (DEBUGGER_STARTED_ACK_MSG.equals(stringArray[0])) {
                this.decrement();
            }
        }

        public void handleException(Exception exception) {
            this.exceptions.add(exception);
            this.decrement();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setFinished() {
            Object object = this.finished;
            synchronized (object) {
                this.debugTrace.println("jdwpMC: finished!");
                this.finished.notifyAll();
            }
        }

        private void decrement() {
            if (--this.count == 0) {
                this.setFinished();
            }
        }
    }
}

