/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib;

import com.sun.javatest.Status;
import com.sun.jck.lib.execonce.Executor;
import com.sun.jck.lib.execonce.ExecutorException;
import com.sun.jck.lib.execonce.Factory;
import com.sun.jck.lib.execonce.Failure;
import com.sun.jck.lib.execonce.Task;
import com.sun.jck.lib.multijvm.group.ExecCmd;
import com.sun.jck.lib.multijvm.group.TaskManager;
import com.sun.jck.lib.multijvm.group.util.ArgMap;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildCompilerAPICmd
extends ExecCmd {
    private Executor<Status> executor = Factory.getStatusExecutor();

    private void normalize(List<String> list) throws URISyntaxException {
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            string = new URI(string).normalize().toString();
            list.set(i, string);
        }
    }

    @Override
    public Status run(String[] stringArray, final PrintWriter printWriter, final PrintWriter printWriter2) {
        try {
            ArgMap argMap = new ArgMap(stringArray, (Enum[])new ExecCmd.Key[]{ExecCmd.Key.TASK, ExecCmd.Key.TEST, ExecCmd.Key.TESTSOURCE});
            List<String> list = argMap.getUnmapped();
            final List<String> list2 = argMap.get(ExecCmd.Key.TASK);
            final List<String> list3 = argMap.get(ExecCmd.Key.TEST);
            final ArrayList<String> arrayList = new ArrayList<String>(argMap.get(ExecCmd.Key.TESTSOURCE));
            final TaskManager taskManager = this.getManager(list);
            this.normalize(arrayList);
            Task<Status> task = new Task<Status>(){

                @Override
                public ArrayList<String> getSources() {
                    return arrayList;
                }

                @Override
                public Status call() throws Exception {
                    try {
                        return BuildCompilerAPICmd.this.run(taskManager, list2, list3, printWriter, printWriter2);
                    }
                    catch (Throwable throwable) {
                        throw new ExecutorException(throwable);
                    }
                }
            };
            try {
                return this.executor.run(task);
            }
            catch (Failure failure) {
                failure.printStackTrace(printWriter2);
                return Status.failed(failure.getMessage());
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throwable.printStackTrace(printWriter2);
            return Status.error("Unexpected: " + throwable);
        }
    }
}

