/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.interview;

import com.sun.interview.FileQuestion;
import com.sun.interview.FilesAndDirectoriesFileFilter;
import com.sun.interview.FinalQuestion;
import com.sun.interview.Question;
import com.sun.jck.interview.JCKChoiceQuestion;
import com.sun.jck.interview.JCKEnvInterview;
import com.sun.jck.interview.JCKExportedQuestion;
import com.sun.jck.interview.JCKStringQuestion;
import com.sun.jck.interview.JCKYesNoQuestion;
import com.sun.jck.interview.RuntimeInterview;
import com.sun.jck.interview.TestPlatformInterview;
import java.io.File;
import java.util.Map;

class RuntimeJDWPInterview
extends JCKEnvInterview {
    private JCKYesNoQuestion qJDWPSupported = new JCKYesNoQuestion(this, "jdwpSupported"){

        protected Question getNext() {
            JCKStringQuestion jCKStringQuestion = RuntimeJDWPInterview.this.qTransportClass;
            if (this.value == "Yes") {
                return jCKStringQuestion;
            }
            if (this.value == "No") {
                return RuntimeJDWPInterview.this.qEnd;
            }
            return null;
        }

        public void export(Map map) {
            if (this.value == "Yes") {
                map.put("platform.jdwpSupported", "yes");
            } else {
                map.put("platform.jdwpSupported", "no");
            }
        }

        public boolean isHidden() {
            boolean bl = RuntimeJDWPInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return "Yes";
        }
    };
    private final String jdwpTransportClassJDK = "javasoft.sqe.jck.lib.jpda.jdwp.SocketTransportService";
    private JCKStringQuestion qTransportClass = new JCKStringQuestion(this, "transportClass"){
        {
            this.setSuggestions(new String[]{"", "javasoft.sqe.jck.lib.jpda.jdwp.SocketTransportService"});
        }

        public void export(Map map) {
            map.put("jdwpTransportClass", this.value);
        }

        protected Question getNext() {
            if (this.value == null || "".equals(this.value)) {
                return null;
            }
            if (!this.value.equals("javasoft.sqe.jck.lib.jpda.jdwp.SocketTransportService") && RuntimeJDWPInterview.this.parent.getRuntimeRemoteAgentInterview().isLoadClasses()) {
                return RuntimeJDWPInterview.this.qTransportClassDir;
            }
            return RuntimeJDWPInterview.this.qConnectorType;
        }

        public boolean isHidden() {
            boolean bl = RuntimeJDWPInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return this.getSuggestions()[1];
        }
    };
    private Question qTransportClassDir = new FileQuestion(this, "transportClassDir"){
        {
            this.setFilter(new FilesAndDirectoriesFileFilter("Directory or file which being specified in the classpath is used for searching transport class"));
        }

        protected void export(Map map) {
            if (!"".equals(this.getStringValue().trim())) {
                char c = File.pathSeparatorChar;
                map.put("jdwpTransportClassDir", c + this.getStringValue());
            }
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if ("".equals(this.getStringValue().trim())) {
                return RuntimeJDWPInterview.this.qConnectorType;
            }
            try {
                if (RuntimeJDWPInterview.this.parent.getRootInterview().isErrorCheckingEnabled() && !this.value.isDirectory() && !this.value.isFile()) {
                    return ((RuntimeJDWPInterview)RuntimeJDWPInterview.this).parent.qNoFileError;
                }
            }
            catch (SecurityException securityException) {
                return null;
            }
            return RuntimeJDWPInterview.this.qConnectorType;
        }
    };
    private JCKChoiceQuestion qConnectorType = new JCKChoiceQuestion(this, "connectorType"){
        public final String[] connectorTypeSgs;
        {
            this.connectorTypeSgs = new String[]{"attaching", "listening"};
            this.setChoices(this.connectorTypeSgs);
        }

        public void export(Map map) {
            map.put("jdwpConnectorType", this.getValue());
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            return RuntimeJDWPInterview.this.qTransportAddress;
        }

        public boolean isHidden() {
            boolean bl = RuntimeJDWPInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return this.connectorTypeSgs[0];
        }
    };
    private final String jdwpTransportPortJDK = "35000";
    private final String jdwpTransportAddressJDK = "localhost:35000";
    private JCKStringQuestion qTransportAddress = new JCKStringQuestion(this, "transportAddress"){
        {
            this.setSuggestions(new String[]{"", "localhost:35000"});
        }

        public void export(Map map) {
            if (!"".equals(this.value.trim())) {
                map.put("jdwpTransportAddress", this.value);
            }
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            return RuntimeJDWPInterview.this.qVMSuspended;
        }

        public boolean isHidden() {
            boolean bl = RuntimeJDWPInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            String string = RuntimeJDWPInterview.this.parent.getRuntimeRemoteAgentInterview().getPassiveHost();
            String string2 = string != null ? string + ":" + "35000" : "localhost:35000";
            return string2;
        }
    };
    private JCKYesNoQuestion qVMSuspended = new JCKYesNoQuestion(this, "VMSuspended"){

        protected Question getNext() {
            TestPlatformInterview testPlatformInterview = RuntimeJDWPInterview.this.parent.getTestPlatformInterview();
            if (this.value == null) {
                return null;
            }
            if (testPlatformInterview.isMultiJVM()) {
                return RuntimeJDWPInterview.this.qJDWPOpts;
            }
            return RuntimeJDWPInterview.this.qEnd;
        }

        public void export(Map map) {
            TestPlatformInterview testPlatformInterview = RuntimeJDWPInterview.this.parent.getTestPlatformInterview();
            if (this.value == "Yes") {
                map.put("VMSuspended", "yes");
            } else {
                map.put("VMSuspended", "no");
            }
            RuntimeJDWPInterview.this.exportJDWPEnv(map);
        }

        public boolean isHidden() {
            boolean bl = RuntimeJDWPInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return "Yes";
        }
    };
    private JCKStringQuestion qJDWPOpts = new JCKStringQuestion(this, "jdwpOpts"){

        public void export(Map map) {
            if (!"".equals(this.value.trim())) {
                map.put("jdwpOpts", this.value);
            }
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            return RuntimeJDWPInterview.this.qEnd;
        }

        public String[] getSuggestions() {
            String string = RuntimeJDWPInterview.this.qTransportAddress.getStringValue();
            String string2 = "-agentlib:jdwp=server=y,transport=dt_socket,address=" + string + ",suspend=y";
            return new String[]{string2};
        }

        public boolean isHidden() {
            boolean bl = RuntimeJDWPInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return this.getSuggestions()[0];
        }
    };
    private Question qEnd = new FinalQuestion(this);
    private RuntimeInterview parent;

    RuntimeJDWPInterview(RuntimeInterview runtimeInterview) {
        super(runtimeInterview, "jdwp");
        this.parent = runtimeInterview;
        this.setFirstQuestion(this.qJDWPSupported);
    }

    public void export(Map map) {
        if (this.parent.isSimple()) {
            JCKExportedQuestion[] jCKExportedQuestionArray = new JCKExportedQuestion[]{this.qJDWPSupported, this.qTransportClass, this.qConnectorType, this.qTransportAddress, this.qVMSuspended, this.qJDWPOpts};
            for (int i = 0; i < jCKExportedQuestionArray.length; ++i) {
                JCKExportedQuestion jCKExportedQuestion = jCKExportedQuestionArray[i];
                if (!jCKExportedQuestion.isHidden()) continue;
                jCKExportedQuestion.export(map);
            }
        }
    }

    protected void exportJDWPEnv(Map map) {
        String string = " -waittime=$testTimeout";
        String string2 = string + " -transport.address=\"$jdwpTransportAddress\" -transport.class=$jdwpTransportClass -connector=$jdwpConnectorType -vm.suspend=$VMSuspended -mode.multiJVM=$platform.multiJVM";
        String string3 = new String(string);
        map.put("jdwpDebuggerOpts", string2);
        map.put("jdwpDebuggeeOpts", string3);
    }
}

