/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.interview;

import com.sun.interview.Interview;
import com.sun.javatest.TestEnvironment;
import com.sun.jck.interview.Utils;
import java.util.HashMap;
import java.util.Map;

public class GroupModeSupport {
    final String prefix;
    TestEnvironment defaultEnv;
    final Map<String, Object> defVals = new HashMap<String, Object>(){
        {
            this.put("groupSize", 100);
            this.put("serverPort", 0);
            this.put("timeout", 60);
            this.put("agentArgs", "");
            this.put("debug", null);
            this.put("keepIfError", null);
            this.put("closeIfFail", null);
        }
    };

    public GroupModeSupport(Interview interview) {
        this.prefix = interview.getTag() + ".groupMode";
        try {
            this.defaultEnv = new TestEnvironment("default", new HashMap[0], new String[0]);
        }
        catch (TestEnvironment.Fault fault) {
            fault.printStackTrace();
        }
    }

    boolean appendArgument(StringBuffer stringBuffer, String string, AppendWhat appendWhat) {
        Object object;
        String string2 = this.getActualEnvValue(string);
        if (!(string2 == null || (object = this.defVals.get(string)) != null && string2.equals(object.toString()))) {
            switch (appendWhat) {
                case KEY_VALUE: {
                    return Utils.appendKeyValue(stringBuffer, string, string2);
                }
                case KEY: {
                    return Utils.appendKeyValue(stringBuffer, string, new String[0]);
                }
                case VALUE: {
                    return Utils.appendValue(stringBuffer, string2);
                }
            }
        }
        return false;
    }

    protected String getActualEnvValue(String string) {
        try {
            String[] stringArray;
            string = this.prefix + "." + string;
            if (this.defaultEnv != null && this.defaultEnv.keys().contains(string) && (stringArray = this.defaultEnv.lookup(string)) != null) {
                return stringArray.length > 0 ? stringArray[0] : "";
            }
        }
        catch (TestEnvironment.Fault fault) {
            // empty catch block
        }
        return null;
    }

    public void appendArguments(StringBuffer stringBuffer) {
        stringBuffer.append("com.sun.jck.lib.multijvm.group.ExecCmd ");
        this.appendArgument(stringBuffer, "serverPort", AppendWhat.KEY_VALUE);
        this.appendArgument(stringBuffer, "timeout", AppendWhat.KEY_VALUE);
        this.appendArgument(stringBuffer, "debug", AppendWhat.KEY);
        stringBuffer.append("-MTASK_ ");
        this.appendArgument(stringBuffer, "groupSize", AppendWhat.KEY_VALUE);
        this.appendArgument(stringBuffer, "keepIfError", AppendWhat.KEY);
        this.appendArgument(stringBuffer, "closeIfFail", AppendWhat.KEY);
        stringBuffer.append("-testTimeout $testTimeout ");
        int n = stringBuffer.length();
        if (this.appendArgument(stringBuffer, "agentArgs", AppendWhat.VALUE)) {
            stringBuffer.insert(n, "-MAGENT_ ");
        }
    }

    public boolean isGroupModeEnabled() {
        String string = this.getActualEnvValue("groupSize");
        if (string != null) {
            return Integer.parseInt(string) != 1;
        }
        return (Integer)this.defVals.get("groupSize") != 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum AppendWhat {
        KEY_VALUE,
        KEY,
        VALUE;

    }
}

