/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.interview;

import com.sun.interview.ErrorQuestion;
import com.sun.interview.FileQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.NullQuestion;
import com.sun.interview.Question;
import com.sun.interview.StringQuestion;
import com.sun.jck.interview.AgentInterview;
import com.sun.jck.interview.DevtoolsJaxbInterview;
import com.sun.jck.interview.DevtoolsJaxwsInterview;
import com.sun.jck.interview.DevtoolsRefExecuteInterview;
import com.sun.jck.interview.DevtoolsTestedJavaInterview;
import com.sun.jck.interview.EnvironmentInterview;
import com.sun.jck.interview.GroupModeSupport;
import com.sun.jck.interview.JCKParameters;
import com.sun.jck.interview.ProductInterview;
import com.sun.jck.interview.ServicesInterview;
import com.sun.jck.interview.TestPlatformInterview;
import com.sun.jck.interview.Utils;
import java.io.File;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DevtoolsInterview
extends ProductInterview {
    private final EnvironmentInterview parent;
    final GroupModeSupport groupModeSupport;
    private ServicesInterview iServices = new ServicesInterview(this);
    final AgentInterview agentModeInterview = new AgentInterview(this);
    final DevtoolsTestedJavaInterview testedJavaInterview = new DevtoolsTestedJavaInterview(this);
    final DevtoolsRefExecuteInterview refExecuteInterview = new DevtoolsRefExecuteInterview(this);
    final DevtoolsJaxbInterview jaxbInterview = new DevtoolsJaxbInterview(this);
    final DevtoolsJaxwsInterview jaxwsInterview = new DevtoolsJaxwsInterview(this);
    private Question qIntro = new NullQuestion(this, "intro"){

        protected Question getNext() {
            TestPlatformInterview testPlatformInterview = DevtoolsInterview.this.parent.getTestPlatformInterview();
            Question question = testPlatformInterview.isMultiJVM() ? (testPlatformInterview.isUseAgent() ? DevtoolsInterview.this.qAgentOtherJVM : DevtoolsInterview.this.qOtherJVM) : DevtoolsInterview.this.qAgentSameJVM;
            return DevtoolsInterview.this.callInterview(DevtoolsInterview.this.iServices, question);
        }

        public boolean isHidden() {
            return true;
        }
    };
    private Question qAgentSameJVM = new NullQuestion(this, "agentSameJVM"){

        protected Question getNext() {
            return DevtoolsInterview.this.callInterview(DevtoolsInterview.this.agentModeInterview, DevtoolsInterview.this.callDevtoolsTestExecute());
        }

        public boolean isHidden() {
            return true;
        }
    };
    private final Question qAgentOtherJVM = new NullQuestion(this, "agentOtherJVM"){

        protected Question getNext() {
            return DevtoolsInterview.this.callInterview(DevtoolsInterview.this.agentModeInterview, DevtoolsInterview.this.callDevtoolsTestExecute());
        }

        public boolean isHidden() {
            return true;
        }
    };
    private Question qOtherJVM = new NullQuestion(this, "otherJVM"){

        protected Question getNext() {
            return DevtoolsInterview.this.callDevtoolsTestExecute();
        }

        public boolean isHidden() {
            return true;
        }
    };
    private Question qIntro2 = new NullQuestion(this, "intro2"){

        protected Question getNext() {
            TestPlatformInterview testPlatformInterview = DevtoolsInterview.this.getTestPlatformInterview();
            if (!testPlatformInterview.isMultiJVM() || testPlatformInterview.isGroupMode()) {
                return DevtoolsInterview.this.callInterview(DevtoolsInterview.this.jaxbInterview, DevtoolsInterview.this.callInterview(DevtoolsInterview.this.jaxwsInterview, DevtoolsInterview.this.q_final));
            }
            return DevtoolsInterview.this.qScriptEnvVars;
        }
    };
    final Question qScriptEnvVars = new StringQuestion(this, "scriptEnvVars"){

        public Question getNext() {
            if (this.value == null) {
                return null;
            }
            return DevtoolsInterview.this.callInterview(DevtoolsInterview.this.jaxbInterview, DevtoolsInterview.this.callInterview(DevtoolsInterview.this.jaxwsInterview, DevtoolsInterview.this.q_final));
        }

        protected void export(Map map) {
            map.put("xjc_env_vars", this.getValue());
        }

        public String[] getSuggestions() {
            String string;
            String[] stringArray = super.getSuggestions();
            if (DevtoolsInterview.this.parent.isSimple() && stringArray == null && (string = this.getDefValue()) != null) {
                return new String[]{string};
            }
            return null;
        }

        private String getDefValue() {
            File file = DevtoolsInterview.this.getJavaHome();
            if (file != null) {
                return "JAVA_HOME=" + file.getAbsolutePath();
            }
            return null;
        }

        public boolean isHidden() {
            TestPlatformInterview testPlatformInterview = DevtoolsInterview.this.getTestPlatformInterview();
            return !testPlatformInterview.isMultiJVM() || testPlatformInterview.isGroupMode();
        }
    };
    static final String REGEXP = "\\S+\\s*=.*?((?=\\s*$)|(?=\\s+\\S+\\s*=))";
    final ErrorQuestion qNoFileError = new ErrorQuestion(this, "noFileError");
    final Question q_final = new FinalQuestion(this);

    public DevtoolsInterview(EnvironmentInterview environmentInterview) {
        super(environmentInterview, "devtools");
        this.parent = environmentInterview;
        this.setFirstQuestion(this.qIntro);
        this.groupModeSupport = new GroupModeSupport(this);
    }

    boolean isSimple() {
        return this.parent.isSimple();
    }

    public void export(Map map) {
        TestPlatformInterview testPlatformInterview = this.parent.getTestPlatformInterview();
        if (testPlatformInterview.isUseAgent()) {
            if ("active".equals(this.agentModeInterview.getAgentType())) {
                map.put("xjc_agent_command", "com.sun.javatest.agent.ActiveAgentCommand");
            } else {
                map.put("xjc_agent_command", "com.sun.javatest.agent.PassiveAgentCommand");
                map.put("xjc_agent_passive_host", "-host " + this.agentModeInterview.getPassiveHost());
                if (!this.agentModeInterview.passivePortDefault()) {
                    map.put("xjc_agent_passive_port", "-port " + this.agentModeInterview.getPassivePort());
                }
            }
            map.put("xjc_use_map_file", "-mapArgs");
            map.put("xjc_map_file_separator", String.valueOf(testPlatformInterview.getFileSep()));
            map.put("xjc_map_path_separator", String.valueOf(testPlatformInterview.getPathSep()));
        }
        if (this.isSimple()) {
            this.agentModeInterview.export(map);
            this.refExecuteInterview.export(map);
            this.testedJavaInterview.export(map);
            this.jaxbInterview.export(map);
            this.jaxwsInterview.export(map);
        }
    }

    TestPlatformInterview getTestPlatformInterview() {
        return this.parent.getTestPlatformInterview();
    }

    JCKParameters getRootInterview() {
        return this.parent.getRootInterview();
    }

    DevtoolsRefExecuteInterview getDevtoolsRefExecuteInterview() {
        return this.refExecuteInterview;
    }

    public File getJavaHome() {
        FileQuestion fileQuestion;
        FileQuestion fileQuestion2 = fileQuestion = this.testedJavaInterview.qCmdAsFile.isEnabled() ? this.testedJavaInterview.qCmdAsFile : this.refExecuteInterview.q_javaPathAsFile;
        if (fileQuestion.isValueValid()) {
            File file = fileQuestion.getValue();
            try {
                return file.getParentFile().getParentFile();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String parseEnvVars(String string) {
        if (string == null || string.trim().indexOf(" ") <= 0) {
            return string;
        }
        Pattern pattern = Pattern.compile(REGEXP);
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            String string2 = Utils.adjustForSpace(matcher.group());
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private Question callDevtoolsTestExecute() {
        TestPlatformInterview testPlatformInterview = this.getTestPlatformInterview();
        ServicesInterview servicesInterview = this.getServicesInterview();
        if (testPlatformInterview.isGroupMode() || servicesInterview.areServicesOn()) {
            return this.callInterview(this.testedJavaInterview, this.callInterview(this.refExecuteInterview, this.qIntro2));
        }
        return this.callInterview(this.refExecuteInterview, this.qIntro2);
    }

    AgentInterview getAgentInterview() {
        return this.agentModeInterview;
    }

    ServicesInterview getServicesInterview() {
        return this.iServices;
    }
}

