/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.interview;

import com.sun.interview.ChoiceQuestion;
import com.sun.interview.FileQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.NullQuestion;
import com.sun.interview.Question;
import com.sun.interview.StringQuestion;
import com.sun.interview.YesNoQuestion;
import com.sun.jck.interview.CompilerInterview;
import com.sun.jck.interview.EnvironmentInterview;
import com.sun.jck.interview.JCKEnvInterview;
import com.sun.jck.interview.JCKParameters;
import com.sun.jck.interview.TestPlatformInterview;
import com.sun.jck.interview.Utils;
import java.io.File;
import java.util.Map;

class CompilerTestRmicInterview
extends JCKEnvInterview {
    private Question qIntro = new NullQuestion(this, "intro"){

        protected Question getNext() {
            TestPlatformInterview testPlatformInterview = CompilerTestRmicInterview.this.parent.getTestPlatformInterview();
            if (testPlatformInterview.isMultiJVM()) {
                if (testPlatformInterview.isLocal()) {
                    return CompilerTestRmicInterview.this.qCmdAsFile;
                }
                return CompilerTestRmicInterview.this.qCmdAsString;
            }
            return CompilerTestRmicInterview.this.qRunMethod;
        }

        public void export(Map map) {
            String string;
            String string2;
            String string3;
            String string4;
            TestPlatformInterview testPlatformInterview = CompilerTestRmicInterview.this.parent.getTestPlatformInterview();
            if (testPlatformInterview.isMultiJVM()) {
                if (testPlatformInterview.isUseAgent()) {
                    string4 = CompilerTestRmicInterview.this.getAgentOtherJVMCommand(null);
                    string3 = CompilerTestRmicInterview.this.getAgentOtherJVMCommand(CompilerTestRmicInterview.this.qIiopOption.getValue());
                    string2 = CompilerTestRmicInterview.this.getAgentOtherJVMCommand(CompilerTestRmicInterview.this.qV11Option.getValue());
                    string = CompilerTestRmicInterview.this.getAgentOtherJVMCommand(CompilerTestRmicInterview.this.qV12Option.getValue());
                } else {
                    string4 = CompilerTestRmicInterview.this.getOtherJVMCommand(null);
                    string3 = CompilerTestRmicInterview.this.getOtherJVMCommand(CompilerTestRmicInterview.this.qIiopOption.getValue());
                    string2 = CompilerTestRmicInterview.this.getOtherJVMCommand(CompilerTestRmicInterview.this.qV11Option.getValue());
                    string = CompilerTestRmicInterview.this.getOtherJVMCommand(CompilerTestRmicInterview.this.qV12Option.getValue());
                }
            } else {
                string4 = CompilerTestRmicInterview.this.getAgentSameJVMCommand(null);
                string3 = CompilerTestRmicInterview.this.getAgentSameJVMCommand(CompilerTestRmicInterview.this.qIiopOption.getValue());
                string2 = CompilerTestRmicInterview.this.getAgentSameJVMCommand(CompilerTestRmicInterview.this.qV11Option.getValue());
                string = CompilerTestRmicInterview.this.getAgentSameJVMCommand(CompilerTestRmicInterview.this.qV12Option.getValue());
            }
            map.put("command.testRMIC", string4);
            map.put("command.testRMIC.iiop", string3);
            map.put("command.testRMIC.v11", string2);
            map.put("command.testRMIC.v12", string);
            String string5 = CompilerTestRmicInterview.this.getCmd();
            if (string5 != null) {
                map.put("pathTo.rmic", CompilerTestRmicInterview.this.getCmd());
            }
        }
    };
    private YesNoQuestion qRunMethod = new YesNoQuestion(this, "runMethod"){

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == "Yes") {
                return CompilerTestRmicInterview.this.qCompilerClass;
            }
            return CompilerTestRmicInterview.this.qCompilerCmd;
        }
    };
    private StringQuestion qCompilerClass = new StringQuestion(this, "compilerClass"){
        private boolean valid;

        public void setValue(String string) {
            this.valid = Utils.isValidClassName(string);
            super.setValue(string);
        }

        protected Question getNext() {
            if (this.valid) {
                return CompilerTestRmicInterview.this.qCompilerName;
            }
            return null;
        }
    };
    private StringQuestion qCompilerName = new StringQuestion(this, "compilerName"){

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return CompilerTestRmicInterview.this.qClassPathOpt;
        }
    };
    private StringQuestion qCompilerCmd = new StringQuestion(this, "compilerCmd"){

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return CompilerTestRmicInterview.this.qClassPathOpt;
        }
    };
    private FileQuestion qCmdAsFile = new FileQuestion(this, "cmdAsFile"){

        public File getValue() {
            File file;
            if (CompilerTestRmicInterview.this.parent != null && CompilerTestRmicInterview.this.parent.getTestCompileInterview() != null && (file = CompilerTestRmicInterview.this.parent.getTestCompileInterview().getCompilerPathName()) != null && file.getParentFile() != null) {
                this.setBaseDirectory(file.getParentFile());
            }
            return super.getValue();
        }

        public void setValue(File file) {
            if (file == null || file.getPath().length() == 0) {
                super.setValue(file);
            } else {
                File file2;
                file = file2 = this.getAdjustedValue(file);
            }
            super.setValue(file);
        }

        private File getAdjustedValue(File file) {
            if (file == null) {
                return null;
            }
            if (!file.isAbsolute()) {
                return new File(this.getBaseDirectory(), file.getPath());
            }
            return file;
        }

        protected Question getNext() {
            if (this.value == null || this.value.getPath().length() == 0) {
                return null;
            }
            if (CompilerTestRmicInterview.this.getRootInterview().isErrorCheckingEnabled() && !this.value.isFile()) {
                return ((CompilerTestRmicInterview)CompilerTestRmicInterview.this).parent.qNoFileError;
            }
            return CompilerTestRmicInterview.this.qClassPath;
        }

        public File[] getSuggestions() {
            File file;
            File[] fileArray = super.getSuggestions();
            boolean bl = CompilerTestRmicInterview.this.parent.isSimple();
            if (bl && fileArray == null && (file = this.getDefValue()) != null) {
                return new File[]{file};
            }
            return null;
        }

        private File getDefValue() {
            String string;
            File file;
            File file2 = CompilerTestRmicInterview.this.parent.getTestCompileInterview().getJavaHome();
            String string2 = CompilerTestRmicInterview.this.parent.getTestPlatformInterview().getOS();
            if (file2 != null && string2 != null && this.isValueValid(file = new File(new File(file2, "bin"), string = EnvironmentInterview.isWindows(string2) ? "rmic.exe" : "rmic"))) {
                return file;
            }
            return null;
        }

        private boolean isValueValid(File file) {
            try {
                return file != null && file.getPath().length() != 0 && file.isFile();
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
    };
    private StringQuestion qCmdAsString = new StringQuestion(this, "cmdAsString"){

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return CompilerTestRmicInterview.this.qClassPath;
        }
    };
    private final String CP_ENV = "environment variable";
    private final String CP_OPT = "command line option";
    private ChoiceQuestion qClassPath = new ChoiceQuestion(this, "classpath"){
        {
            this.setChoices(new String[]{null, "environment variable", "command line option"});
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == "environment variable") {
                return CompilerTestRmicInterview.this.qClassPathEnv;
            }
            return CompilerTestRmicInterview.this.qClassPathOpt;
        }

        public boolean isHidden() {
            boolean bl = CompilerTestRmicInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return "command line option";
        }
    };
    private StringQuestion qClassPathEnv = new StringQuestion(this, "classpathEnv"){
        {
            this.setSuggestions(new String[]{"", "CLASSPATH"});
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return CompilerTestRmicInterview.this.qOutDirOpt;
        }
    };
    private StringQuestion qClassPathOpt = new StringQuestion(this, "classpathOpt"){
        {
            this.setSuggestions(new String[]{"", "-classpath #", "/cp:#"});
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0 || this.value.indexOf("#") == -1) {
                return null;
            }
            return CompilerTestRmicInterview.this.qOutDirOpt;
        }

        public boolean isHidden() {
            boolean bl = CompilerTestRmicInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return this.getSuggestions()[1];
        }
    };
    private StringQuestion qOutDirOpt = new StringQuestion(this, "outDirOpt"){
        {
            this.setSuggestions(new String[]{"", "-d #", "/d:#"});
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0 || this.value.indexOf("#") == -1) {
                return null;
            }
            return CompilerTestRmicInterview.this.qIiopOption;
        }

        public boolean isHidden() {
            boolean bl = CompilerTestRmicInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return this.getSuggestions()[1];
        }
    };
    private StringQuestion qIiopOption = new StringQuestion(this, "iiopOption"){
        {
            this.setSuggestions(new String[]{"", "-iiop"});
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return CompilerTestRmicInterview.this.qV11Option;
        }

        public boolean isHidden() {
            boolean bl = CompilerTestRmicInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return this.getSuggestions()[1];
        }
    };
    private StringQuestion qV11Option = new StringQuestion(this, "v11Option"){
        {
            this.setSuggestions(new String[]{"", "-v1.1"});
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return CompilerTestRmicInterview.this.qV12Option;
        }

        public boolean isHidden() {
            boolean bl = CompilerTestRmicInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return this.getSuggestions()[1];
        }
    };
    private StringQuestion qV12Option = new StringQuestion(this, "v12Option"){
        {
            this.setSuggestions(new String[]{"", "-v1.2"});
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return CompilerTestRmicInterview.this.qOtherOpts;
        }

        public boolean isHidden() {
            boolean bl = CompilerTestRmicInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return this.getSuggestions()[1];
        }
    };
    StringQuestion qOtherOpts = new StringQuestion(this, "otherOpts"){
        {
            this.setDefaultValue("");
        }

        protected Question getNext() {
            TestPlatformInterview testPlatformInterview = CompilerTestRmicInterview.this.parent.getTestPlatformInterview();
            if (testPlatformInterview.isMultiJVM()) {
                return CompilerTestRmicInterview.this.qOtherEnvVars;
            }
            return CompilerTestRmicInterview.this.qEnd;
        }
    };
    StringQuestion qOtherEnvVars = new StringQuestion(this, "otherEnvVars"){
        {
            this.setDefaultValue("");
        }

        protected Question getNext() {
            return CompilerTestRmicInterview.this.qEnd;
        }
    };
    private Question qEnd = new FinalQuestion(this);
    private CompilerInterview parent;

    CompilerTestRmicInterview(CompilerInterview compilerInterview) {
        super(compilerInterview, "testRmic");
        this.parent = compilerInterview;
        this.setFirstQuestion(this.qIntro);
    }

    JCKParameters getRootInterview() {
        return this.parent.getRootInterview();
    }

    private String getCmd() {
        TestPlatformInterview testPlatformInterview = this.parent.getTestPlatformInterview();
        if (testPlatformInterview.isLocal()) {
            return this.qCmdAsFile.getValue().getPath();
        }
        return this.qCmdAsString.getValue();
    }

    private String getAgentSameJVMCommand(String string) {
        TestPlatformInterview testPlatformInterview = this.parent.getTestPlatformInterview();
        char c = testPlatformInterview.getFileSep();
        char c2 = testPlatformInterview.getPathSep();
        StringBuffer stringBuffer = new StringBuffer();
        this.parent.appendAgentCommandPrefix(stringBuffer);
        if (this.qRunMethod.getValue() == "Yes") {
            stringBuffer.append("com.sun.javatest.lib.JavaCompileCommand");
            stringBuffer.append(' ');
            stringBuffer.append("-compiler");
            stringBuffer.append(' ');
            stringBuffer.append(this.qCompilerName.getValue());
            stringBuffer.append(':');
            stringBuffer.append(this.qCompilerClass.getValue());
            stringBuffer.append(' ');
            stringBuffer.append('-');
            stringBuffer.append(' ');
        } else {
            stringBuffer.append(this.qCompilerCmd.getValue());
            stringBuffer.append(' ');
        }
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(' ');
        }
        stringBuffer.append(this.qOtherOpts.getValue());
        stringBuffer.append(' ');
        String string2 = Utils.adjust(this.getRootInterview().getWorkDirectory().getPath()) + c + "classes";
        String string3 = string2.replace(File.separatorChar, c);
        String string4 = "${testClassDir:MAP FS=" + c + "}";
        String string5 = "${testSuiteRootDir:MAP FS=" + c + "}";
        String string6 = string5 + c + "lib" + c + "javatest.jar";
        String string7 = string3 + c2 + string5 + c + "classes" + c2 + string6;
        stringBuffer.append(Utils.evalTemplate(this.qClassPathOpt.getValue(), string7));
        stringBuffer.append(' ');
        stringBuffer.append(Utils.evalTemplate(this.qOutDirOpt.getValue(), string3));
        stringBuffer.append(' ');
        stringBuffer.append("${testRmicClasses:MAP FS=");
        stringBuffer.append(c);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private String getAgentOtherJVMCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        this.parent.appendAgentCommandPrefix(stringBuffer);
        this.appendOtherJVMCommand(stringBuffer, string);
        return stringBuffer.toString();
    }

    private String getOtherJVMCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendOtherJVMCommand(stringBuffer, string);
        return stringBuffer.toString();
    }

    private void appendOtherJVMCommand(StringBuffer stringBuffer, String string) {
        TestPlatformInterview testPlatformInterview = this.parent.getTestPlatformInterview();
        char c = testPlatformInterview.getFileSep();
        char c2 = testPlatformInterview.getPathSep();
        String string2 = Utils.adjust(this.getRootInterview().getWorkDirectory().getPath()) + c + "classes";
        String string3 = string2.replace(File.separatorChar, c);
        String string4 = "${testClassDir:MAP FS=" + c + "}";
        String string5 = "${testSuiteRootDir:MAP FS=" + c + "}";
        String string6 = string5 + c + "lib" + c + "javatest.jar";
        String string7 = string3 + c2 + string5 + c + "classes" + c2 + string6;
        stringBuffer.append("com.sun.javatest.lib.ProcessCommand");
        stringBuffer.append(' ');
        if (this.qClassPath.getValue() == "environment variable") {
            stringBuffer.append(this.qClassPathEnv.getValue());
            stringBuffer.append('=');
            stringBuffer.append(string7);
            stringBuffer.append(' ');
        }
        stringBuffer.append(this.qOtherEnvVars.getValue());
        stringBuffer.append(' ');
        stringBuffer.append(Utils.adjust(this.getCmd()));
        stringBuffer.append(' ');
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(' ');
        }
        stringBuffer.append(this.qOtherOpts.getValue());
        stringBuffer.append(' ');
        if (this.qClassPath.getValue() == "command line option") {
            stringBuffer.append(Utils.evalTemplate(this.qClassPathOpt.getValue(), string7));
            stringBuffer.append(' ');
        }
        stringBuffer.append(Utils.evalTemplate(this.qOutDirOpt.getValue(), string3));
        stringBuffer.append(' ');
        stringBuffer.append("$testRmicClasses");
    }
}

