/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.model;

import com.sun.tdk.signaturetest.core.ClassHierarchy;
import com.sun.tdk.signaturetest.model.AnnotationItem;
import com.sun.tdk.signaturetest.model.ConstructorDescr;
import com.sun.tdk.signaturetest.model.FieldDescr;
import com.sun.tdk.signaturetest.model.InnerDescr;
import com.sun.tdk.signaturetest.model.MemberCollection;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MemberType;
import com.sun.tdk.signaturetest.model.MethodDescr;
import com.sun.tdk.signaturetest.model.Modifier;
import com.sun.tdk.signaturetest.model.SuperClass;
import com.sun.tdk.signaturetest.model.SuperInterface;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ClassDescription
extends MemberDescription {
    private static final String PACKAGE_INFO_CLASS = ".package-info";
    public static final String OUTER_PREFIX = "outer";
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(ClassDescription.class);
    protected TypeParameterList typeparamList = null;
    protected transient MemberCollection members;
    private boolean isTiger = false;
    private MethodDescr[] declaredMethods = MethodDescr.EMPTY_ARRAY;
    private FieldDescr[] declaredFields = FieldDescr.EMPTY_ARRAY;
    private ConstructorDescr[] declaredConstructors = ConstructorDescr.EMPTY_ARRAY;
    private SuperInterface[] interfaces = SuperInterface.EMPTY_ARRAY;
    private InnerDescr[] nestedClasses = InnerDescr.EMPTY_ARRAY;
    private Set internalFields = null;
    private Set internalClasses = null;
    private Set xFields = null;
    private Set xClasses = null;
    private SuperClass superClass = null;
    private ClassHierarchy hierarchy;
    static final long serialVersionUID = -3431812619261695131L;

    @Override
    public boolean equals(Object o) {
        return o instanceof ClassDescription && this.name == ((ClassDescription)o).name;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    @Override
    public String getQualifiedName() {
        return this.name;
    }

    @Override
    public String getName() {
        return ClassDescription.getClassShortName(this.name);
    }

    @Override
    public boolean isCompatible(MemberDescription m) {
        if (!this.equals(m)) {
            throw new IllegalArgumentException("Only equal members can be checked for compatibility!");
        }
        return this.memberType.isCompatible(this.getModifiers(), m.getModifiers()) && SwissKnife.equals(this.typeParameters, m.typeParameters);
    }

    public boolean containsMember(MemberDescription newMember) {
        return this.members.contains(newMember);
    }

    public MemberDescription findMember(MemberDescription requiredMember) {
        return this.members.find(requiredMember);
    }

    public int getMembersCount(MemberType memberType, String fqname) {
        return this.members.getMembersCount(memberType, fqname);
    }

    public boolean isAnonymousClass() {
        if (this.name.charAt(this.name.length() - 1) == '$') {
            return false;
        }
        return !this.declaringClass.equals("") && ClassDescription.isAsciiDigit(this.name.charAt(this.name.lastIndexOf(36) + 1));
    }

    private static boolean isAsciiDigit(char c) {
        return '0' <= c && c <= '9';
    }

    public ArrayList getTypeBounds() {
        int endPos;
        ArrayList<String> bounds = new ArrayList<String>();
        int startPos = 1;
        do {
            if ((endPos = this.smartIndexOf(this.typeParameters, ',', startPos)) == -1) {
                endPos = this.typeParameters.length() - 1;
            }
            String type = this.typeParameters.substring(startPos, endPos);
            String ext = "extends";
            int extPos = type.indexOf("extends");
            int ampPos = type.indexOf(38);
            if (ampPos == -1) {
                ampPos = type.length();
            }
            String bound = type.substring(extPos + "extends".length(), ampPos);
            bounds.add(bound.trim());
        } while ((startPos = endPos + 1) != this.typeParameters.length());
        return bounds;
    }

    private int smartIndexOf(String str, char c, int startPos) {
        int res = -1;
        if (str.indexOf(60, startPos) == -1) {
            return str.indexOf(c, startPos);
        }
        int bl = 0;
        for (int pos = startPos; pos < str.length(); ++pos) {
            char tst = str.charAt(pos);
            if (tst == '<') {
                ++bl;
                continue;
            }
            if (tst == '>') {
                --bl;
                continue;
            }
            if (tst != c || bl != 0) continue;
            return pos;
        }
        return res;
    }

    public void setMembers(MemberCollection members) {
        this.members = members;
    }

    public static String getPackageInfo(String packageName) {
        return packageName + PACKAGE_INFO_CLASS;
    }

    public TypeParameterList getTypeparamList() {
        return this.typeparamList;
    }

    public void setTypeparamList(TypeParameterList typeparamList) {
        this.typeparamList = typeparamList;
    }

    public boolean isPackageInfo() {
        return this.name.endsWith(PACKAGE_INFO_CLASS);
    }

    public String getPackageName() {
        return ClassDescription.getPackageName(this.name);
    }

    public static String getPackageName(String name) {
        int pos = name.lastIndexOf(".");
        if (pos > 0) {
            return name.substring(0, pos);
        }
        return "";
    }

    public boolean isTiger() {
        return this.isTiger;
    }

    public void setTiger(boolean tiger) {
        this.isTiger = tiger;
    }

    public ClassDescription() {
        super(MemberType.CLASS, '$');
        this.members = new MemberCollection();
    }

    public void add(MemberDescription x) {
        this.members.addMember(x);
    }

    public Iterator getMembersIterator() {
        return this.members.iterator();
    }

    public void removeThrows() {
        Iterator e = this.members.iterator();
        while (e.hasNext()) {
            MemberDescription mr = (MemberDescription)e.next();
            if (!mr.isMethod() && !mr.isConstructor()) continue;
            mr.setThrowables("");
        }
    }

    public ConstructorDescr[] getDeclaredConstructors() {
        return this.declaredConstructors;
    }

    public FieldDescr[] getDeclaredFields() {
        return this.declaredFields;
    }

    public MethodDescr[] getDeclaredMethods() {
        return this.declaredMethods;
    }

    public SuperInterface[] getInterfaces() {
        return this.interfaces;
    }

    public String getOuterClass() {
        return this.declaringClass;
    }

    public InnerDescr[] getDeclaredClasses() {
        return this.nestedClasses;
    }

    public void createInterfaces(int size) {
        this.interfaces = SuperInterface.EMPTY_ARRAY;
        if (size > 0) {
            this.interfaces = new SuperInterface[size];
        }
    }

    public void setInterface(int i, SuperInterface interf) {
        this.interfaces[i] = interf;
    }

    public void setInterfaces(SuperInterface[] interfs) {
        this.interfaces = interfs;
    }

    public void createFields(int size) {
        this.declaredFields = FieldDescr.EMPTY_ARRAY;
        if (size > 0) {
            this.declaredFields = new FieldDescr[size];
        }
    }

    public void createMethods(int size) {
        this.declaredMethods = MethodDescr.EMPTY_ARRAY;
        if (size > 0) {
            this.declaredMethods = new MethodDescr[size];
        }
    }

    public void createConstructors(int size) {
        this.declaredConstructors = ConstructorDescr.EMPTY_ARRAY;
        if (size > 0) {
            this.declaredConstructors = new ConstructorDescr[size];
        }
    }

    public void createNested(int size) {
        this.nestedClasses = InnerDescr.EMPTY_ARRAY;
        if (size > 0) {
            this.nestedClasses = new InnerDescr[size];
        }
    }

    public void setConstructor(int i, ConstructorDescr c) {
        this.declaredConstructors[i] = c;
    }

    public void setConstructors(ConstructorDescr[] ctors) {
        this.declaredConstructors = ctors;
    }

    public void setMethods(MethodDescr[] methods) {
        this.declaredMethods = methods;
    }

    public void setMethod(int i, MethodDescr m) {
        this.declaredMethods[i] = m;
    }

    public void setField(int i, FieldDescr f) {
        this.declaredFields[i] = f;
    }

    public void setFields(FieldDescr[] fields) {
        this.declaredFields = fields;
    }

    public FieldDescr getField(int i) {
        return this.declaredFields[i];
    }

    public MethodDescr getMethod(int i) {
        return this.declaredMethods[i];
    }

    public ConstructorDescr getConstructor(int i) {
        return this.declaredConstructors[i];
    }

    public void setNestedClasses(InnerDescr[] ncls) {
        this.nestedClasses = ncls;
    }

    public void setNested(int i, InnerDescr m) {
        this.nestedClasses[i] = m;
    }

    public void setSuperClass(SuperClass m) {
        this.superClass = m;
    }

    public SuperClass getSuperClass() {
        return this.superClass;
    }

    @Override
    public boolean isClass() {
        return true;
    }

    private boolean isInternalMember(MemberDescription m) {
        return m.hasModifier(Modifier.PRIVATE) || !m.hasModifier(Modifier.PUBLIC) && !m.hasModifier(Modifier.PROTECTED);
    }

    public void setInternalFields(Set fields) {
        this.internalFields = fields;
    }

    public void setInternalClasses(Set classes) {
        this.internalClasses = classes;
    }

    public Set getInternalFields() {
        HashSet<String> result = this.internalFields;
        if (result == null) {
            for (int i = 0; i < this.declaredFields.length; ++i) {
                FieldDescr m = this.declaredFields[i];
                if (!this.isInternalMember(m)) continue;
                if (result == null) {
                    result = new HashSet<String>();
                }
                result.add(m.getName());
            }
            if (result == null) {
                result = Collections.EMPTY_SET;
            }
        }
        return result;
    }

    public Set getXFields() {
        if (this.xFields == null) {
            return Collections.EMPTY_SET;
        }
        return this.xFields;
    }

    public void setXFields(Set fileds) {
        this.xFields = fileds;
    }

    public void addXFields(String name) {
        if (this.xFields == null) {
            this.xFields = new HashSet();
        }
        this.xFields.add(name);
    }

    public Set getXClasses() {
        if (this.xClasses == null) {
            return Collections.EMPTY_SET;
        }
        return this.xClasses;
    }

    public void setXClasses(Set classes) {
        this.xClasses = classes;
    }

    public void addXClasses(String name) {
        if (this.xClasses == null) {
            this.xClasses = new HashSet();
        }
        this.xClasses.add(name);
    }

    public Set getInternalClasses() {
        HashSet<String> result = this.internalClasses;
        if (result == null) {
            for (int i = 0; i < this.nestedClasses.length; ++i) {
                InnerDescr m = this.nestedClasses[i];
                if (!this.isInternalMember(m)) continue;
                if (result == null) {
                    result = new HashSet<String>();
                }
                result.add(m.getName());
            }
            if (result == null) {
                result = Collections.EMPTY_SET;
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("CLASS");
        String modifiers = Modifier.toString(this.memberType, this.getModifiers(), true);
        if (modifiers.length() != 0) {
            buf.append(' ');
            buf.append(modifiers);
        }
        buf.append(' ');
        buf.append(this.name);
        if (this.typeParameters != null) {
            buf.append(this.typeParameters);
        }
        AnnotationItem[] annoList = this.getAnnoList();
        for (int i = 0; i < annoList.length; ++i) {
            buf.append("\n ");
            buf.append(annoList[i]);
        }
        return buf.toString();
    }

    public boolean isTopClass() {
        return "".equals(this.declaringClass);
    }

    public Set getDependences() {
        HashSet set = new HashSet();
        this.populateDependences(set);
        return set;
    }

    @Override
    protected void populateDependences(Set dependences) {
        this.populateDependences(this.getInterfaces(), dependences);
        AnnotationItem[] annots = this.getAnnoList();
        for (int i = 0; i < annots.length; ++i) {
            if (annots[i].getName().equals(this.name)) continue;
            this.addDependency(dependences, annots[i].getName());
        }
        if (this.superClass != null) {
            this.addDependency(dependences, this.superClass.getQualifiedName());
        }
        if (!this.isTopClass()) {
            this.addDependency(dependences, this.declaringClass);
        }
    }

    public void populateDependences(MemberDescription[] members, Set dependences) {
        for (int i = 0; i < members.length; ++i) {
            if (members[i].isPublic() || members[i].isProtected()) {
                members[i].populateDependences(dependences);
                continue;
            }
            if (!members[i].isSuperInterface()) continue;
            this.addDependency(dependences, members[i].getQualifiedName());
        }
    }

    public boolean isDocumentedAnnotation() {
        if (this.hasModifier(Modifier.ANNOTATION)) {
            AnnotationItem[] annots = this.getAnnoList();
            for (int i = 0; i < annots.length; ++i) {
                if (!"java.lang.annotation.Documented".equals(annots[i].getName())) continue;
                return true;
            }
        }
        return false;
    }

    public ClassHierarchy getClassHierarchy() {
        return this.hierarchy;
    }

    public void setHierarchy(ClassHierarchy hierarchy) {
        this.hierarchy = hierarchy;
    }

    public static class TypeParameterList {
        Map tab = new HashMap();
        int seqnb = 0;

        public TypeParameterList(TypeParameterList enclosing) {
            if (enclosing != null && !enclosing.tab.isEmpty()) {
                this.tab.putAll(enclosing.tab);
            }
        }

        public void reset_count() {
            this.seqnb = 0;
        }

        public Map getTab() {
            return this.tab;
        }

        public void add(String id, String declared) {
            TypeParam e;
            TypeParam o;
            if ((o = this.tab.put(id, e = new TypeParam(this.seqnb++, id, declared))) == null) {
                return;
            }
            if (o.declared.equals(e.declared)) {
                Object[] invargs = new String[]{id, e.declared, o.declared};
                throw new Error(i18n.getString("ClassDescription.error.declaredtwice", invargs));
            }
            e.hidden = o;
        }

        public void clear(String declared) {
            ArrayList<TypeParam> tmp = new ArrayList<TypeParam>();
            for (Map.Entry ent : this.tab.entrySet()) {
                TypeParam e = (TypeParam)ent.getValue();
                if (!e.declared.equals(declared)) continue;
                tmp.add(e);
            }
            for (TypeParam e : tmp) {
                if (e.hidden == null) {
                    this.tab.remove(e.ident);
                    continue;
                }
                this.tab.put(e.ident, e.hidden);
            }
        }

        public String replace(String id) {
            TypeParam e = (TypeParam)this.tab.get(id);
            if (e == null) {
                return TypeParameterList.replaceNone(id);
            }
            return "{" + e.declared + '%' + String.valueOf(e.seqnb) + "}";
        }

        public static String replaceNone(String id) {
            return "{?" + id + "}";
        }

        public String replaceForwards(String s) {
            int k;
            int i;
            while ((i = s.indexOf("{?")) != -1 && (k = s.indexOf(125, i)) != -1) {
                String r = this.replace(s.substring(i + 2, k));
                if (!r.startsWith("{?")) {
                    s = s.substring(0, i) + r + s.substring(k + 1);
                    continue;
                }
                throw new Error(i18n.getString("ClassDescription.error.undefined", s));
            }
            return s;
        }
    }

    public static class TypeParam {
        final int seqnb;
        final String ident;
        final String declared;
        TypeParam hidden = null;

        public TypeParam(int seqnb, String ident, String declared) {
            this.seqnb = seqnb;
            this.ident = ident;
            this.declared = declared;
        }

        public int getSeqnb() {
            return this.seqnb;
        }

        public String getIdent() {
            return this.ident;
        }

        public String getDeclared() {
            return this.declared;
        }
    }
}

