/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.classpath;

import com.sun.tdk.signaturetest.classpath.ClasspathEntry;
import com.sun.tdk.signaturetest.classpath.DirectoryEntry;
import com.sun.tdk.signaturetest.core.AppContext;
import com.sun.tdk.signaturetest.core.context.BaseOptions;
import com.sun.tdk.signaturetest.core.context.Option;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;

public class JimageJakeEntry
extends ClasspathEntry {
    private List<DirectoryEntry> module_homes = new ArrayList<DirectoryEntry>();
    private int cur_module_index = -1;
    private Path td;
    private BaseOptions bo = AppContext.getContext().getBean(BaseOptions.class);

    public JimageJakeEntry(ClasspathEntry previous, String name) throws IOException {
        super(previous);
        this.init(name);
    }

    public static void removeRecursive(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (exc == null) {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
                throw exc;
            }
        });
    }

    @Override
    public void init(String jimageName) throws IOException {
        if (!jimageName.endsWith(".jimage")) {
            throw new IOException("Wrong jimage file: " + jimageName);
        }
        this.td = Files.createTempDirectory("st_", new FileAttribute[0]);
        String tempd = this.td.toAbsolutePath().toString();
        assert (this.bo != null);
        String util = this.bo.getValue(Option.X_JIMAGE);
        if (util == null) {
            throw new IOException("JIMAGE_EXE is not defined");
        }
        try {
            Process process = new ProcessBuilder(util, "extract", "--dir", tempd, jimageName).start();
            int ret = process.waitFor();
            if (ret != 0) {
                throw new IOException("jimage error");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File baseDir = new File(tempd);
        DirectoryEntry prevEntry = null;
        for (File f : baseDir.listFiles()) {
            if (!f.isDirectory()) continue;
            DirectoryEntry de = new DirectoryEntry(prevEntry, f.getAbsolutePath());
            this.module_homes.add(de);
            prevEntry = de;
        }
        this.setFirstModule();
    }

    @Override
    public InputStream findClass(String name) throws IOException, ClassNotFoundException {
        for (DirectoryEntry module : this.module_homes) {
            try {
                return module.findClass(name);
            }
            catch (IOException | ClassNotFoundException e) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public boolean hasNext() {
        if (this.isEmpty()) {
            return false;
        }
        do {
            if (!this.getCurrentModule().hasNext()) continue;
            return true;
        } while (this.nextModule() != null);
        return false;
    }

    @Override
    public String nextClassName() {
        if (!this.hasNext()) {
            return null;
        }
        return this.getCurrentModule().nextClassName();
    }

    @Override
    public void setListToBegin() {
        this.setFirstModule();
        this.getCurrentModule().setListToBegin();
    }

    @Override
    protected boolean contains(String className) {
        for (DirectoryEntry module : this.module_homes) {
            if (module.contains(className)) continue;
            return true;
        }
        return this.previousEntry != null && this.previousEntry.contains(className);
    }

    @Override
    public boolean isEmpty() {
        for (DirectoryEntry module : this.module_homes) {
            if (module.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private DirectoryEntry getCurrentModule() {
        return this.module_homes.get(this.cur_module_index);
    }

    private DirectoryEntry nextModule() {
        if (this.cur_module_index == this.module_homes.size() - 1) {
            return null;
        }
        DirectoryEntry res = this.module_homes.get(++this.cur_module_index);
        res.setListToBegin();
        return res;
    }

    private void setFirstModule() {
        this.cur_module_index = this.module_homes.isEmpty() ? -1 : 0;
    }

    @Override
    public void close() {
        try {
            JimageJakeEntry.removeRecursive(this.td);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

