/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: GreetingBean.java 62595 2011-04-20 20:38:55Z kgrucci $
 */

package com.sun.ts.tests.ejb30.common.generics;

import javax.annotation.security.RolesAllowed;
import javax.ejb.Stateless;

@Stateless
public class GreetingBean extends GreetingBeanBase
        implements RemoteIntGreetingIF, LocalIntGreetingIF, 
        RemoteParameterizedIF, LocalParameterizedIF {
    
    //inherit business methods from GreetingBeanBase, along with their @TransactionAttribute
    
    /* (non-Javadoc)
     * @see com.sun.ts.tests.ejb30.common.generics.GenericGreetingIF#rolesAllowed()
     */
    @RolesAllowed("Administrator")
    public Integer rolesAllowed(Integer i) {
        return i;
    }

    /* (non-Javadoc)
     * @see com.sun.ts.tests.ejb30.common.generics.GenericGreetingIF#rolesAllowedNoArg()
     */
    @RolesAllowed("Manager")
    public Integer rolesAllowedNoArg() {
        return 0;
    }
}
