 /*
  * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
  * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
  */
/*
 * $Id: InjectiontAllowedBeanBase.java 62595 2011-04-20 20:38:55Z kgrucci $
 */

package com.sun.ts.tests.ejb30.common.allowed;

import com.sun.ts.tests.ejb30.common.helper.TLogger;
import java.util.Properties;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import static com.sun.ts.tests.ejb30.common.allowed.Constants.EJBContextLookupName;


public abstract class InjectiontAllowedBeanBase extends SessionContextAllowedBeanBase
        implements SessionContextAllowedIF, SessionContextAllowedLocalIF {
    protected  boolean myBoolean;
    
    @Override
    public void setSessionContext(SessionContext sc) {
        this.sessionContext = sc;
    }
    
    public void setMyBoolean(boolean b) {
        myBoolean = b;
        this.results= null;
        SessionContext sctxNotNull = null;
        if(sessionContext != null) {
            TLogger.log("SessionContext has been injected, no need to look it up.");
            sctxNotNull = this.sessionContext;
        } else {
            TLogger.log("SessionContext has not been injected, need to look it up.");
            try {
                InitialContext ic = new InitialContext();
                sctxNotNull = (SessionContext) ic.lookup(EJBContextLookupName);
            } catch (NamingException ex) {
                TLogger.log("Failed to look up SessionContext with name " + EJBContextLookupName, 
                        ex.getMessage());
            }
        }
        this.results = runOperations(sctxNotNull);
    }
    
    public Properties runOperations(SessionContext sctx) {
        Operations op = Operations.getInstance();
        Properties results = new Properties();
        op.runGetEJBHome(sctx,  results);
        op.runGetEJBLocalHome(sctx, results);
        op.runJndiAccess(sctx, results);
        op.runEJBContextLookup(sctx, results);
        return results;
    }
    
}
