/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $URL: https://adc4110351.us.oracle.com/svn/spider/branches/cts/8.0/src/com/sun/ts/tests/common/taglibsig/validation/URIValidator.java $ $LastChangedDate: 2011-04-20 13:07:16 -0700 (Wed, 20 Apr 2011) $
 */
 
package com.sun.ts.tests.common.taglibsig.validation;

import com.sun.ts.tests.common.taglibsig.TagLibraryDescriptor;

import java.util.List;
import java.util.ArrayList;

/**
 * Performs validation of TagLibraryDescriptor <code>&lt;uri&gt;</code> elements.
 */
public class URIValidator implements Validator {


    public List validate(TagLibraryDescriptor control, TagLibraryDescriptor underTest) {
        List messages = new ArrayList();
        if (control == null || underTest == null) {
            messages.add("[URIValidator] Null arguments.");
        } else {
            String controlUri = control.getURI();
            String underTestUri = underTest.getURI();
            if (!(controlUri.equals(underTestUri))) {
                messages.add("Incorrect URI found.  Expected: '" + controlUri + "'," +
                    " received: '" + underTestUri + "'.");
            }
        }
        return messages;
    }
}
