/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.websocket;

final class StatusCodes {
    static final int PROTOCOL_ERROR = 1002;
    static final int NO_STATUS_CODE = 1005;
    static final int CLOSED_ABNORMALLY = 1006;
    static final int NOT_CONSISTENT = 1007;

    private StatusCodes() {
    }

    static boolean isLegalToSendFromClient(int n) {
        if (!StatusCodes.isLegal(n)) {
            return false;
        }
        if (n > 4999) {
            return false;
        }
        switch (n) {
            case 1002: 
            case 1003: 
            case 1007: 
            case 1009: 
            case 1010: 
            case 1012: 
            case 1013: 
            case 1014: {
                return false;
            }
        }
        return true;
    }

    static boolean isLegalToReceiveFromServer(int n) {
        if (!StatusCodes.isLegal(n)) {
            return false;
        }
        return n != 1010;
    }

    private static boolean isLegal(int n) {
        if (n < 1000 || n > 65535) {
            return false;
        }
        if (n >= 1016 && n <= 2999 || n == 1004) {
            return false;
        }
        switch (n) {
            case 1005: 
            case 1006: 
            case 1015: {
                return false;
            }
        }
        return true;
    }
}

