/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.model;

import com.sun.tdk.signaturetest.model.MemberType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Modifier
implements Serializable {
    private static final Map knownModifiers = new HashMap();
    public static final Modifier ABSTRACT = new Modifier("abstract", 1024, 1024, true);
    public static final Modifier PUBLIC = new Modifier("public", 1, 1, true);
    public static final Modifier PRIVATE = new Modifier("private", 2, 2, true);
    public static final Modifier PROTECTED = new Modifier("protected", 4, 4, true);
    public static final Modifier STATIC = new Modifier("static", 8, 8, true);
    public static final Modifier FINAL = new Modifier("final", 16, 16, true);
    public static final Modifier SYNCHRONIZED = new Modifier("synchronized", 32, 32, false);
    public static final Modifier NATIVE = new Modifier("native", 256, 256, false);
    public static final Modifier INTERFACE = new Modifier("interface", 512, 512, true);
    public static final Modifier TRANSIENT = new Modifier("transient", 128, 128, false);
    public static final Modifier VOLATILE = new Modifier("volatile", 64, 64, true);
    public static final Modifier ENUM = new Modifier("!enum", 16384, 0, true);
    public static final Modifier FIELD_ENUM = new Modifier("!fld_enum", 16384, 0, false);
    public static final Modifier ANNOTATION = new Modifier("!annotation", 8192, 0, true);
    public static final Modifier VARARGS = new Modifier("!varargs", 128, 0, true);
    public static final Modifier BRIDGE = new Modifier("!bridge", 64, 0, false);
    public static final Modifier HASDEFAULT = new Modifier("!hasdefault", 0x2000000, 0, true);
    public static final Modifier ACC_SUPER = new Modifier("acc_super", 32, 0, false);
    public static final Modifier ACC_SYNTHETIC = new Modifier("acc_synthetic", 4096, 0, false);
    public static final Modifier ACC_STRICT = new Modifier("acc_strict", 2048, 2048, false);
    private final String name;
    private final int value;
    private boolean isTracked;

    public String toString() {
        return this.name;
    }

    public boolean isTracked() {
        return this.isTracked;
    }

    public int getValue() {
        return this.value;
    }

    public void setTracked(boolean bl) {
        this.isTracked = bl;
    }

    public static Modifier getModifier(String string) {
        return (Modifier)knownModifiers.get(string);
    }

    public static Modifier[] getAllModifiers() {
        return knownModifiers.values().toArray(new Modifier[0]);
    }

    public static int scanModifiers(List list) {
        Modifier modifier;
        int n = 0;
        while (list.size() > 0 && (modifier = Modifier.getModifier((String)list.get(0))) != null) {
            n |= modifier.value;
            list.remove(0);
        }
        return n;
    }

    public static boolean hasModifier(int n, Modifier modifier) {
        return (n & modifier.value) != 0;
    }

    static int addModifier(int n, Modifier modifier) {
        return n | modifier.value;
    }

    static int removeModifier(int n, Modifier modifier) {
        return n & ~modifier.value;
    }

    public static String toString(MemberType memberType, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        Modifier[] modifierArray = memberType.getApplicableModifiers();
        boolean bl2 = false;
        for (int i = 0; i < modifierArray.length; ++i) {
            Modifier modifier = modifierArray[i];
            if ((modifier.value & n) == 0 || bl && !modifier.isTracked()) continue;
            if (bl2) {
                stringBuffer.append(' ');
            }
            bl2 = true;
            stringBuffer.append(modifier.name);
        }
        return stringBuffer.toString();
    }

    private Modifier(String string, int n, int n2, boolean bl) {
        if (n != n2 && n2 != 0) {
            throw new IllegalArgumentException();
        }
        this.name = string;
        this.value = n;
        this.isTracked = bl;
        knownModifiers.put(string, this);
    }

    public Modifier(String string, boolean bl) {
        Modifier[] modifierArray = Modifier.getAllModifiers();
        int n = 0;
        for (int i = 0; i < modifierArray.length; ++i) {
            if (modifierArray[i].name.equals(string)) {
                throw new IllegalArgumentException("Name " + string + " is already used");
            }
            n |= modifierArray[i].getValue();
        }
        if ((n = this.highestOneBit(~n)) == 0) {
            throw new IllegalArgumentException("No room for the new modifier " + string);
        }
        this.name = string;
        this.value = n;
        this.isTracked = bl;
        knownModifiers.put(string, this);
    }

    private int highestOneBit(int n) {
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        n |= n >> 16;
        return n - (n >>> 1);
    }
}

