 /*
  * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
  * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
  */
/*
 * $Id: Stateful3VehicleRunner.java 62592 2011-04-20 20:07:16Z kgrucci $
 */

package com.sun.ts.tests.common.vehicle.stateful3;

import java.util.Properties;
import com.sun.ts.lib.harness.EETest;
import com.sun.javatest.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;

public class Stateful3VehicleRunner implements VehicleRunnable {
    public static final String STATEFUL3_REF_NAME = "java:comp/env/ejb/Stateful3VehicleBean";
    
    public Status run(String[] args, Properties props) {
        Status sTestStatus = null;
        try {
            TSNamingContext jc= new TSNamingContext();
            Stateful3VehicleIF bean = (Stateful3VehicleIF) jc.lookup(STATEFUL3_REF_NAME);
            TestUtil.logTrace("stateful3 runner looked up vehicle: " + bean);
            sTestStatus = (bean.runTest(args, props)).toStatus();
        } catch(Exception e) {
            TestUtil.logErr("Test failed.", e);
            sTestStatus = Status.failed("Test run in stateful3 vehicle failed.");
        }
        return sTestStatus;
    }
}

