/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.concurrency.api.common.counter;

import javax.naming.*;

public class CounterRunnableTask implements Runnable {

    private String countSingletionJndi = "";
    private long sleepTime = 0;

    public CounterRunnableTask(String countSingletionJndi) {
	this.countSingletionJndi = countSingletionJndi;
    }

    public CounterRunnableTask(String countSingletionJndi, long sleepTime) {
	this.countSingletionJndi = countSingletionJndi;
	this.sleepTime = sleepTime;
    }

    public void run() {
	try {
	    if (sleepTime > 0) {
		Thread.sleep(sleepTime);
	    }

	    InitialContext context = new InitialContext();
	    CounterRemote counter = (CounterRemote) context
		    .lookup(countSingletionJndi);
	    counter.inc();

	} catch (Exception e) {
	    throw new RuntimeException(e);
	}

    }
}
