/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.concurrency.api.common;

import java.util.*;
import javax.enterprise.concurrent.*;

public class CommonTriggers {

    /**
     * A trigger that only run once.
     */
    public static class OnceTrigger implements Trigger {
	public Date getNextRunTime(LastExecution lastExecutionInfo,
		Date taskScheduledTime) {
	    if (lastExecutionInfo != null) {
		return null;
	    }
	    return new Date();
	}

	public boolean skipRun(LastExecution lastExecutionInfo,
		Date scheduledRunTime) {
	    return false;
	}
    }

    /**
     * A trigger that will skip.
     */
    public static class OnceTriggerDelaySkip implements Trigger {

        public OnceTriggerDelaySkip(long argDelay) {
            delay = argDelay;
        }
        
        private long delay;
        
	public Date getNextRunTime(LastExecution lastExecutionInfo,
		Date taskScheduledTime) {
	    if (lastExecutionInfo != null) {
		return null;
	    }
	    return new Date(new Date().getTime() + delay);
	}

	public boolean skipRun(LastExecution lastExecutionInfo,
		Date scheduledRunTime) {
	    return true;
	}
    }
    
    /**
     * A fixed-rate trigger
     */
    public static class TriggerFixedRate implements Trigger {
	private Date startTime;
	private long delta;
        private int executionCount = 0;
        private static final int executionCountLimit = 10;
        
	public TriggerFixedRate(Date startTime, long delta) {
	    this.startTime = startTime;
	    this.delta = delta;
	}

	public Date getNextRunTime(LastExecution lastExecutionInfo,
		Date taskScheduledTime) {
            executionCount++;
            if (executionCount > executionCountLimit) {
                return null;
            }

	    if (lastExecutionInfo == null) {
		return new Date(startTime.getTime() + delta);
	    }
	    return new Date(lastExecutionInfo.getScheduledStart().getTime()
		    + delta);
	}

	public boolean skipRun(LastExecution lastExecutionInfo,
		Date scheduledRunTime) {
	    return false;
	}
    }

}
