/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.concurrency.api.common;

import java.util.concurrent.Callable;

/**
 * the Runnable Task to check the context related job.
 */
public class CallableTask<T> extends RunnableTask implements Callable<T> {
    private final T expectedReturnValue;

    @Override
    public T call() {
        run();
        return expectedReturnValue;
    }

    /**
     * Construct the callable task with expected properties.
     * 
     * @param jndiName
     *            the jndi name set for env-entry, ignore jndi test if it is null.
     * @param jndiValue
     *            the jndi value set for jndiName
     * @param className
     *            class name to be loaded inside the task, ignore class loading test if it is null.
     * @param returned
     *            expected returned object.
     * @param blockTime
     *            block time(in millisecond) for this task.
     */
    public CallableTask(String jndiName, String jndiValue, String className, T returned, long blockTime) {
        super(jndiName, jndiValue, className, blockTime);
        this.expectedReturnValue = returned;
    }

    /**
     * Construct the callable task with expected properties.
     * 
     * @param jndiName
     *            the jndi name set for env-entry, ignore jndi test if it is null.
     * @param jndiValue
     *            the jndi value set for jndiName
     * @param className
     *            class name to be loaded inside the task, ignore class loading test if it is null.
     * @param returned
     *            expected returned object.
     */
    public CallableTask(String jndiName, String jndiValue, String className, T returned) {
        super(jndiName, jndiValue, className);
        this.expectedReturnValue = returned;
    }

}
