/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.ExcludeListFilter;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.util.I18NResourceBundle;

public class StatusFilter
extends TestFilter {
    private boolean[] statusValues;
    private TestResultTable trt;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(ExcludeListFilter.class);

    public StatusFilter(boolean[] statusValues, TestResultTable trt) {
        if (statusValues == null || trt == null) {
            throw new NullPointerException();
        }
        if (statusValues.length != 4) {
            throw new IllegalArgumentException();
        }
        this.statusValues = statusValues;
        this.trt = trt;
    }

    public boolean[] getStatusValues() {
        return this.statusValues;
    }

    public TestResultTable getTestResultTable() {
        return this.trt;
    }

    @Override
    public String getName() {
        return i18n.getString("statusFilter.name");
    }

    @Override
    public String getDescription() {
        return i18n.getString("statusFilter.description");
    }

    @Override
    public String getReason() {
        return i18n.getString("statusFilter.reason");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean accepts(TestDescription td) throws TestFilter.Fault {
        TestResult tr = null;
        TestResultTable testResultTable = this.trt;
        synchronized (testResultTable) {
            tr = this.trt.lookup(td);
        }
        if (tr == null) {
            throw new TestFilter.Fault(i18n, "statusFilter.cantFindTest", td.getRootRelativeURL());
        }
        Status s = tr.getStatus();
        if (s == null) {
            throw new TestFilter.Fault(i18n, "statusFilter.noStatus", td.getRootRelativeURL());
        }
        return this.statusValues[s.getType()];
    }

    @Override
    public boolean accepts(TestResult tr) throws TestFilter.Fault {
        assert (tr != null);
        Status s = tr.getStatus();
        if (s == null) {
            throw new TestFilter.Fault(i18n, "statusFilter.noStatus", tr.getTestName());
        }
        return this.statusValues[s.getType()];
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatusFilter)) {
            return false;
        }
        StatusFilter other = (StatusFilter)o;
        for (int i = 0; i < 4; ++i) {
            if (this.statusValues[i] == other.statusValues[i]) continue;
            return false;
        }
        return this.trt == other.trt;
    }

    public int hashCode() {
        int hash = 7;
        if (this.statusValues != null) {
            for (boolean v : this.statusValues) {
                hash = 67 * hash + (v ? 1 : 0);
            }
        }
        hash = 67 * hash + (this.trt != null ? this.trt.hashCode() : 0);
        return hash;
    }
}

