/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1Set;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PasswordQualityRequirement
implements Serializable {
    private static final byte TYPE_CLIENT_SIDE_VALIDATION_INFO = -95;
    private static final byte TYPE_CLIENT_SIDE_VALIDATION_PROPERTIES = -95;
    private static final long serialVersionUID = 2956655422853571644L;
    private final Map<String, String> clientSideValidationProperties;
    private final String clientSideValidationType;
    private final String description;

    public PasswordQualityRequirement(String description) {
        this(description, null, null);
    }

    public PasswordQualityRequirement(String description, String clientSideValidationType, Map<String, String> clientSideValidationProperties) {
        Validator.ensureNotNull(description);
        if (clientSideValidationType == null) {
            Validator.ensureTrue(clientSideValidationProperties == null || clientSideValidationProperties.isEmpty());
        }
        this.description = description;
        this.clientSideValidationType = clientSideValidationType;
        this.clientSideValidationProperties = clientSideValidationProperties == null ? Collections.emptyMap() : Collections.unmodifiableMap(new LinkedHashMap<String, String>(clientSideValidationProperties));
    }

    public String getDescription() {
        return this.description;
    }

    public String getClientSideValidationType() {
        return this.clientSideValidationType;
    }

    public Map<String, String> getClientSideValidationProperties() {
        return this.clientSideValidationProperties;
    }

    public ASN1Element encode() {
        ArrayList<ASN1Element> requirementElements = new ArrayList<ASN1Element>(2);
        requirementElements.add(new ASN1OctetString(this.description));
        if (this.clientSideValidationType != null) {
            ArrayList<ASN1Element> clientSideElements = new ArrayList<ASN1Element>(2);
            clientSideElements.add(new ASN1OctetString(this.clientSideValidationType));
            if (!this.clientSideValidationProperties.isEmpty()) {
                ArrayList<ASN1Sequence> propertyElements = new ArrayList<ASN1Sequence>(this.clientSideValidationProperties.size());
                for (Map.Entry<String, String> e : this.clientSideValidationProperties.entrySet()) {
                    propertyElements.add(new ASN1Sequence(new ASN1OctetString(e.getKey()), new ASN1OctetString(e.getValue())));
                }
                clientSideElements.add(new ASN1Set(-95, propertyElements));
            }
            requirementElements.add(new ASN1Sequence(-95, clientSideElements));
        }
        return new ASN1Sequence(requirementElements);
    }

    public static PasswordQualityRequirement decode(ASN1Element element) throws LDAPException {
        try {
            ASN1Element[] requirementElements = ASN1Sequence.decodeAsSequence(element).elements();
            String description = ASN1OctetString.decodeAsOctetString(requirementElements[0]).stringValue();
            String clientSideValidationType = null;
            LinkedHashMap<String, String> clientSideValidationProperties = null;
            block9: for (int i = 1; i < requirementElements.length; ++i) {
                ASN1Element requirementElement = requirementElements[i];
                switch (requirementElement.getType()) {
                    case -95: {
                        ASN1Element[] csvInfoElements = ASN1Sequence.decodeAsSequence(requirementElement).elements();
                        clientSideValidationType = ASN1OctetString.decodeAsOctetString(csvInfoElements[0]).stringValue();
                        block10: for (int j = 1; j < csvInfoElements.length; ++j) {
                            ASN1Element csvInfoElement = csvInfoElements[j];
                            switch (csvInfoElement.getType()) {
                                case -95: {
                                    ASN1Element[] csvPropElements = ASN1Sequence.decodeAsSequence(csvInfoElement).elements();
                                    clientSideValidationProperties = new LinkedHashMap<String, String>(csvPropElements.length);
                                    for (ASN1Element csvPropElement : csvPropElements) {
                                        ASN1Element[] propElements = ASN1Sequence.decodeAsSequence(csvPropElement).elements();
                                        String name = ASN1OctetString.decodeAsOctetString(propElements[0]).stringValue();
                                        String value = ASN1OctetString.decodeAsOctetString(propElements[1]).stringValue();
                                        clientSideValidationProperties.put(name, value);
                                    }
                                    continue block10;
                                }
                                default: {
                                    throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_PW_QUALITY_REQ_INVALID_CSV_ELEMENT_TYPE.get(StaticUtils.toHex(csvInfoElement.getType())));
                                }
                            }
                        }
                        continue block9;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_PW_QUALITY_REQ_INVALID_REQ_ELEMENT_TYPE.get(StaticUtils.toHex(requirementElement.getType())));
                    }
                }
            }
            return new PasswordQualityRequirement(description, clientSideValidationType, clientSideValidationProperties);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_PW_QUALITY_REQ_DECODE_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("PasswordQualityRequirement(description='");
        buffer.append(this.description);
        buffer.append('\'');
        if (this.clientSideValidationType != null) {
            buffer.append(", clientSideValidationType='");
            buffer.append(this.clientSideValidationType);
            buffer.append('\'');
            if (!this.clientSideValidationProperties.isEmpty()) {
                buffer.append(", clientSideValidationProperties={");
                Iterator<Map.Entry<String, String>> iterator = this.clientSideValidationProperties.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> e = iterator.next();
                    buffer.append('\'');
                    buffer.append(e.getKey());
                    buffer.append("'='");
                    buffer.append(e.getValue());
                    buffer.append('\'');
                    if (!iterator.hasNext()) continue;
                    buffer.append(',');
                }
                buffer.append('}');
            }
        }
        buffer.append(')');
    }
}

