/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.hpack;

import java.nio.ByteBuffer;
import java.util.Arrays;
import jdk.incubator.http.internal.hpack.Huffman;
import jdk.incubator.http.internal.hpack.ISO_8859_1;
import jdk.incubator.http.internal.hpack.IntegerReader;

final class StringReader {
    private static final int NEW = 0;
    private static final int FIRST_BYTE_READ = 1;
    private static final int LENGTH_READ = 2;
    private static final int DONE = 4;
    private final IntegerReader intReader = new IntegerReader();
    private final Huffman.Reader huffmanReader = new Huffman.Reader();
    private final ISO_8859_1.Reader plainReader = new ISO_8859_1.Reader();
    private int state = 0;
    private boolean huffman;
    private int remainingLength;

    StringReader() {
    }

    boolean read(ByteBuffer byteBuffer, Appendable appendable) {
        int n;
        if (this.state == 4) {
            return true;
        }
        if (!byteBuffer.hasRemaining()) {
            return false;
        }
        if (this.state == 0) {
            n = byteBuffer.position();
            this.huffman = (byteBuffer.get(n) & 0x80) != 0;
            this.state = 1;
            this.intReader.configure(7);
        }
        if (this.state == 1) {
            n = this.intReader.read(byteBuffer) ? 1 : 0;
            if (!n) {
                return false;
            }
            this.remainingLength = this.intReader.get();
            this.state = 2;
        }
        if (this.state == 2) {
            n = byteBuffer.remaining() >= this.remainingLength ? 1 : 0;
            int n2 = byteBuffer.limit();
            if (n) {
                byteBuffer.limit(byteBuffer.position() + this.remainingLength);
            }
            this.remainingLength -= Math.min(byteBuffer.remaining(), this.remainingLength);
            if (this.huffman) {
                this.huffmanReader.read(byteBuffer, appendable, n != 0);
            } else {
                this.plainReader.read(byteBuffer, appendable);
            }
            if (n) {
                byteBuffer.limit(n2);
                this.state = 4;
            }
            return n != 0;
        }
        throw new InternalError(Arrays.toString(new Object[]{this.state, this.huffman, this.remainingLength}));
    }

    boolean isHuffmanEncoded() {
        if (this.state < 1) {
            throw new IllegalStateException("Has not been fully read yet");
        }
        return this.huffman;
    }

    void reset() {
        if (this.huffman) {
            this.huffmanReader.reset();
        } else {
            this.plainReader.reset();
        }
        this.intReader.reset();
        this.state = 0;
    }
}

