/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.hpack;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;

final class HeaderTable {
    private static final HeaderField[] staticTable = new HeaderField[]{null, new HeaderField(":authority"), new HeaderField(":method", "GET"), new HeaderField(":method", "POST"), new HeaderField(":path", "/"), new HeaderField(":path", "/index.html"), new HeaderField(":scheme", "http"), new HeaderField(":scheme", "https"), new HeaderField(":status", "200"), new HeaderField(":status", "204"), new HeaderField(":status", "206"), new HeaderField(":status", "304"), new HeaderField(":status", "400"), new HeaderField(":status", "404"), new HeaderField(":status", "500"), new HeaderField("accept-charset"), new HeaderField("accept-encoding", "gzip, deflate"), new HeaderField("accept-language"), new HeaderField("accept-ranges"), new HeaderField("accept"), new HeaderField("access-control-allow-origin"), new HeaderField("age"), new HeaderField("allow"), new HeaderField("authorization"), new HeaderField("cache-control"), new HeaderField("content-disposition"), new HeaderField("content-encoding"), new HeaderField("content-language"), new HeaderField("content-length"), new HeaderField("content-location"), new HeaderField("content-range"), new HeaderField("content-type"), new HeaderField("cookie"), new HeaderField("date"), new HeaderField("etag"), new HeaderField("expect"), new HeaderField("expires"), new HeaderField("from"), new HeaderField("host"), new HeaderField("if-match"), new HeaderField("if-modified-since"), new HeaderField("if-none-match"), new HeaderField("if-range"), new HeaderField("if-unmodified-since"), new HeaderField("last-modified"), new HeaderField("link"), new HeaderField("location"), new HeaderField("max-forwards"), new HeaderField("proxy-authenticate"), new HeaderField("proxy-authorization"), new HeaderField("range"), new HeaderField("referer"), new HeaderField("refresh"), new HeaderField("retry-after"), new HeaderField("server"), new HeaderField("set-cookie"), new HeaderField("strict-transport-security"), new HeaderField("transfer-encoding"), new HeaderField("user-agent"), new HeaderField("vary"), new HeaderField("via"), new HeaderField("www-authenticate")};
    private static final int STATIC_TABLE_LENGTH = staticTable.length - 1;
    private static final int ENTRY_SIZE = 32;
    private static final Map<String, LinkedHashMap<String, Integer>> staticIndexes = new HashMap<String, LinkedHashMap<String, Integer>>(STATIC_TABLE_LENGTH);
    private final Table dynamicTable = new Table(0);
    private int maxSize;
    private int size;

    public HeaderTable(int n) {
        this.setMaxSize(n);
    }

    public int indexOf(CharSequence charSequence, CharSequence charSequence2) {
        Integer n;
        String string = charSequence.toString();
        String string2 = charSequence2.toString();
        Map map = staticIndexes.get(string);
        if (map != null && (n = (Integer)map.get(string2)) != null) {
            return n;
        }
        int n2 = this.dynamicTable.indexOf(string, string2);
        if (n2 > 0) {
            return STATIC_TABLE_LENGTH + n2;
        }
        if (n2 < 0) {
            if (map != null) {
                return -((Integer)map.values().iterator().next()).intValue();
            }
            return -STATIC_TABLE_LENGTH + n2;
        }
        if (map != null) {
            return -((Integer)map.values().iterator().next()).intValue();
        }
        return 0;
    }

    public int size() {
        return this.size;
    }

    public int maxSize() {
        return this.maxSize;
    }

    public int length() {
        return STATIC_TABLE_LENGTH + this.dynamicTable.size();
    }

    HeaderField get(int n) {
        this.checkIndex(n);
        if (n <= STATIC_TABLE_LENGTH) {
            return staticTable[n];
        }
        return this.dynamicTable.get(n - STATIC_TABLE_LENGTH);
    }

    void put(CharSequence charSequence, CharSequence charSequence2) {
        this.put(new HeaderField(charSequence.toString(), charSequence2.toString()));
    }

    private void put(HeaderField headerField) {
        int n = this.sizeOf(headerField);
        while (n > this.maxSize - this.size && this.size != 0) {
            this.evictEntry();
        }
        if (n > this.maxSize - this.size) {
            return;
        }
        this.size += n;
        this.dynamicTable.add(headerField);
    }

    void setMaxSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("maxSize >= 0: maxSize=" + n);
        }
        while (n < this.size && this.size != 0) {
            this.evictEntry();
        }
        this.maxSize = n;
        int n2 = n / 32 + 1;
        this.dynamicTable.setCapacity(n2);
    }

    HeaderField evictEntry() {
        HeaderField headerField = this.dynamicTable.remove();
        this.size -= this.sizeOf(headerField);
        return headerField;
    }

    public String toString() {
        double d = this.maxSize == 0 ? 0.0 : 100.0 * ((double)this.size / (double)this.maxSize);
        return String.format("entries: %d; used %s/%s (%.1f%%)", this.dynamicTable.size(), this.size, this.maxSize, d);
    }

    int checkIndex(int n) {
        if (n < 1 || n > STATIC_TABLE_LENGTH + this.dynamicTable.size()) {
            throw new IllegalArgumentException(String.format("1 <= index <= length(): index=%s, length()=%s", n, this.length()));
        }
        return n;
    }

    int sizeOf(HeaderField headerField) {
        return headerField.name.length() + headerField.value.length() + 32;
    }

    String getStateString() {
        if (this.size == 0) {
            return "empty.";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.dynamicTable.size();
        for (int i = 1; i <= n; ++i) {
            HeaderField headerField = this.dynamicTable.get(i);
            stringBuilder.append(String.format("[%3d] (s = %3d) %s: %s\n", i, this.sizeOf(headerField), headerField.name, headerField.value));
        }
        stringBuilder.append(String.format("      Table size:%4s", this.size));
        return stringBuilder.toString();
    }

    static {
        for (int i = 1; i <= STATIC_TABLE_LENGTH; ++i) {
            HeaderField headerField = staticTable[i];
            Map map = staticIndexes.computeIfAbsent(headerField.name, string -> new LinkedHashMap());
            map.put(headerField.value, i);
        }
    }

    static final class CircularBuffer<E> {
        int tail;
        int head;
        int size;
        int capacity;
        Object[] elements;

        CircularBuffer(int n) {
            this.capacity = n;
            this.elements = new Object[n];
        }

        void add(E e) {
            if (this.size == this.capacity) {
                throw new IllegalStateException(String.format("No room for '%s': capacity=%s", e, this.capacity));
            }
            this.elements[this.head] = e;
            this.head = (this.head + 1) % this.capacity;
            ++this.size;
        }

        E remove() {
            if (this.size == 0) {
                throw new NoSuchElementException("Empty");
            }
            Object object = this.elements[this.tail];
            this.elements[this.tail] = null;
            this.tail = (this.tail + 1) % this.capacity;
            --this.size;
            return (E)object;
        }

        E get(int n) {
            if (n < 0 || n >= this.size) {
                throw new IndexOutOfBoundsException(String.format("0 <= index <= capacity: index=%s, capacity=%s", n, this.capacity));
            }
            int n2 = (this.tail + (this.size - n - 1)) % this.capacity;
            return (E)this.elements[n2];
        }

        public void resize(int n) {
            if (n < this.size) {
                throw new IllegalStateException(String.format("newCapacity >= size: newCapacity=%s, size=%s", n, this.size));
            }
            Object[] objectArray = new Object[n];
            if (this.tail < this.head || this.size == 0) {
                System.arraycopy(this.elements, this.tail, objectArray, 0, this.size);
            } else {
                System.arraycopy(this.elements, this.tail, objectArray, 0, this.elements.length - this.tail);
                System.arraycopy(this.elements, 0, objectArray, this.elements.length - this.tail, this.head);
            }
            this.elements = objectArray;
            this.tail = 0;
            this.head = this.size;
            this.capacity = n;
        }
    }

    private static final class Table {
        private final Map<String, Map<String, Long>> map;
        private final CircularBuffer<HeaderField> buffer;
        private long counter = 1L;

        Table(int n) {
            this.buffer = new CircularBuffer(n);
            this.map = new HashMap<String, Map<String, Long>>(n);
        }

        void add(HeaderField headerField) {
            this.buffer.add(headerField);
            Map map = this.map.computeIfAbsent(headerField.name, string -> new HashMap());
            map.put(headerField.value, this.counter++);
        }

        HeaderField get(int n) {
            return this.buffer.get(n - 1);
        }

        int indexOf(String string, String string2) {
            Map<String, Long> map = this.map.get(string);
            if (map == null) {
                return 0;
            }
            Long l = map.get(string2);
            if (l != null) {
                return (int)(this.counter - l);
            }
            assert (!map.isEmpty());
            Long l2 = map.values().iterator().next();
            return -((int)(this.counter - l2));
        }

        HeaderField remove() {
            HeaderField headerField = this.buffer.remove();
            Map<String, Long> map = this.map.get(headerField.name);
            Long l = map.remove(headerField.value);
            assert (l != null);
            if (map.isEmpty()) {
                this.map.remove(headerField.name);
            }
            return headerField;
        }

        int size() {
            return this.buffer.size;
        }

        public void setCapacity(int n) {
            this.buffer.resize(n);
        }
    }

    static final class HeaderField {
        final String name;
        final String value;

        public HeaderField(String string) {
            this(string, "");
        }

        public HeaderField(String string, String string2) {
            this.name = string;
            this.value = string2;
        }

        public String toString() {
            return this.value.isEmpty() ? this.name : this.name + ": " + this.value;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            HeaderField headerField = (HeaderField)object;
            return this.name.equals(headerField.name) && this.value.equals(headerField.value);
        }

        public int hashCode() {
            return 31 * this.name.hashCode() + this.value.hashCode();
        }
    }
}

