/*
 * Copyright (c) 2007, 2018 Oracle and/or its affiliates. All rights reserved.
 * Copyright (c) 2002 International Business Machines Corp. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

// Helper class generated by xrpcc, do not edit.
// Contents subject to change without notice.

package com.sun.ts.tests.jaxrpc.ee.w2j.rpc.encoded.marshalltest;

import java.util.Map;
import java.util.HashMap;

public class EnumInt {
  private int value;

  private static Map valueMap = new HashMap();

  public static final int _value1 = (int) -2147483648;

  public static final int _value2 = (int) 2147483647;

  public static final EnumInt value1 = new EnumInt(_value1);

  public static final EnumInt value2 = new EnumInt(_value2);

  protected EnumInt(int value) {
    this.value = value;
    valueMap.put(this.toString(), this);
  }

  public int getValue() {
    return value;
  }

  public static EnumInt fromValue(int value)
      throws java.lang.IllegalStateException {
    if (value1.value == value) {
      return value1;
    } else if (value2.value == value) {
      return value2;
    }
    throw new IllegalArgumentException();
  }

  public static EnumInt fromString(String value)
      throws java.lang.IllegalStateException {
    EnumInt ret = (EnumInt) valueMap.get(value);
    if (ret != null) {
      return ret;
    }
    if (value.equals("-2147483648")) {
      return value1;
    } else if (value.equals("2147483647")) {
      return value2;
    }
    throw new IllegalArgumentException();
  }

  public String toString() {
    return new Integer(value).toString();
  }

  private Object readResolve() throws java.io.ObjectStreamException {
    return fromValue(getValue());
  }

  public boolean equals(Object obj) {
    if (!(obj instanceof EnumInt)) {
      return false;
    }
    return ((EnumInt) obj).value == value;
  }

  public int hashCode() {
    return new Integer(value).toString().hashCode();
  }
}
