/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.hpack;

import java.nio.ByteBuffer;
import java.util.Arrays;

final class IntegerReader {
    private static final int NEW = 0;
    private static final int CONFIGURED = 1;
    private static final int FIRST_BYTE_READ = 2;
    private static final int DONE = 4;
    private int state = 0;
    private int N;
    private int maxValue;
    private int value;
    private long r;
    private long b = 1L;

    IntegerReader() {
    }

    public IntegerReader configure(int n) {
        return this.configure(n, Integer.MAX_VALUE);
    }

    public IntegerReader configure(int n, int n2) {
        if (this.state != 0) {
            throw new IllegalStateException("Already configured");
        }
        IntegerReader.checkPrefix(n);
        if (n2 < 0) {
            throw new IllegalArgumentException("maxValue >= 0: maxValue=" + n2);
        }
        this.maxValue = n2;
        this.N = n;
        this.state = 1;
        return this;
    }

    public boolean read(ByteBuffer byteBuffer) {
        int n;
        if (this.state == 0) {
            throw new IllegalStateException("Configure first");
        }
        if (this.state == 4) {
            return true;
        }
        if (!byteBuffer.hasRemaining()) {
            return false;
        }
        if (this.state == 1) {
            n = (2 << this.N - 1) - 1;
            int n2 = byteBuffer.get() & n;
            if (n2 != n) {
                this.value = n2;
                this.state = 4;
                return true;
            }
            this.r = n;
            this.state = 2;
        }
        if (this.state == 2) {
            do {
                if (!byteBuffer.hasRemaining()) {
                    return false;
                }
                n = byteBuffer.get();
                long l = this.b * (long)(n & 0x7F);
                if (this.r + l > (long)this.maxValue) {
                    throw new IllegalArgumentException(String.format("Integer overflow: maxValue=%,d, value=%,d", this.maxValue, this.r + l));
                }
                this.r += l;
                this.b *= 128L;
            } while ((0x80 & n) == 128);
            this.value = (int)this.r;
            this.state = 4;
            return true;
        }
        throw new InternalError(Arrays.toString(new Object[]{this.state, this.N, this.maxValue, this.value, this.r, this.b}));
    }

    public int get() throws IllegalStateException {
        if (this.state != 4) {
            throw new IllegalStateException("Has not been fully read yet");
        }
        return this.value;
    }

    private static void checkPrefix(int n) {
        if (n < 1 || n > 8) {
            throw new IllegalArgumentException("1 <= N <= 8: N= " + n);
        }
    }

    public IntegerReader reset() {
        this.b = 1L;
        this.state = 0;
        return this;
    }
}

