/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgsMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class BooleanValueArgument
extends Argument {
    private static final long serialVersionUID = -3903872574065550222L;
    private final Boolean defaultValue;
    private Boolean value;

    public BooleanValueArgument(Character shortIdentifier, String longIdentifier, String description) throws ArgumentException {
        this(shortIdentifier, longIdentifier, false, null, description);
    }

    public BooleanValueArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, String valuePlaceholder, String description) throws ArgumentException {
        this(shortIdentifier, longIdentifier, isRequired, valuePlaceholder, description, null);
    }

    public BooleanValueArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, String valuePlaceholder, String description, Boolean defaultValue) throws ArgumentException {
        super(shortIdentifier, longIdentifier, isRequired, 1, valuePlaceholder == null ? ArgsMessages.INFO_PLACEHOLDER_TRUE_FALSE.get() : valuePlaceholder, description);
        this.defaultValue = defaultValue;
        this.value = null;
    }

    private BooleanValueArgument(BooleanValueArgument source) {
        super(source);
        this.defaultValue = source.defaultValue;
        this.value = null;
    }

    @Override
    public List<String> getValueStringRepresentations(boolean useDefault) {
        if (this.value == null) {
            if (useDefault && this.defaultValue != null) {
                return Collections.unmodifiableList(Arrays.asList(this.defaultValue.toString()));
            }
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(this.value.toString()));
    }

    @Override
    protected boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public Boolean getDefaultValue() {
        return this.defaultValue;
    }

    public Boolean getValue() {
        if (this.value == null) {
            return this.defaultValue;
        }
        return this.value;
    }

    @Override
    protected void addValue(String valueString) throws ArgumentException {
        if (this.value != null) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_MAX_OCCURRENCES_EXCEEDED.get(this.getIdentifierString()));
        }
        String lowerStr = StaticUtils.toLowerCase(valueString);
        if (lowerStr.equals("true") || lowerStr.equals("t") || lowerStr.equals("yes") || lowerStr.equals("y") || lowerStr.equals("on") || lowerStr.equals("1")) {
            this.value = Boolean.TRUE;
        } else if (lowerStr.equals("false") || lowerStr.equals("f") || lowerStr.equals("no") || lowerStr.equals("n") || lowerStr.equals("off") || lowerStr.equals("0")) {
            this.value = Boolean.FALSE;
        } else {
            throw new ArgumentException(ArgsMessages.ERR_ARG_VALUE_NOT_ALLOWED.get(valueString, this.getIdentifierString()));
        }
    }

    @Override
    public String getDataTypeName() {
        return ArgsMessages.INFO_BOOLEAN_VALUE_TYPE_NAME.get();
    }

    @Override
    public String getValueConstraints() {
        return ArgsMessages.INFO_BOOLEAN_VALUE_CONSTRAINTS.get();
    }

    @Override
    protected void reset() {
        super.reset();
        this.value = null;
    }

    @Override
    public BooleanValueArgument getCleanCopy() {
        return new BooleanValueArgument(this);
    }

    @Override
    protected void addToCommandLine(List<String> argStrings) {
        if (this.value != null) {
            argStrings.add(this.getIdentifierString());
            if (this.isSensitive()) {
                argStrings.add("***REDACTED***");
            } else {
                argStrings.add(String.valueOf(this.value));
            }
        }
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("BooleanValueArgument(");
        this.appendBasicToStringInfo(buffer);
        if (this.defaultValue != null) {
            buffer.append(", defaultValue=");
            buffer.append(this.defaultValue);
        }
        buffer.append(')');
    }
}

