/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.utils.installer;

import com.sun.jck.utils.installer.MegaZipFile;
import java.io.File;
import java.util.Iterator;
import java.util.Map;

public class Installer {
    private File m_outdir;
    private int m_verbosity = 1;
    private int m_mode;
    private File m_archiveFile;
    private String m_onError;

    public static void main(String[] stringArray) {
        Installer installer = new Installer();
        try {
            installer.run(stringArray);
            System.exit(0);
        }
        catch (BadArgs badArgs) {
            System.err.println("Invalid or poorly formed command line argument:");
            System.err.println(badArgs.getMessage());
            Installer.usage();
            System.exit(1);
        }
        catch (Fault fault) {
            System.err.println(fault.getMessage());
            System.exit(2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
            System.exit(3);
        }
    }

    public void run(String[] stringArray) throws BadArgs, Fault {
        MegaZipFile megaZipFile;
        int n = 0;
        boolean bl = false;
        if (System.getProperty("DEBUG") != null) {
            this.m_verbosity = 2;
        }
        while (n < stringArray.length) {
            String string;
            block31: {
                block30: {
                    if ((string = stringArray[n++]).equalsIgnoreCase("-usage") || string.equalsIgnoreCase("-help")) break block30;
                    if (!string.equalsIgnoreCase("\\?")) break block31;
                }
                this.usage();
                return;
            }
            if (string.equalsIgnoreCase("-q")) {
                this.m_verbosity = 0;
                continue;
            }
            if (string.equalsIgnoreCase("-l")) {
                this.m_mode = 1;
                continue;
            }
            if (string.equalsIgnoreCase("-o")) {
                if (n >= stringArray.length) {
                    throw new BadArgs("No value provided for output directory (-o) option");
                }
                this.m_outdir = new File(stringArray[n++]);
                continue;
            }
            if (string.equalsIgnoreCase("-f")) {
                if (n >= stringArray.length) {
                    throw new BadArgs("No value provided for archive file (-f) option");
                }
                this.m_archiveFile = new File(stringArray[n++]);
                if (this.m_archiveFile.exists()) continue;
                throw new BadArgs("The archive File " + this.m_archiveFile.getPath() + " does not exist");
            }
            if (string.equalsIgnoreCase("-onError")) {
                if (n >= stringArray.length) {
                    throw new BadArgs("No value provided for on Error (-onError) mode");
                }
                this.m_onError = stringArray[n++];
                continue;
            }
            throw new BadArgs("Unrecognized option " + string);
        }
        if (this.m_outdir == null) {
            this.m_outdir = new File(".");
        }
        if (!this.m_outdir.isDirectory()) {
            throw new BadArgs("The specified output directory " + this.m_outdir.getPath() + " is not a directory or can not be found.");
        }
        if (!this.m_outdir.canWrite()) {
            throw new BadArgs("You do not have permision to write to the output directory " + this.m_outdir.getPath());
        }
        if (this.m_archiveFile == null) {
            this.m_archiveFile = new File(System.getProperty("java.class.path"));
        }
        try {
            megaZipFile = new MegaZipFile(this.m_archiveFile, System.out);
            megaZipFile.setVerbosity(this.m_verbosity);
        }
        catch (MegaZipFile.Fault fault) {
            throw new Fault("An error occured while preparing to unpack the JCK Archive File. \n" + fault.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Fault("An error occured while preparing to unpack the JCK Archive File. \n" + illegalArgumentException.getMessage());
        }
        if (this.m_onError != null) {
            if (this.m_onError.equalsIgnoreCase("ignore")) {
                megaZipFile.setErrorMode(0);
            } else if (this.m_onError.equalsIgnoreCase("report")) {
                megaZipFile.setErrorMode(1);
            } else if (this.m_onError.equalsIgnoreCase("fail")) {
                megaZipFile.setErrorMode(2);
            } else {
                throw new BadArgs("Invalid OnError value: " + this.m_onError + "\nValid values are ignore, report, fail.");
            }
        }
        try {
            bl = this.m_mode == 1 ? megaZipFile.list() : megaZipFile.unzip(this.m_outdir);
        }
        catch (Exception exception) {
            this.handleErrors(megaZipFile.getErrors(), exception);
        }
        if (!bl) {
            this.handleErrors(megaZipFile.getErrors(), null);
        }
    }

    private void handleErrors(Map map, Exception exception) throws Fault {
        if (exception != null) {
            System.err.println("An exception occured while installing " + this.m_archiveFile.getPath() + ": " + exception.getMessage());
            System.err.println();
        }
        if (map.size() > 0) {
            Iterator iterator = map.entrySet().iterator();
            System.err.println("Errors were encountered while installing the following files:");
            System.err.println("-------------------------------------------------------------");
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                MegaZipFile.EntryFault entryFault = (MegaZipFile.EntryFault)entry.getValue();
                System.err.println(entryFault.getEntry() + " :");
                System.err.println("     " + entryFault.getMessage());
                System.err.println();
            }
            System.err.println("-------------------------------------------------------------");
            System.err.println();
            System.err.println(map.size() + " Errors.");
        }
        throw new Fault("Install Failed!");
    }

    public static void usage() {
        String string = System.getProperty("program", "java " + Installer.class.getName());
        System.err.println("");
        System.err.println("Usage: ");
        System.err.println("  " + string + " [options] ");
        System.err.println("");
        System.err.println("Options are:");
        System.err.println("  -q                       extract JCK in quiet mode");
        System.err.println("  -l                       list contents of JCK archive file");
        System.err.println("  -onError 'mode '         mode of sensitivity Installer has to errors");
        System.err.println("  -o 'target directory'    path of directory where JCK will be installed");
        System.err.println("");
    }

    class Fault
    extends Exception {
        Fault(String string) {
            super(string);
        }
    }

    class BadArgs
    extends Exception {
        BadArgs(String string) {
            super(string);
        }
    }
}

