/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFilter;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.io.File;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

public abstract class TestFinder {
    private Map keywordCache = new HashMap();
    private static final TestDescription[] noTests = new TestDescription[0];
    private File root;
    private File rootDir;
    protected TestEnvironment env;
    private ErrorHandler errHandler;
    private Comparator comp = this.getDefaultComparator();
    private Vector files;
    private Vector tests;
    private Map testsInFile = new HashMap();
    private Vector errorMessages = new Vector();
    protected static boolean debug = Boolean.getBoolean("debug." + TestFinder.class.getName());
    private static final File userDir = new File(System.getProperty("user.dir"));
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(TestFinder.class);

    public void init(String[] args, File testSuiteRoot, TestEnvironment env) throws Fault {
        if (args != null) {
            this.decodeAllArgs(args);
        }
        this.setRoot(testSuiteRoot);
        this.env = env;
    }

    public void init(String[] args, File testSuiteRoot, File[] tests, TestFilter[] filters, TestEnvironment env) throws Fault {
        this.init(args, testSuiteRoot, env);
    }

    protected void decodeAllArgs(String[] args) throws Fault {
        int j;
        for (int i = 0; i < args.length; i += j) {
            j = this.decodeArg(args, i);
            if (j != 0) continue;
            throw new Fault(i18n, "finder.badArg", args[i]);
        }
    }

    protected int decodeArg(String[] args, int i) throws Fault {
        return 0;
    }

    protected void setRoot(File testSuiteRoot) throws IllegalStateException, Fault {
        if (this.root != null) {
            throw new IllegalStateException("root already set");
        }
        this.root = testSuiteRoot.isAbsolute() ? testSuiteRoot : new File(userDir, testSuiteRoot.getPath());
        this.rootDir = this.root.isDirectory() ? this.root : new File(this.root.getParent());
    }

    public File getRoot() {
        return this.root;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public void setComparator(Comparator c) {
        this.comp = c;
    }

    public Comparator getComparator() {
        return this.comp;
    }

    protected Comparator getDefaultComparator() {
        Collator c = Collator.getInstance(Locale.US);
        c.setStrength(0);
        return c;
    }

    public ErrorHandler getErrorHandler() {
        return this.errHandler;
    }

    public void setErrorHandler(ErrorHandler h) {
        this.errHandler = h;
    }

    protected void error(I18NResourceBundle i18n, String key) {
        this.localizedError(i18n.getString(key));
    }

    protected void error(I18NResourceBundle i18n, String key, Object arg) {
        this.localizedError(i18n.getString(key, arg));
    }

    protected void error(I18NResourceBundle i18n, String key, Object[] args) {
        this.localizedError(i18n.getString(key, args));
    }

    protected void localizedError(String msg) {
        this.errorMessages.add(msg);
        if (this.errHandler != null) {
            this.errHandler.error(msg);
        }
    }

    public synchronized int getErrorCount() {
        return this.errorMessages.size();
    }

    public synchronized String[] getErrors() {
        Object[] errs = new String[this.errorMessages.size()];
        this.errorMessages.copyInto(errs);
        return errs;
    }

    public synchronized void clearErrors() {
        this.errorMessages.setSize(0);
    }

    public boolean isFolder(File path) {
        if (!path.isAbsolute()) {
            File f = new File(this.getRoot(), path.getPath());
            return f.isDirectory();
        }
        return path.isDirectory();
    }

    public long lastModified(File f) {
        if (f.isAbsolute()) {
            return f.lastModified();
        }
        File real = new File(this.getRoot(), f.getPath());
        return real.lastModified();
    }

    public synchronized void read(File file) {
        if (this.tests != null) {
            this.tests.setSize(0);
        }
        if (this.files != null) {
            this.files.setSize(0);
        }
        this.testsInFile.clear();
        this.scan(file.isAbsolute() ? file : new File(this.rootDir, file.getPath()));
    }

    protected abstract void scan(File var1);

    protected void processEntry(Map entries, String name, String value) {
        if ((name = name.intern()).equalsIgnoreCase("keywords")) {
            String keywordCacheValue = (String)this.keywordCache.get(value);
            if (keywordCacheValue == null) {
                String lv = value.toLowerCase();
                Object[] lvs = StringArray.split(lv);
                Arrays.sort(lvs);
                keywordCacheValue = StringArray.join((String[])lvs).intern();
                this.keywordCache.put(value, keywordCacheValue);
            }
            value = keywordCacheValue;
        } else {
            value = value.intern();
        }
        entries.put(name, value);
    }

    protected Map normalize(Map entries) {
        return entries;
    }

    protected void foundTestDescription(Map entries, File file, int line) {
        String rru;
        Integer prevLine;
        String id;
        entries = this.normalize(entries);
        if (debug) {
            System.err.println("Found TestDescription");
            System.err.println("--------values----------------------------");
            for (Object key : entries.keySet()) {
                System.err.println(">> " + key + ": " + entries.get(key));
            }
            System.err.println("------------------------------------------");
        }
        if ((id = (String)entries.get("id")) == null) {
            id = "";
        }
        if ((prevLine = (Integer)this.testsInFile.get(id)) != null) {
            String newId;
            int i = 1;
            while (this.testsInFile.get(newId = id + "__" + i) != null) {
                ++i;
            }
            this.error(i18n, "finder.nonUniqueId", new Object[]{file, id.equals("") ? "(unset)" : id, new Integer(line), prevLine, newId});
            id = newId;
            entries.put("id", id);
        }
        this.testsInFile.put(id, new Integer(line));
        TestDescription td = new TestDescription(this.root, file, entries);
        if (this.errHandler != null && (rru = td.getRootRelativeURL()).indexOf(32) != -1) {
            this.error(i18n, "finder.spaceInId", td.getRootRelativeURL());
        }
        this.foundTestDescription(td);
    }

    protected void foundTestDescription(TestDescription td) {
        if (debug) {
            System.err.println("Found TestDescription" + td.getName());
        }
        if (this.tests == null) {
            this.tests = new Vector();
        }
        int target = 0;
        if (this.tests.size() == 0) {
            target = 0;
        } else if (this.comp == null) {
            target = this.tests.size();
        } else {
            int left = 0;
            int right = this.tests.size() - 1;
            int center = 0;
            String name = td.getName();
            while (left < right) {
                center = (right + left) / 2;
                int cmp = this.comp.compare(name, ((TestDescription)this.tests.get(center)).getName());
                if (cmp < 0) {
                    right = center;
                    continue;
                }
                if (cmp < 0) continue;
                left = center + 1;
            }
            target = this.comp.compare(name, ((TestDescription)this.tests.get(left)).getName()) > 0 ? left + 1 : left;
        }
        this.tests.insertElementAt(td, target);
    }

    public TestDescription[] getTests() {
        if (this.tests == null) {
            return noTests;
        }
        Object[] tds = new TestDescription[this.tests.size()];
        this.tests.copyInto(tds);
        return tds;
    }

    protected void foundFile(File newFile) {
        if (this.files == null) {
            this.files = new Vector();
        }
        int target = 0;
        if (this.files.size() == 0) {
            target = 0;
        } else if (this.comp == null) {
            target = this.files.size();
        } else {
            int left = 0;
            int right = this.files.size() - 1;
            int center = 0;
            String path = newFile.getPath();
            while (left < right) {
                center = (right + left) / 2;
                int cmp = this.comp.compare(path, ((File)this.files.get(center)).getPath());
                if (cmp < 0) {
                    right = center;
                    continue;
                }
                if (cmp < 0) continue;
                left = center + 1;
            }
            target = this.comp.compare(path, ((File)this.files.get(left)).getPath()) > 0 ? left + 1 : left;
        }
        this.files.insertElementAt(newFile, target);
    }

    public File[] getFiles() {
        if (this.files == null) {
            return new File[0];
        }
        Object[] fs = new File[this.files.size()];
        this.files.copyInto(fs);
        return fs;
    }

    public static interface ErrorHandler {
        public void error(String var1);
    }

    public static class Fault
    extends Exception {
        public Fault(I18NResourceBundle i18n, String msgKey) {
            super(i18n.getString(msgKey));
        }

        public Fault(I18NResourceBundle i18n, String msgKey, Object arg) {
            super(i18n.getString(msgKey, arg));
        }

        public Fault(I18NResourceBundle i18n, String msgKey, Object[] args) {
            super(i18n.getString(msgKey, args));
        }
    }
}

