/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.rules;

import com.sun.faces.config.beans.ManagedBeanBean;
import com.sun.faces.config.beans.ManagedPropertyBean;
import com.sun.faces.config.rules.FeatureRule;
import com.sun.faces.config.rules.ListEntriesRule;
import com.sun.faces.config.rules.MapEntriesRule;
import com.sun.faces.util.ToolsUtil;
import org.xml.sax.Attributes;

public class ManagedPropertyRule
extends FeatureRule {
    private static final String CLASS_NAME = "com.sun.faces.config.beans.ManagedPropertyBean";

    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        assert (this.digester.peek() instanceof ManagedBeanBean) : "Assertion Error: Expected ManagedBeanBean to be at the top of the stack";
        if (this.digester.getLogger().isDebugEnabled()) {
            this.digester.getLogger().debug((Object)("[ManagedPropertyRule]{" + this.digester.getMatch() + "} Push " + CLASS_NAME));
        }
        Class<?> clazz = this.digester.getClassLoader().loadClass(CLASS_NAME);
        ManagedPropertyBean mpb = (ManagedPropertyBean)clazz.newInstance();
        this.digester.push((Object)mpb);
    }

    public void body(String namespace, String name, String text) throws Exception {
    }

    public void end(String namespace, String name) throws Exception {
        ManagedPropertyBean top;
        try {
            top = (ManagedPropertyBean)this.digester.pop();
        }
        catch (Exception e) {
            throw new IllegalStateException("Popped object is not a com.sun.faces.config.beans.ManagedPropertyBean instance");
        }
        ManagedBeanBean mbb = (ManagedBeanBean)this.digester.peek();
        this.validate(mbb.getManagedBeanName(), top);
        ManagedPropertyBean old = mbb.getManagedProperty(top.getPropertyName());
        if (old == null) {
            if (this.digester.getLogger().isDebugEnabled()) {
                this.digester.getLogger().debug((Object)("[ManagedPropertyRule]{" + this.digester.getMatch() + "} New(" + top.getPropertyName() + ")"));
            }
            mbb.addManagedProperty(top);
        } else {
            if (this.digester.getLogger().isDebugEnabled()) {
                this.digester.getLogger().debug((Object)("[ManagedPropertyRule]{" + this.digester.getMatch() + "} Merge(" + top.getPropertyName() + ")"));
            }
            ManagedPropertyRule.mergeManagedProperty(top, old);
        }
    }

    public void finish() throws Exception {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ManagedPropertyRule[className=");
        sb.append(CLASS_NAME);
        sb.append("]");
        return sb.toString();
    }

    static void mergeManagedProperty(ManagedPropertyBean top, ManagedPropertyBean old) {
        if (top.getPropertyClass() != null) {
            old.setPropertyClass(top.getPropertyClass());
        }
        if (top.isNullValue()) {
            old.setNullValue(true);
        }
        if (top.getValue() != null) {
            old.setValue(top.getValue());
        }
        ManagedPropertyRule.mergeFeatures(top, old);
        ListEntriesRule.mergeListEntries(top, old);
        MapEntriesRule.mergeMapEntries(top, old);
    }

    static void mergeManagedProperties(ManagedBeanBean top, ManagedBeanBean old) {
        ManagedPropertyBean[] mpb = top.getManagedProperties();
        for (int i = 0; i < mpb.length; ++i) {
            ManagedPropertyBean mpbo = old.getManagedProperty(mpb[i].getPropertyName());
            if (mpbo == null) {
                old.addManagedProperty(mpb[i]);
                continue;
            }
            ManagedPropertyRule.mergeManagedProperty(mpb[i], mpbo);
        }
    }

    private void validate(String managedBeanName, ManagedPropertyBean property) {
        String managedPropertyName = property.getPropertyName();
        if (managedPropertyName == null || managedPropertyName.length() == 0) {
            throw new IllegalStateException(ToolsUtil.getMessage("com.sun.faces.MANAGED_BEAN_NO_MANAGED_PROPERTY_NAME", new Object[]{managedBeanName}));
        }
        if (property.getListEntries() != null && (property.getMapEntries() != null || property.getValue() != null || property.isNullValue())) {
            throw new IllegalStateException(ToolsUtil.getMessage("com.sun.faces.MANAGED_BEAN_LIST_PROPERTY_CONFIG_ERROR", new Object[]{managedBeanName, managedPropertyName}));
        }
        if (property.getMapEntries() != null && (property.getValue() != null || property.isNullValue())) {
            throw new IllegalStateException(ToolsUtil.getMessage("com.sun.faces.MANAGED_BEAN_MAP_PROPERTY_CONFIG_ERROR", new Object[]{managedBeanName, managedPropertyName}));
        }
        if (property.getListEntries() == null && property.getMapEntries() == null && property.getValue() == null && !property.isNullValue()) {
            throw new IllegalStateException(ToolsUtil.getMessage("com.sun.faces.MANAGED_BEAN_PROPERTY_CONFIG_ERROR", new Object[]{managedBeanName, managedPropertyName}));
        }
    }
}

