/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.gf.ejb;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Singleton;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.tyrus.core.ComponentProvider;

public class EjbComponentProvider
extends ComponentProvider {
    private static final Logger LOGGER = Logger.getLogger(EjbComponentProvider.class.getName());

    public <T> Object create(Class<T> c) {
        String name = this.getName(c);
        Object result = null;
        if (name == null) {
            return null;
        }
        try {
            InitialContext ic = new InitialContext();
            result = this.lookup(ic, c, name);
        }
        catch (NamingException ex) {
            String message = "An instance of EJB class " + c.getName() + " could not be looked up using simple form name or the fully-qualified form name.";
            LOGGER.log(Level.SEVERE, message, ex);
        }
        return result;
    }

    public boolean isApplicable(Class<?> c) {
        return c.isAnnotationPresent(Singleton.class) || c.isAnnotationPresent(Stateful.class) || c.isAnnotationPresent(Stateless.class);
    }

    public boolean destroy(Object o) {
        return false;
    }

    public Method getInvocableMethod(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        LinkedList interfaces = new LinkedList();
        if (declaringClass.isAnnotationPresent(Remote.class)) {
            interfaces.addAll(Arrays.asList(declaringClass.getAnnotation(Remote.class).value()));
        }
        if (declaringClass.isAnnotationPresent(Local.class)) {
            interfaces.addAll(Arrays.asList(declaringClass.getAnnotation(Local.class).value()));
        }
        for (Class<?> i : declaringClass.getInterfaces()) {
            if (!i.isAnnotationPresent(Remote.class) && !i.isAnnotationPresent(Local.class)) continue;
            interfaces.add(i);
        }
        for (Class clazz : interfaces) {
            try {
                Method interfaceMethod = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                if (interfaceMethod == null) continue;
                return interfaceMethod;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return method;
    }

    private String getName(Class<?> c) {
        String name;
        if (c.isAnnotationPresent(Singleton.class)) {
            name = c.getAnnotation(Singleton.class).name();
        } else if (c.isAnnotationPresent(Stateful.class)) {
            name = c.getAnnotation(Stateful.class).name();
        } else if (c.isAnnotationPresent(Stateless.class)) {
            name = c.getAnnotation(Stateless.class).name();
        } else {
            return null;
        }
        if (name == null || name.length() == 0) {
            name = c.getSimpleName();
        }
        return name;
    }

    private Object lookup(InitialContext ic, Class<?> c, String name) throws NamingException {
        try {
            return this.lookupSimpleForm(ic, name);
        }
        catch (NamingException ex) {
            LOGGER.log(Level.WARNING, "An instance of EJB class " + c.getName() + " could not be looked up using simple form name. Attempting to look up using the fully-qualified form name.", ex);
            return this.lookupFullyQualfiedForm(ic, c, name);
        }
    }

    private Object lookupSimpleForm(InitialContext ic, String name) throws NamingException {
        String jndiName = "java:module/" + name;
        return ic.lookup(jndiName);
    }

    private Object lookupFullyQualfiedForm(InitialContext ic, Class<?> c, String name) throws NamingException {
        String jndiName = "java:module/" + name + "!" + c.getName();
        return ic.lookup(jndiName);
    }
}

