/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.interceptors;

import com.sun.ejb.containers.interceptors.CallbackInvocationContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.ejb.EJBException;

class CallbackInterceptor {
    protected int index;
    protected Method method;

    CallbackInterceptor(int index, Method method) {
        this.index = index;
        this.method = method;
        try {
            final Method finalM = method;
            if (System.getSecurityManager() == null) {
                if (!finalM.isAccessible()) {
                    finalM.setAccessible(true);
                }
            } else {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        if (!finalM.isAccessible()) {
                            finalM.setAccessible(true);
                        }
                        return null;
                    }
                });
            }
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    Object intercept(final CallbackInvocationContext invContext) throws Throwable {
        try {
            final Object[] interceptors = invContext.getInterceptorInstances();
            if (System.getSecurityManager() != null) {
                return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return CallbackInterceptor.this.method.invoke(interceptors[CallbackInterceptor.this.index], invContext);
                    }
                });
            }
            return this.method.invoke(interceptors[this.index], invContext);
        }
        catch (InvocationTargetException invEx) {
            throw invEx.getCause();
        }
        catch (PrivilegedActionException paEx) {
            Throwable th = paEx.getCause();
            if (th.getCause() != null) {
                throw th.getCause();
            }
            throw th;
        }
    }

    boolean isBeanCallback() {
        return false;
    }

    public String toString() {
        return "callback[" + this.index + "]: " + this.method;
    }
}

