/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgiweb;

import com.sun.faces.spi.AnnotationProvider;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.bean.ManagedBean;
import javax.faces.component.FacesComponent;
import javax.faces.component.behavior.FacesBehavior;
import javax.faces.convert.FacesConverter;
import javax.faces.event.NamedEvent;
import javax.faces.render.FacesBehaviorRenderer;
import javax.faces.render.FacesRenderer;
import javax.faces.validator.FacesValidator;
import javax.servlet.ServletContext;
import org.glassfish.hk2.classmodel.reflect.AnnotatedElement;
import org.glassfish.hk2.classmodel.reflect.AnnotationType;
import org.glassfish.hk2.classmodel.reflect.Member;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.Types;

public class OSGiFacesAnnotationScanner
extends AnnotationProvider {
    private static Logger logger = Logger.getLogger(OSGiFacesAnnotationScanner.class.getPackage().getName());

    public OSGiFacesAnnotationScanner(ServletContext sc) {
        super(sc);
    }

    public Map<Class<? extends Annotation>, Set<Class<?>>> getAnnotatedClasses(Set<URI> uris) {
        Map result = (Map)this.sc.getAttribute("glassfish.osgi.web.facesannotatedclasses");
        this.sc.setAttribute("glassfish.osgi.web.facesannotatedclasses", null);
        if (result == null) {
            logger.warning("Faces annotation parsing has not taken place");
            result = Collections.emptyMap();
        }
        return result;
    }

    static Map<Class<? extends Annotation>, Set<Class<? extends Object>>> scan(Collection<URI> uris, Types types, ClassLoader cl) {
        HashMap<Class<? extends Annotation>, Set<Class<? extends Object>>> result = new HashMap<Class<? extends Annotation>, Set<Class<? extends Object>>>();
        Class<Annotation>[] annotations = OSGiFacesAnnotationScanner.getAnnotationTypes();
        if (annotations == null) {
            return result;
        }
        int total = 0;
        for (Class<Annotation> annotationType : annotations) {
            Type type = types.getBy(annotationType.getName());
            if (!(type instanceof AnnotationType)) continue;
            Collection elements = ((AnnotationType)type).allAnnotatedTypes();
            for (AnnotatedElement element : elements) {
                Object t = element instanceof Member ? ((Member)element).getDeclaringType() : (Type)element;
                if (!t.wasDefinedIn(uris)) continue;
                HashSet classes = (HashSet)result.get(annotationType);
                if (classes == null) {
                    classes = new HashSet();
                    result.put(annotationType, classes);
                }
                try {
                    Class<?> aClass = cl.loadClass(t.getName());
                    logger.info(aClass + " contains " + annotationType);
                    ++total;
                    classes.add(aClass);
                }
                catch (ClassNotFoundException e) {
                    logger.log(Level.WARNING, "Not able to load " + t.getName(), e);
                }
            }
        }
        logger.info("total number of classes with faces annotation = " + total);
        return result;
    }

    private static Class<Annotation>[] getAnnotationTypes() {
        HashSet annotationInstances = new HashSet(8, 1.0f);
        Collections.addAll(annotationInstances, FacesComponent.class, FacesConverter.class, FacesValidator.class, FacesRenderer.class, ManagedBean.class, NamedEvent.class, FacesBehavior.class, FacesBehaviorRenderer.class);
        return annotationInstances.toArray(new Class[0]);
    }
}

