/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.npn;

import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLEngine;
import org.glassfish.grizzly.npn.AlpnClientNegotiator;
import org.glassfish.grizzly.npn.AlpnServerNegotiator;
import org.glassfish.grizzly.npn.ClientSideNegotiator;
import org.glassfish.grizzly.npn.ServerSideNegotiator;

public class NegotiationSupport {
    private static final ConcurrentHashMap<SSLEngine, ServerSideNegotiator> serverSideNegotiators = new ConcurrentHashMap(4);
    private static final ConcurrentHashMap<SSLEngine, ClientSideNegotiator> clientSideNegotiators = new ConcurrentHashMap(4);
    private static final ConcurrentHashMap<SSLEngine, AlpnServerNegotiator> alpnServerNegotiators = new ConcurrentHashMap(4);
    private static final ConcurrentHashMap<SSLEngine, AlpnClientNegotiator> alpnClientNegotiators = new ConcurrentHashMap(4);

    public static void addNegotiator(SSLEngine engine, ServerSideNegotiator serverSideNegotiator) {
        serverSideNegotiators.putIfAbsent(engine, serverSideNegotiator);
    }

    public static void addNegotiator(SSLEngine engine, ClientSideNegotiator clientSideNegotiator) {
        clientSideNegotiators.putIfAbsent(engine, clientSideNegotiator);
    }

    public static void addNegotiator(SSLEngine engine, AlpnServerNegotiator serverSideNegotiator) {
        alpnServerNegotiators.putIfAbsent(engine, serverSideNegotiator);
    }

    public static void addNegotiator(SSLEngine engine, AlpnClientNegotiator clientSideNegotiator) {
        alpnClientNegotiators.putIfAbsent(engine, clientSideNegotiator);
    }

    public static ClientSideNegotiator removeClientNegotiator(SSLEngine engine) {
        return clientSideNegotiators.remove(engine);
    }

    public static AlpnClientNegotiator removeAlpnClientNegotiator(SSLEngine engine) {
        return alpnClientNegotiators.remove(engine);
    }

    public static ServerSideNegotiator removeServerNegotiator(SSLEngine engine) {
        return serverSideNegotiators.remove(engine);
    }

    public static AlpnServerNegotiator removeAlpnServerNegotiator(SSLEngine engine) {
        return alpnServerNegotiators.remove(engine);
    }

    public static ServerSideNegotiator getServerSideNegotiator(SSLEngine engine) {
        return serverSideNegotiators.get(engine);
    }

    public static ClientSideNegotiator getClientSideNegotiator(SSLEngine engine) {
        return clientSideNegotiators.get(engine);
    }

    public static AlpnServerNegotiator getAlpnServerNegotiator(SSLEngine engine) {
        return alpnServerNegotiators.get(engine);
    }

    public static AlpnClientNegotiator getAlpnClientNegotiator(SSLEngine engine) {
        return alpnClientNegotiators.get(engine);
    }
}

