/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.jpa.schemageneration;

import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.logging.LogDomains;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.persistence.common.Java2DBProcessorHelper;
import org.glassfish.persistence.jpa.schemageneration.SchemaGenerationProcessor;

public class EclipseLinkSchemaGenerationProcessor
implements SchemaGenerationProcessor {
    private static final String TOPLINK_PERSISTENCE_PROVIDER_CLASS_NAME_OLD = "oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider";
    private static final String TOPLINK_PERSISTENCE_PROVIDER_CLASS_NAME_NEW = "oracle.toplink.essentials.PersistenceProvider";
    private static final String ECLIPSELINK_PERSISTENCE_PROVIDER_CLASS_NAME = "org.eclipse.persistence.jpa.PersistenceProvider";
    private static final String CREATE_ONLY = "create-tables";
    private static final String DROP_AND_CREATE = "drop-and-create-tables";
    private static final String NONE = "none";
    private static final String DDL_BOTH_GENERATION = "both";
    private static final String DDL_DATABASE_GENERATION = "database";
    private static final String DDL_SQL_SCRIPT_GENERATION = "sql-script";
    private static final String TOPLINK_DDL_GENERATION = "toplink.ddl-generation";
    private static final String ECLIPSELINK_DDL_GENERATION = "eclipselink.ddl-generation";
    private static final String TOPLINK_DDL_GENERATION_OUTPUT_MODE = "toplink.ddl-generation.output-mode";
    private static final String ECLIPSELINK_DDL_GENERATION_OUTPUT_MODE = "eclipselink.ddl-generation.output-mode";
    private static final String TOPLINK_APP_LOCATION = "toplink.application-location";
    private static final String ECLIPSELINK_APP_LOCATION = "eclipselink.application-location";
    private static final String TOPLINK_CREATE_JDBC_DDL_FILE = "toplink.create-ddl-jdbc-file-name";
    private static final String ECLIPSELINK_CREATE_JDBC_DDL_FILE = "eclipselink.create-ddl-jdbc-file-name";
    private static final String TOPLINK_DROP_JDBC_DDL_FILE = "toplink.drop-ddl-jdbc-file-name";
    private static final String ECLIPSELINK_DROP_JDBC_DDL_FILE = "eclipselink.drop-ddl-jdbc-file-name";
    private static Logger logger = LogDomains.getLogger(EclipseLinkSchemaGenerationProcessor.class, (String)"javax.org.glassfish.persistence");
    private ProviderPropertyNamesHolder providerPropertyNamesHolder;
    private Java2DBProcessorHelper helper;
    private Map<String, Object> overrides;
    private boolean isSchemaGenerationPU;

    public EclipseLinkSchemaGenerationProcessor(String persistenceProviderClassName) {
        this.initializeProviderPropertyHolder(persistenceProviderClassName);
    }

    @Override
    public void init(PersistenceUnitDescriptor pud, DeploymentContext context) {
        boolean userDropTables;
        this.helper = new Java2DBProcessorHelper(context);
        this.helper.init();
        String ddlGenerate = this.getPersistencePropVal(pud, this.providerPropertyNamesHolder.ddlGeneration, NONE);
        String ddlMode = this.getPersistencePropVal(pud, this.providerPropertyNamesHolder.ddlGenerationOutputMode, DDL_BOTH_GENERATION);
        boolean userCreateTables = (ddlGenerate.equals(CREATE_ONLY) || ddlGenerate.equals(DROP_AND_CREATE)) && !ddlMode.equals(NONE);
        boolean createTables = this.helper.getCreateTables(userCreateTables);
        boolean bl = userDropTables = ddlGenerate.equals(DROP_AND_CREATE) && (ddlMode.equals(DDL_DATABASE_GENERATION) || ddlMode.equals(DDL_BOTH_GENERATION));
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Processing request with create tables: " + createTables + ", drop tables: " + userDropTables);
        }
        if (createTables || userDropTables) {
            this.helper.setProcessorType("JPA", pud.getName());
            this.helper.setDropTablesValue(userDropTables, pud.getName());
            this.helper.setCreateTablesValue(userCreateTables && !ddlMode.equals(DDL_SQL_SCRIPT_GENERATION), pud.getName());
            String dataSourceName = PersistenceUnitTransactionType.JTA == PersistenceUnitTransactionType.valueOf((String)pud.getTransactionType()) ? pud.getJtaDataSource() : pud.getNonJtaDataSource();
            this.helper.setJndiName(dataSourceName, pud.getName());
            this.constructJdbcFileNames(pud);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Processing request to create files - create file: " + this.helper.getCreateJdbcFileName(pud.getName()) + ", drop  file: " + this.helper.getDropJdbcFileName(pud.getName()));
            }
            this.overrides = new HashMap<String, Object>();
            this.addSchemaGenerationPropertiesToOverrides(pud, this.overrides);
            this.isSchemaGenerationPU = true;
        }
    }

    @Override
    public Map<String, Object> getOverridesForSchemaGeneration() {
        return this.overrides;
    }

    @Override
    public Map<String, Object> getOverridesForSuppressingSchemaGeneration() {
        HashMap<String, Object> overridesForSuppressingSchemaGeneration = new HashMap<String, Object>();
        overridesForSuppressingSchemaGeneration.put(this.providerPropertyNamesHolder.ddlGenerationOutputMode, NONE);
        return overridesForSuppressingSchemaGeneration;
    }

    @Override
    public boolean isContainerDDLExecutionRequired() {
        return this.isSchemaGenerationPU;
    }

    private void initializeProviderPropertyHolder(String providerClassName) {
        this.providerPropertyNamesHolder = new ProviderPropertyNamesHolder();
        if (TOPLINK_PERSISTENCE_PROVIDER_CLASS_NAME_NEW.equals(providerClassName) || TOPLINK_PERSISTENCE_PROVIDER_CLASS_NAME_OLD.equals(providerClassName)) {
            this.providerPropertyNamesHolder.appLocation = TOPLINK_APP_LOCATION;
            this.providerPropertyNamesHolder.createJdbcDdlFile = TOPLINK_CREATE_JDBC_DDL_FILE;
            this.providerPropertyNamesHolder.dropJdbcDdlFile = TOPLINK_DROP_JDBC_DDL_FILE;
            this.providerPropertyNamesHolder.ddlGeneration = TOPLINK_DDL_GENERATION;
            this.providerPropertyNamesHolder.ddlGenerationOutputMode = TOPLINK_DDL_GENERATION_OUTPUT_MODE;
        }
    }

    private void constructJdbcFileNames(PersistenceUnitDescriptor parBundle) {
        String createJdbcFileName = this.getPersistencePropVal(parBundle, this.providerPropertyNamesHolder.createJdbcDdlFile, null);
        String dropJdbcFileName = this.getPersistencePropVal(parBundle, this.providerPropertyNamesHolder.dropJdbcDdlFile, null);
        if (null != createJdbcFileName && null != dropJdbcFileName) {
            return;
        }
        String filePrefix = Java2DBProcessorHelper.getDDLNamePrefix((Object)parBundle.getParent().getParent());
        if (null == createJdbcFileName) {
            createJdbcFileName = filePrefix + '_' + parBundle.getName() + "_createDDL.jdbc";
        }
        if (null == dropJdbcFileName) {
            dropJdbcFileName = filePrefix + '_' + parBundle.getName() + "_dropDDL.jdbc";
        }
        this.helper.setCreateJdbcFileName(createJdbcFileName, parBundle.getName());
        this.helper.setDropJdbcFileName(dropJdbcFileName, parBundle.getName());
    }

    @Override
    public void executeCreateDDL() {
        this.helper.createOrDropTablesInDB(true, "JPA");
    }

    private void addSchemaGenerationPropertiesToOverrides(PersistenceUnitDescriptor puDescriptor, Map<String, Object> overrides) {
        EclipseLinkSchemaGenerationProcessor.addPropertyToOverride(puDescriptor, overrides, this.providerPropertyNamesHolder.appLocation, this.helper.getGeneratedLocation(puDescriptor.getName()));
        EclipseLinkSchemaGenerationProcessor.addPropertyToOverride(puDescriptor, overrides, this.providerPropertyNamesHolder.createJdbcDdlFile, this.helper.getCreateJdbcFileName(puDescriptor.getName()));
        EclipseLinkSchemaGenerationProcessor.addPropertyToOverride(puDescriptor, overrides, this.providerPropertyNamesHolder.dropJdbcDdlFile, this.helper.getDropJdbcFileName(puDescriptor.getName()));
        EclipseLinkSchemaGenerationProcessor.addPropertyToOverride(puDescriptor, overrides, this.providerPropertyNamesHolder.ddlGeneration, DROP_AND_CREATE);
        EclipseLinkSchemaGenerationProcessor.addPropertyToOverride(puDescriptor, overrides, this.providerPropertyNamesHolder.ddlGenerationOutputMode, DDL_SQL_SCRIPT_GENERATION);
    }

    private static void addPropertyToOverride(PersistenceUnitDescriptor descriptor, Map<String, Object> overrides, String propertyName, String propertyValue) {
        String oldPropertyValue = descriptor.getProperties().getProperty(propertyName);
        if (null == oldPropertyValue) {
            overrides.put(propertyName, propertyValue);
        }
    }

    private String getPersistencePropVal(PersistenceUnitDescriptor parBundle, String propertyName, String defaultValue) {
        return parBundle.getProperties().getProperty(propertyName, defaultValue);
    }

    public static boolean isSupportedPersistenceProvider(String providerClassName) {
        return providerClassName.equals(TOPLINK_PERSISTENCE_PROVIDER_CLASS_NAME_OLD) || providerClassName.equals(TOPLINK_PERSISTENCE_PROVIDER_CLASS_NAME_NEW) || providerClassName.equals(ECLIPSELINK_PERSISTENCE_PROVIDER_CLASS_NAME);
    }

    private static class ProviderPropertyNamesHolder {
        String appLocation = "eclipselink.application-location";
        String createJdbcDdlFile = "eclipselink.create-ddl-jdbc-file-name";
        String dropJdbcDdlFile = "eclipselink.drop-ddl-jdbc-file-name";
        String ddlGeneration = "eclipselink.ddl-generation";
        String ddlGenerationOutputMode = "eclipselink.ddl-generation.output-mode";

        private ProviderPropertyNamesHolder() {
        }
    }
}

