/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.utilities.general;

import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Hk2ThreadLocal<T> {
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock wLock = this.readWriteLock.writeLock();
    private final ReentrantReadWriteLock.ReadLock rLock = this.readWriteLock.readLock();
    private final WeakHashMap<Thread, T> locals = new WeakHashMap();

    protected T initialValue() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        Thread id = Thread.currentThread();
        this.rLock.lock();
        try {
            if (this.locals.containsKey(id)) {
                T t = this.locals.get(id);
                return t;
            }
        }
        finally {
            this.rLock.unlock();
        }
        this.wLock.lock();
        try {
            if (this.locals.containsKey(id)) {
                T t = this.locals.get(id);
                return t;
            }
            T initialValue = this.initialValue();
            this.locals.put(id, initialValue);
            T t = initialValue;
            return t;
        }
        finally {
            this.wLock.unlock();
        }
    }

    public void set(T value) {
        Thread id = Thread.currentThread();
        this.wLock.lock();
        try {
            this.locals.put(id, value);
        }
        finally {
            this.wLock.unlock();
        }
    }

    public void remove() {
        Thread id = Thread.currentThread();
        this.wLock.lock();
        try {
            this.locals.remove(id);
        }
        finally {
            this.wLock.unlock();
        }
    }

    public void removeAll() {
        this.wLock.lock();
        try {
            this.locals.clear();
        }
        finally {
            this.wLock.unlock();
        }
    }

    public int getSize() {
        this.rLock.lock();
        try {
            int n = this.locals.size();
            return n;
        }
        finally {
            this.rLock.unlock();
        }
    }
}

