/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.cli;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.RealmsManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.admin.rest.cli.SupportsUserManagementCommand;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service(name="__synchronize-realm-from-config")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG, CommandTarget.CLUSTERED_INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=Config.class, opType=RestEndpoint.OpType.POST, path="synchronize-realm-from-config", params={@RestParam(name="target", value="$parent")})})
public class SynchronizeRealmFromConfig
implements AdminCommand {
    @Inject
    Domain domain;
    @Param
    String realmName;
    @Param(name="target", primary=true, optional=true, defaultValue="server")
    private String target;
    @Inject
    @Named(value="default-instance-name")
    private Config config;
    @Inject
    private Configs configs;
    @Inject
    RealmsManager realmsManager;
    private static final LocalStringManagerImpl _localStrings = new LocalStringManagerImpl(SupportsUserManagementCommand.class);

    public void execute(AdminCommandContext context) {
        Config realConfig = null;
        try {
            realConfig = this.configs.getConfigByName(this.target);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (realConfig == null) {
            Cluster cluster;
            Server targetServer = this.domain.getServerNamed(this.target);
            if (targetServer != null) {
                realConfig = this.domain.getConfigNamed(targetServer.getConfigRef());
            }
            if ((cluster = this.domain.getClusterNamed(this.target)) != null) {
                realConfig = this.domain.getConfigNamed(cluster.getConfigRef());
            }
        }
        ActionReport report = context.getActionReport();
        try {
            if (realConfig.getName().equals(this.config.getName())) {
                this.setRestartRequired(report);
                return;
            }
            Realm r = this.realmsManager.getFromLoadedRealms(realConfig.getName(), this.realmName);
            if (r == null) {
                report.setMessage(_localStrings.getLocalString("REALM_SYNCH_SUCCESSFUL", "Synchronization of Realm {0} from Configuration Successful.", new Object[]{this.realmName}));
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                return;
            }
            this.realmsManager.removeFromLoadedRealms(realConfig.getName(), this.realmName);
            boolean done = this.instantiateRealm(realConfig, this.realmName);
            if (done) {
                report.setMessage(_localStrings.getLocalString("REALM_SYNCH_SUCCESSFUL", "Synchronization of Realm {0} from Configuration Successful.", new Object[]{this.realmName}));
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                return;
            }
        }
        catch (BadRealmException ex) {
            report.setFailureCause((Throwable)ex);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        catch (NoSuchRealmException ex) {
            report.setFailureCause((Throwable)ex);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        catch (Exception ex) {
            report.setFailureCause((Throwable)ex);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    private void setRestartRequired(ActionReport report) {
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        ActionReport.MessagePart mp = report.getTopMessagePart();
        Properties extraProperties = new Properties();
        HashMap<String, String> entity = new HashMap<String, String>();
        mp.setMessage(_localStrings.getLocalString("RESTART_REQUIRED", "Restart required for configuration updates to active server realm: {0}.", new Object[]{this.realmName}));
        entity.put("restartRequired", "true");
        extraProperties.put("entity", entity);
        report.setExtraProperties(extraProperties);
    }

    private boolean instantiateRealm(Config cfg, String realmName) throws BadRealmException, NoSuchRealmException {
        List authRealmConfigs = cfg.getSecurityService().getAuthRealm();
        for (AuthRealm authRealm : authRealmConfigs) {
            if (!realmName.equals(authRealm.getName())) continue;
            List propConfigs = authRealm.getProperty();
            Properties props = new Properties();
            for (Property p : propConfigs) {
                String value = p.getValue();
                props.setProperty(p.getName(), value);
            }
            Realm.instantiate((String)authRealm.getName(), (String)authRealm.getClassname(), (Properties)props, (String)cfg.getName());
            return true;
        }
        throw new NoSuchRealmException(_localStrings.getLocalString("NO_SUCH_REALM", "No Such Realm: {0}", new Object[]{realmName}));
    }
}

