/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.felix.scr.impl.helper.Logger;
import org.apache.felix.scr.impl.metadata.DSVersion;
import org.apache.felix.scr.impl.metadata.PropertyMetadata;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;
import org.apache.felix.scr.impl.metadata.ServiceMetadata;
import org.apache.felix.scr.impl.metadata.TargetedPID;
import org.osgi.service.component.ComponentException;

public class ComponentMetadata {
    public static final String CONFIGURATION_POLICY_REQUIRE = "require";
    public static final String CONFIGURATION_POLICY_IGNORE = "ignore";
    public static final String CONFIGURATION_POLICY_OPTIONAL = "optional";
    private static final Set<String> CONFIGURATION_POLICY_VALID;
    private static final String IMPLEMENTATION_CLASS_DUPLICATE = "icd";
    private static final ServiceMetadata SERVICE_DUPLICATE;
    private final DSVersion m_dsVersion;
    private String m_name;
    private boolean m_enabled = true;
    private String m_factory = null;
    private Boolean m_immediate = null;
    private String m_implementationClassName = null;
    private String m_activate = null;
    private boolean m_activateDeclared = false;
    private String m_deactivate = null;
    private boolean m_deactivateDeclared = false;
    private String m_modified = null;
    private String m_configurationPolicy = null;
    private List<String> m_configurationPid;
    private Map<String, Object> m_properties = new HashMap<String, Object>();
    private List<PropertyMetadata> m_propertyMetaData = new ArrayList<PropertyMetadata>();
    private ServiceMetadata m_service = null;
    private List<ReferenceMetadata> m_references = new ArrayList<ReferenceMetadata>();
    private boolean m_configurableServiceProperties;
    private boolean m_persistentFactoryComponent;
    private boolean m_deleteCallsModify;
    private Boolean m_obsoleteFactoryComponentFactory;
    private boolean m_configureWithInterfaces;
    private boolean m_delayedKeepInstances;
    private boolean m_validated = false;

    public ComponentMetadata(DSVersion dsVersion) {
        this.m_dsVersion = dsVersion;
    }

    public void setConfigurationPid(String[] configurationPid) {
        if (this.m_validated) {
            return;
        }
        this.m_configurationPid = new ArrayList<String>(Arrays.asList(configurationPid));
    }

    public void setName(String name) {
        if (this.m_validated) {
            return;
        }
        this.m_name = name;
    }

    public void setEnabled(boolean enabled) {
        if (this.m_validated) {
            return;
        }
        this.m_enabled = enabled;
    }

    public void setFactoryIdentifier(String factoryIdentifier) {
        if (this.m_validated) {
            return;
        }
        this.m_factory = factoryIdentifier;
    }

    public void setImmediate(boolean immediate) {
        if (this.m_validated) {
            return;
        }
        this.m_immediate = immediate ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setImplementationClassName(String implementationClassName) {
        if (this.m_validated) {
            return;
        }
        this.m_implementationClassName = this.m_implementationClassName != null ? IMPLEMENTATION_CLASS_DUPLICATE : implementationClassName;
    }

    public void setConfigurationPolicy(String configurationPolicy) {
        if (this.m_validated) {
            return;
        }
        this.m_configurationPolicy = configurationPolicy;
    }

    public void setActivate(String activate) {
        if (this.m_validated) {
            return;
        }
        this.m_activate = activate;
        this.m_activateDeclared = true;
    }

    public void setDeactivate(String deactivate) {
        if (this.m_validated) {
            return;
        }
        this.m_deactivate = deactivate;
        this.m_deactivateDeclared = true;
    }

    public void setModified(String modified) {
        if (this.m_validated) {
            return;
        }
        this.m_modified = modified;
    }

    public void addProperty(PropertyMetadata newProperty) {
        if (this.m_validated) {
            return;
        }
        if (newProperty == null) {
            throw new IllegalArgumentException("Cannot add a null property");
        }
        this.m_propertyMetaData.add(newProperty);
    }

    public void setService(ServiceMetadata service) {
        if (this.m_validated) {
            return;
        }
        this.m_service = this.m_service != null ? SERVICE_DUPLICATE : service;
    }

    public void addDependency(ReferenceMetadata newReference) {
        if (this.m_validated) {
            return;
        }
        if (newReference == null) {
            throw new IllegalArgumentException("Cannot add a null ReferenceMetadata");
        }
        this.m_references.add(newReference);
    }

    public void setConfigurableServiceProperties(boolean configurableServiceProperties) {
        if (this.m_validated) {
            return;
        }
        this.m_configurableServiceProperties = configurableServiceProperties;
    }

    public void setPersistentFactoryComponent(boolean persistentFactoryComponent) {
        if (this.m_validated) {
            return;
        }
        this.m_persistentFactoryComponent = persistentFactoryComponent;
    }

    public void setDeleteCallsModify(boolean deleteCallsModify) {
        if (this.m_validated) {
            return;
        }
        this.m_deleteCallsModify = deleteCallsModify;
    }

    public void setObsoleteFactoryComponentFactory(boolean obsoleteFactoryComponentFactory) {
        if (this.m_validated) {
            return;
        }
        this.m_obsoleteFactoryComponentFactory = obsoleteFactoryComponentFactory;
    }

    public void setConfigureWithInterfaces(boolean configureWithInterfaces) {
        this.m_configureWithInterfaces = configureWithInterfaces;
    }

    public void setDelayedKeepInstances(boolean delayedKeepInstances) {
        if (this.m_validated) {
            return;
        }
        this.m_delayedKeepInstances = delayedKeepInstances;
    }

    public DSVersion getDSVersion() {
        return this.m_dsVersion;
    }

    public String getName() {
        if (this.m_name != null) {
            return this.m_name;
        }
        return this.getImplementationClassName();
    }

    public List<String> getConfigurationPid() {
        if (!this.m_validated) {
            throw new IllegalStateException("not yet validated");
        }
        return this.m_configurationPid;
    }

    public int getPidIndex(TargetedPID pid) {
        if (!this.m_validated) {
            throw new IllegalStateException("not yet validated");
        }
        if (this.m_configurationPid == null) {
            throw new IllegalStateException("Apparently trying to configure a component " + this.m_name + " without a configurationPid using " + pid);
        }
        return this.m_configurationPid.indexOf(pid.getServicePid());
    }

    public boolean isConfigurationPidDeclared() {
        return this.m_configurationPid != null;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public String getFactoryIdentifier() {
        return this.m_factory;
    }

    public boolean isImmediate() {
        if (this.m_immediate != null) {
            return this.m_immediate;
        }
        return this.m_service == null && this.m_factory == null;
    }

    public String getImplementationClassName() {
        return this.m_implementationClassName;
    }

    public String getConfigurationPolicy() {
        return this.m_configurationPolicy;
    }

    public String getActivate() {
        return this.m_activate;
    }

    public boolean isActivateDeclared() {
        return this.m_activateDeclared;
    }

    public String getDeactivate() {
        return this.m_deactivate;
    }

    public boolean isDeactivateDeclared() {
        return this.m_deactivateDeclared;
    }

    public String getModified() {
        return this.m_modified;
    }

    public ServiceMetadata getServiceMetadata() {
        return this.m_service;
    }

    public ServiceMetadata.Scope getServiceScope() {
        if (this.m_service == null) {
            return ServiceMetadata.Scope.singleton;
        }
        return this.m_service.getScope();
    }

    public Map<String, Object> getProperties() {
        return this.m_properties;
    }

    List<PropertyMetadata> getPropertyMetaData() {
        return this.m_propertyMetaData;
    }

    public List<ReferenceMetadata> getDependencies() {
        return this.m_references;
    }

    public boolean isFactory() {
        return this.m_factory != null;
    }

    public boolean isConfigurationRequired() {
        return CONFIGURATION_POLICY_REQUIRE.equals(this.m_configurationPolicy);
    }

    public boolean isConfigurationIgnored() {
        return CONFIGURATION_POLICY_IGNORE.equals(this.m_configurationPolicy);
    }

    public boolean isConfigurationOptional() {
        return CONFIGURATION_POLICY_OPTIONAL.equals(this.m_configurationPolicy);
    }

    public boolean isConfigurableServiceProperties() {
        return this.m_configurableServiceProperties;
    }

    public boolean isPersistentFactoryComponent() {
        return this.m_persistentFactoryComponent;
    }

    public boolean isDeleteCallsModify() {
        return this.m_deleteCallsModify;
    }

    public boolean isObsoleteFactoryComponentFactory() {
        return this.m_obsoleteFactoryComponentFactory == null ? false : this.m_obsoleteFactoryComponentFactory;
    }

    public boolean isConfigureWithInterfaces() {
        return this.m_configureWithInterfaces;
    }

    public boolean isDelayedKeepInstances() {
        return this.m_delayedKeepInstances;
    }

    public void validate(Logger logger) {
        if (this.m_validated) {
            return;
        }
        if (this.m_name == null) {
            if (!this.m_dsVersion.isDS11()) {
                throw new ComponentException("The component name has not been set");
            }
            this.setName(this.getImplementationClassName());
        }
        if (this.m_implementationClassName == null) {
            throw this.validationFailure("Implementation class name missing");
        }
        if (this.m_implementationClassName == IMPLEMENTATION_CLASS_DUPLICATE) {
            throw this.validationFailure("Implementation element must occur exactly once");
        }
        if (this.m_configurationPolicy == null) {
            this.m_configurationPolicy = CONFIGURATION_POLICY_OPTIONAL;
        } else {
            if (!this.m_dsVersion.isDS11()) {
                throw this.validationFailure("configuration-policy declaration requires DS 1.1 or later namespace ");
            }
            if (!CONFIGURATION_POLICY_VALID.contains(this.m_configurationPolicy)) {
                throw this.validationFailure("configuration-policy must be one of " + CONFIGURATION_POLICY_VALID);
            }
        }
        if (this.m_activate == null) {
            this.m_activate = "activate";
        } else if (!this.m_dsVersion.isDS11()) {
            throw this.validationFailure("activate method declaration requires DS 1.1 or later namespace ");
        }
        if (this.m_deactivate == null) {
            this.m_deactivate = "deactivate";
        } else if (!this.m_dsVersion.isDS11()) {
            throw this.validationFailure("deactivate method declaration requires DS 1.1 or later namespace ");
        }
        if (this.m_modified != null && !this.m_dsVersion.isDS11()) {
            throw this.validationFailure("modified method declaration requires DS 1.1 or later namespace ");
        }
        if (this.m_configurationPid == null) {
            this.m_configurationPid = Collections.singletonList(this.getName());
        } else {
            if (!this.m_dsVersion.isDS12()) {
                throw this.validationFailure("configuration-pid attribute requires DS 1.2 or later namespace ");
            }
            if (this.m_configurationPid.isEmpty()) {
                throw this.validationFailure("configuration-pid nust not be empty string ");
            }
            if (this.m_configurationPid.size() > 1 && !this.m_dsVersion.isDS13()) {
                throw this.validationFailure("multiple configuration-pid requires DS 1.3 or later namespace ");
            }
            for (int i = 0; i < this.m_configurationPid.size(); ++i) {
                if (!"$".equals(this.m_configurationPid.get(i))) continue;
                if (!this.m_dsVersion.isDS13()) {
                    throw this.validationFailure("Use of '$' configuration-pid wildcard requires DS 1.3 or later namespace ");
                }
                this.m_configurationPid.set(i, this.getName());
            }
            if (new HashSet<String>(this.m_configurationPid).size() != this.m_configurationPid.size()) {
                throw this.validationFailure("Duplicate pids not allowed: " + this.m_configurationPid);
            }
        }
        for (PropertyMetadata propMeta : this.m_propertyMetaData) {
            propMeta.validate(this);
            this.m_properties.put(propMeta.getName(), propMeta.getValue());
        }
        this.m_propertyMetaData.clear();
        if (this.m_service == SERVICE_DUPLICATE) {
            throw this.validationFailure("Service element must occur at most once");
        }
        if (this.m_service != null) {
            this.m_service.validate(this);
        }
        HashSet<String> refs = new HashSet<String>();
        for (ReferenceMetadata refMeta : this.m_references) {
            refMeta.validate(this, logger);
            if (refs.add(refMeta.getName())) continue;
            throw this.validationFailure("Detected duplicate reference name: ''" + refMeta.getName() + "''");
        }
        if (this.m_immediate != null) {
            if (this.isImmediate()) {
                if (this.isFactory()) {
                    throw this.validationFailure("Factory cannot be immediate");
                }
            } else if (this.m_service == null && !this.isFactory()) {
                throw this.validationFailure("Delayed must provide a service or be a factory");
            }
        }
        if (this.m_service != null && this.m_service.getScope() != ServiceMetadata.Scope.singleton && (this.isFactory() || this.isImmediate())) {
            throw this.validationFailure("factory or immediate must be scope singleton not " + (Object)((Object)this.m_service.getScope()));
        }
        if (this.m_dsVersion == DSVersion.DS12Felix) {
            this.m_configurableServiceProperties = true;
        }
        if (this.m_configurableServiceProperties && this.getServiceScope() != ServiceMetadata.Scope.singleton) {
            throw this.validationFailure("configurable service properties only allowed with singleton scope");
        }
        if (this.m_dsVersion.isDS13()) {
            this.m_deleteCallsModify = true;
        }
        if (!this.m_dsVersion.isDS13() && this.m_configureWithInterfaces) {
            throw this.validationFailure("Configuration with interfaces or annotations only possible with version 1.3 or later");
        }
        if (this.m_dsVersion.isDS13() && this.m_obsoleteFactoryComponentFactory != null) {
            throw this.validationFailure("Configuration of component factory instances through config admin factory pids supported only through the 1.2 namespace");
        }
        if (this.m_persistentFactoryComponent && !this.isFactory()) {
            throw this.validationFailure("Only a factory component can be a persistent factory component");
        }
        this.m_validated = true;
    }

    ComponentException validationFailure(String reason) {
        return new ComponentException("Component " + this.getName() + " validation failed: " + reason);
    }

    static {
        SERVICE_DUPLICATE = new ServiceMetadata();
        CONFIGURATION_POLICY_VALID = new TreeSet<String>();
        CONFIGURATION_POLICY_VALID.add(CONFIGURATION_POLICY_IGNORE);
        CONFIGURATION_POLICY_VALID.add(CONFIGURATION_POLICY_OPTIONAL);
        CONFIGURATION_POLICY_VALID.add(CONFIGURATION_POLICY_REQUIRE);
    }
}

