/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.portable;

import com.sun.ejb.portable.HomeHandleImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.HomeHandle;
import javax.rmi.PortableRemoteObject;

public final class EJBMetaDataImpl
implements EJBMetaData,
Serializable {
    private static final long serialVersionUID = 5777657175353026918L;
    private Class keyClass;
    private Class homeClass;
    private Class remoteClass;
    private boolean isSessionBean;
    private boolean isStatelessSessionBean;
    private HomeHandle homeHandle;
    private transient EJBHome ejbHomeStub;

    public EJBMetaDataImpl(EJBHome ejbHomeStub, Class homeClass, Class remoteClass, Class keyClass) {
        this(ejbHomeStub, homeClass, remoteClass, keyClass, false, false);
    }

    public EJBMetaDataImpl(EJBHome ejbHomeStub, Class homeClass, Class remoteClass, boolean isSessionBean, boolean isStatelessSessionBean) {
        this(ejbHomeStub, homeClass, remoteClass, null, isSessionBean, isStatelessSessionBean);
    }

    public EJBMetaDataImpl(EJBHome ejbHomeStub, Class homeClass, Class remoteClass, Class keyClass, boolean isSessionBean, boolean isStatelessSessionBean) {
        this.ejbHomeStub = ejbHomeStub;
        this.homeHandle = new HomeHandleImpl(ejbHomeStub);
        this.keyClass = keyClass;
        this.homeClass = homeClass;
        this.remoteClass = remoteClass;
        this.isSessionBean = isSessionBean;
        this.isStatelessSessionBean = isStatelessSessionBean;
    }

    public Class getHomeInterfaceClass() {
        return this.homeClass;
    }

    public Class getRemoteInterfaceClass() {
        return this.remoteClass;
    }

    public EJBHome getEJBHome() {
        return this.ejbHomeStub;
    }

    public Class getPrimaryKeyClass() {
        if (this.keyClass == null) {
            throw new RuntimeException("SessionBeans do not have a primary key");
        }
        return this.keyClass;
    }

    public boolean isSession() {
        return this.isSessionBean;
    }

    public boolean isStatelessSession() {
        return this.isStatelessSessionBean;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.isSessionBean = in.readBoolean();
        this.isStatelessSessionBean = in.readBoolean();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        this.remoteClass = loader.loadClass(in.readUTF());
        this.homeClass = loader.loadClass(in.readUTF());
        if (!this.isSessionBean) {
            this.keyClass = loader.loadClass(in.readUTF());
        }
        this.homeHandle = (HomeHandle)in.readObject();
        this.ejbHomeStub = this.homeHandle.getEJBHome();
        this.ejbHomeStub = (EJBHome)PortableRemoteObject.narrow((Object)this.ejbHomeStub, (Class)this.homeClass);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeBoolean(this.isSessionBean);
        out.writeBoolean(this.isStatelessSessionBean);
        out.writeUTF(this.remoteClass.getName());
        out.writeUTF(this.homeClass.getName());
        if (!this.isSessionBean) {
            out.writeUTF(this.keyClass.getName());
        }
        out.writeObject(this.homeHandle);
    }
}

