/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.cdi.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import javax.validation.Constraint;
import javax.validation.Valid;
import javax.validation.executable.ValidateOnExecution;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.classhierarchy.ClassHierarchyHelper;
import org.hibernate.validator.internal.util.classhierarchy.Filter;

public class ValidateableBeanFilter
implements Predicate<Class<?>> {
    private static final Set<Class<? extends Annotation>> MATCHING_ANNOTATIONS = Collections.unmodifiableSet(CollectionHelper.asSet((Object[])new Class[]{Valid.class, Constraint.class, ValidateOnExecution.class}));

    @Override
    public boolean test(Class<?> type) {
        for (Class clazz : ClassHierarchyHelper.getHierarchy(type, (Filter[])new Filter[0])) {
            if (!this.hasMatchingAnnotation(clazz)) continue;
            return true;
        }
        return false;
    }

    private boolean hasMatchingAnnotation(Class<?> clazz) {
        HashSet<Annotation> processedAnnotations = new HashSet<Annotation>();
        if (this.containsMatchingAnnotation(clazz.getDeclaredAnnotations(), processedAnnotations)) {
            return true;
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (this.hasMatchingAnnotation(field.getAnnotatedType(), processedAnnotations)) {
                return true;
            }
            if (!this.containsMatchingAnnotation(field.getDeclaredAnnotations(), processedAnnotations)) continue;
            return true;
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredConstructors()) {
            if (!this.hasMatchingAnnotation((Executable)accessibleObject, processedAnnotations)) continue;
            return true;
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            if (!this.hasMatchingAnnotation((Executable)accessibleObject, processedAnnotations)) continue;
            return true;
        }
        return false;
    }

    private boolean containsMatchingAnnotation(Annotation[] annotations, Set<Annotation> processedAnnotations) {
        for (Annotation annotation : annotations) {
            if (!this.isMatchingAnnotation(annotation, processedAnnotations)) continue;
            return true;
        }
        return false;
    }

    private boolean hasMatchingAnnotation(AnnotatedType annotatedType, Set<Annotation> processedAnnotations) {
        if (this.containsMatchingAnnotation(annotatedType.getDeclaredAnnotations(), processedAnnotations)) {
            return true;
        }
        if (annotatedType instanceof AnnotatedParameterizedType) {
            for (AnnotatedType type : ((AnnotatedParameterizedType)annotatedType).getAnnotatedActualTypeArguments()) {
                if (!this.hasMatchingAnnotation(type, processedAnnotations)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasMatchingAnnotation(Executable executable, Set<Annotation> processedAnnotations) {
        if (this.containsMatchingAnnotation(executable.getDeclaredAnnotations(), processedAnnotations)) {
            return true;
        }
        if (this.hasMatchingAnnotation(executable.getAnnotatedReturnType(), processedAnnotations)) {
            return true;
        }
        for (AnnotatedType annotatedType : executable.getAnnotatedParameterTypes()) {
            if (!this.hasMatchingAnnotation(annotatedType, processedAnnotations)) continue;
            return true;
        }
        for (AnnotatedType annotatedType : executable.getParameterAnnotations()) {
            if (!this.containsMatchingAnnotation((Annotation[])annotatedType, processedAnnotations)) continue;
            return true;
        }
        return false;
    }

    private boolean isMatchingAnnotation(Annotation annotationToCheck, Set<Annotation> processedAnnotations) {
        if (!processedAnnotations.add(annotationToCheck)) {
            return false;
        }
        Class<? extends Annotation> annotationType = annotationToCheck.annotationType();
        if (MATCHING_ANNOTATIONS.contains(annotationType)) {
            return true;
        }
        for (Annotation annotation : annotationType.getDeclaredAnnotations()) {
            if (!this.isMatchingAnnotation(annotation, processedAnnotations)) continue;
            return true;
        }
        return false;
    }
}

