/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.math.BigDecimal;
import javax.json.stream.JsonGenerator;
import org.eclipse.yasson.internal.model.customization.Customization;
import org.eclipse.yasson.internal.serializer.AbstractNumberSerializer;
import org.eclipse.yasson.internal.serializer.BigNumberUtil;

public class BigDecimalTypeSerializer
extends AbstractNumberSerializer<BigDecimal> {
    public BigDecimalTypeSerializer(Customization customization) {
        super(customization);
    }

    @Override
    protected void serializeNonFormatted(BigDecimal obj, JsonGenerator generator, String key) {
        if (BigNumberUtil.isIEEE754(obj)) {
            generator.write(key, obj);
        } else {
            generator.write(key, obj.toString());
        }
    }

    @Override
    protected void serializeNonFormatted(BigDecimal obj, JsonGenerator generator) {
        if (BigNumberUtil.isIEEE754(obj)) {
            generator.write(obj);
        } else {
            generator.write(obj.toString());
        }
    }
}

