package org.apache.jsp;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import com.sun.ts.tests.jsp.common.util.JspTestUtil;
import java.io.IOException;

public final class JspWriterTest_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {


    private static final String APPLICATIONCTX_ATTR =
        "com.sun.ts.tests.jsp.api.applicationContext";


    public void jspWriterNewLineTest(HttpServletRequest req,
                                     HttpServletResponse res,
                                     JspWriter out)
    throws ServletException, IOException {
        out.print("new line");
        out.newLine();
    }


    public void jspWriterPrintBooleanTest(HttpServletRequest req,
                                          HttpServletResponse res,
                                          JspWriter out)
    throws ServletException, IOException {
        out.print(true);
        out.print(false);
    }


    public void jspWriterPrintCharTest(HttpServletRequest req,
                                       HttpServletResponse res,
                                       JspWriter out)
    throws ServletException, IOException {
        out.print('c');
        out.print('b');
    }


    public void jspWriterPrintIntTest(HttpServletRequest req,
                                      HttpServletResponse res,
                                      JspWriter out)
    throws ServletException, IOException {
        out.print(Integer.MIN_VALUE);
        out.print(Integer.MAX_VALUE);
    }


    public void jspWriterPrintLongTest(HttpServletRequest req,
                                       HttpServletResponse res,
                                       JspWriter out)
    throws ServletException, IOException {
        out.print(Long.MIN_VALUE);
        out.print(Long.MAX_VALUE);
    }


    public void jspWriterPrintFloatTest(HttpServletRequest req,
                                        HttpServletResponse res,
                                        JspWriter out)
    throws ServletException, IOException {
        out.print(Float.MIN_VALUE);
        out.print(Float.MAX_VALUE);
    }


    public void jspWriterPrintDoubleTest(HttpServletRequest req,
                                         HttpServletResponse res,
                                         JspWriter out)
    throws ServletException, IOException {
        out.print(Double.MIN_VALUE);
        out.print(Double.MAX_VALUE);
    }


    public void jspWriterPrintCharArrayTest(HttpServletRequest req,
                                            HttpServletResponse res,
                                            JspWriter out)
    throws ServletException, IOException {
        char[] c = new char[89];
        for (short i = 33, idx = 0; i < 90; i++, idx++) {
            c[idx] = (char) i;
        }
        out.print(c);
        out.print(c);
    }


    public void jspWriterPrintStringTest(HttpServletRequest req,
                                         HttpServletResponse res,
                                         JspWriter out)
    throws ServletException, IOException {
        out.print("Test ");
        out.print("Passed");
    }


    public void jspWriterPrintNullStringTest(HttpServletRequest req,
                                         HttpServletResponse res,
                                         JspWriter out)
    throws ServletException, IOException {
        String nullString = null;
        out.print(nullString);
    }


    public void jspWriterPrintObjectTest(HttpServletRequest req,
                                         HttpServletResponse res,
                                         JspWriter out)
    throws ServletException, IOException {
        Object o1 = new String("Test ");
        Object o2 = new String("Passed");
        out.print(o1);
        out.print(o2);
    }


    public void jspWriterPrintlnTest(HttpServletRequest req,
                                     HttpServletResponse res,
                                     JspWriter out)
    throws ServletException, IOException {
        out.print("Test Passed");
        out.println();
    }


    public void jspWriterPrintlnBooleanTest(HttpServletRequest req,
                                            HttpServletResponse res,
                                            JspWriter out)
    throws ServletException, IOException {
        out.println(true);
        out.println(false);
    }


    public void jspWriterPrintlnCharTest(HttpServletRequest req,
                                         HttpServletResponse res,
                                         JspWriter out)
    throws ServletException, IOException {
        out.println('a');
        out.println('B');
    }


    public void jspWriterPrintlnIntTest(HttpServletRequest req,
                                        HttpServletResponse res,
                                        JspWriter out)
    throws ServletException, IOException {
        out.println(Integer.MIN_VALUE);
        out.println(Integer.MAX_VALUE);
    }


    public void jspWriterPrintlnLongTest(HttpServletRequest req,
                                         HttpServletResponse res,
                                         JspWriter out)
    throws ServletException, IOException {
        out.println(Long.MIN_VALUE);
        out.println(Long.MAX_VALUE);
    }


    public void jspWriterPrintlnFloatTest(HttpServletRequest req,
                                          HttpServletResponse res,
                                          JspWriter out)
    throws ServletException, IOException {
        out.println(Float.MIN_VALUE);
        out.println(Float.MAX_VALUE);
    }


    public void jspWriterPrintlnDoubleTest(HttpServletRequest req,
                                           HttpServletResponse res,
                                           JspWriter out)
    throws ServletException, IOException {
        out.println(Double.MIN_VALUE);
        out.println(Double.MAX_VALUE);
    }


    public void jspWriterPrintlnCharArrayTest(HttpServletRequest req,
                                              HttpServletResponse res,
                                              JspWriter out)
    throws ServletException, IOException {
        char[] c = new char[89];
        for (short i = 33, idx = 0; i < 90; i++, idx++) {
            c[idx] = (char) i;
        }
        out.println(c);
        out.println(c);
    }


    public void jspWriterPrintlnStringTest(HttpServletRequest req,
                                           HttpServletResponse res,
                                           JspWriter out)
    throws ServletException, IOException {
        out.println("Test ");
        out.println("Passed");
    }


    public void jspWriterPrintlnNullStringTest(HttpServletRequest req,
                                         HttpServletResponse res,
                                         JspWriter out)
    throws ServletException, IOException {
        String nullString = null;
        out.println(nullString);
    }


    public void jspWriterPrintlnObjectTest(HttpServletRequest req,
                                           HttpServletResponse res,
                                           JspWriter out)
    throws ServletException, IOException {
        Object o1 = new String("Test ");
        Object o2 = new String("Passed");
        out.println(o1);
        out.println(o2);
    }


    public void jspWriterClearTest(HttpServletRequest req,
                                   HttpServletResponse res,
                                   JspWriter out)
    throws ServletException, IOException {
        if (out.getBufferSize() > 0) {
            out.println("Test FAILED.  JspWriter not cleared.");
            out.clear();
            out.println("Test PASSED");
        } else {
            out.println("Test PASSED");
        }
    }


    public void jspWriterClearIOExceptionTest(HttpServletRequest req,
                                              HttpServletResponse res,
                                              JspWriter out)
    throws ServletException, IOException {
        if (out.getBufferSize() > 0) {
            out.println("Arbitrary text");
            out.flush();
            try {
                out.clear();
            } catch (Throwable t) {
                if (t instanceof IOException) {
                    out.println("Test PASSED");
                } else {
                    out.println("Test FAILED.  JspWriter.clear() did throw" +
                        "an Exception, but was not an IOException as expected.");
                    out.println("Received:" + t.toString());
                }
            }
        } else {
            out.println("Test PASSED");
        }
    }


    public void jspWriterClearBufferTest(HttpServletRequest req,
                                         HttpServletResponse res,
                                         JspWriter out)
    throws ServletException, IOException {
        if (out.getBufferSize() > 0) {
            out.println("Arbitrary text");
            out.flush();
            out.println("Test FAILED.  JspWriter not cleared.");
            try {
                out.clearBuffer();
            } catch (Throwable t) {
                if (t instanceof IOException) {
                    out.println("Test FAILED.  IOException shouldn't have been" +
                        "thrown by clearBuffer when called after committing the response.");
                    return;
                } else {
                    out.println("Test FAILED.  Unexpeced Exception.");
                    out.println(t.toString());
                }
            }
            out.println("Test PASSED");
        } else {
            out.println("Test PASSED");
        }
    }


    // XXX consider alternate implementation
    public void jspWriterFlushTest(HttpServletRequest req,
                                   HttpServletResponse res,
                                   JspWriter out)
    throws ServletException, IOException {
        if (out.getBufferSize() > 0) {
            out.println("Arbitrary test");
            out.flush();
            try {
                out.clear();
            } catch (Throwable t) {
                if (t instanceof IOException) {
                    out.println("Test PASSED");
                } else {
                    out.println("Test FAILED.  Flush of the stream failed.");
                }
            }
        } else {
            out.println("Test PASSED");
        }
    }


    public void jspWriterCloseTest(HttpServletRequest req,
                                   HttpServletResponse res,
                                   JspWriter out)
    throws ServletException, IOException {
        ServletContext ctx = (ServletContext) req.getAttribute(APPLICATIONCTX_ATTR);
        if (ctx != null) {
            out.close();
            try {
                out.flush();
            } catch (Throwable t) {
                if (t instanceof IOException) {
                    ctx.setAttribute("flush.exception", t);
                }
            }

            try {
                out.println();
            } catch (Throwable t) {
                if (t instanceof IOException) {
                    ctx.setAttribute("write.exception", t);
                }
            }

            try {
                out.close();
            } catch (Throwable t) {
                ctx.setAttribute("close.exception", t);
            }
        } else {
            out.println("Test FAILED.  Unable to access ServletContext.");
        }
    }


    public void jspWriterGetBufferSizeTest(HttpServletRequest req,
                                           HttpServletResponse res,
                                           JspWriter out)
    throws ServletException, IOException {
        int size = out.getBufferSize();
        if (size > 0) {
            if (size >= 8192) {
                out.println("Test PASSED");
            } else {
                out.println("Test FAILED.  Buffer allocated is not of the expected size.");
                out.println("Expected a buffer size greater than or equal to 8192KB");
                out.println("Actual size:" + size);
            }
        } else {
            out.println("Test PASSED");
        }
    }


    public void jspWriterGetRemainingTest(HttpServletRequest req,
                                          HttpServletResponse res,
                                          JspWriter out)
    throws ServletException, IOException {
        String message = "Arbitrary text";
        int messLength = message.length();
        int size = out.getBufferSize();

        if (size > 0) {
            out.clear();
            int gr1 = out.getRemaining();
            if (size == gr1) {
                out.print("Arbitrary text");
                int gr2 = out.getRemaining();
                if (gr2 == (size - messLength)) {
                    out.clear();
                    int gr3 = out.getRemaining();
                    if (size == gr3) {
                        out.println("Test PASSED");
                    } else {
                        out.println("Test FAILED.  (l3) Unexpected result from JspWriter.getRemaining().");
                        out.println("Expected: " + size);
                        out.println("Received: " + gr3);
                    }
                } else {
                    out.println("Test FAILED.  (l2) Unexpected result from JspWriter.getRemaining().");
                    out.println("Expected: " + (size - messLength));
                    out.println("Received: " + gr2);
                }
            } else {
                out.println("Test FAILED.  (l1) Unexpteced result from JspWriter.getRemaining().");
                out.println("Expected: " + size);
                out.println("Received: " + gr1);
            }
        } else {
            out.println("Test PASSED");
        }
    }


    public void jspWriterIsAutoFlushTest(HttpServletRequest req,
                                         HttpServletResponse res,
                                         JspWriter out)
    throws ServletException, IOException {
        if (out.isAutoFlush() == true) {
            out.println("Test PASSED");
        } else {
            out.println("Test FAILED.  Expected JspWriter.isAutoFlush() to return true not false.");
        }
    }

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List<String> _jspx_dependants;

  private org.glassfish.jsp.api.ResourceInjector _jspx_resourceInjector;

  public java.util.List<String> getDependants() {
    return _jspx_dependants;
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;

    try {
      response.setContentType("text/plain");
      response.setHeader("X-Powered-By", "JSP/2.3");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;
      _jspx_resourceInjector = (org.glassfish.jsp.api.ResourceInjector) application.getAttribute("com.sun.appserv.jsp.resource.injector");

      out.write("\n");
      out.write("\n");
      out.write("\n");
      out.write("\n");
      out.write("\n");
      out.write("\n");
      out.write("\n");
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');

    request.setAttribute(APPLICATIONCTX_ATTR, application);

    if (System.getProperty("line.separator").equals("\n")) {
        response.setHeader("Server-EOL", "UNIX");
    } else if (System.getProperty("line.separator").equals("\r\n")) {
        response.setHeader("Server-EOL", "WIN32");
    }

    JspTestUtil.invokeTest(this, request, response, out);

      out.write('\n');
    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          out.clearBuffer();
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
        else throw new ServletException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
